<?php
/**
 * Simple Asatidz Management Page (Repeater Style)
 */

function pondok_register_asatidz_page() {
    $hook = add_submenu_page(
        'pondok-theme-settings', // Parent Slug
        'Kelola Asatidz',
        'Kelola Asatidz',
        'manage_options',
        'pondok-asatidz',
        'pondok_asatidz_page_html'
    );
    add_action( "admin_print_scripts-$hook", 'pondok_asatidz_enqueue_media' );
}
add_action('admin_menu', 'pondok_register_asatidz_page');

function pondok_asatidz_enqueue_media() {
    wp_enqueue_media();
}

function pondok_asatidz_page_html() {
    // Save Logic
    if (isset($_POST['pondok_asatidz_nonce']) && wp_verify_nonce($_POST['pondok_asatidz_nonce'], 'save_asatidz_action')) {
        $asatidz_data = isset($_POST['asatidz']) ? $_POST['asatidz'] : array();
        // Sanitize
        $clean_data = array();
        foreach ($asatidz_data as $guru) {
            if (!empty($guru['nama'])) { // Hanya simpan jika ada namanya
                $clean_data[] = array(
                    'nama' => sanitize_text_field(wp_unslash($guru['nama'])),
                    'jabatan' => sanitize_text_field(wp_unslash($guru['jabatan'])),
                    'bidang' => sanitize_text_field(wp_unslash($guru['bidang'])),
                    'foto' => esc_url_raw(wp_unslash($guru['foto'])),
                    'bio' => sanitize_textarea_field(wp_unslash($guru['bio'])),
                );
            }
        }
        update_option('pondok_asatidz_list', $clean_data);
        echo '<div class="notice notice-success is-dismissible"><p>Data Asatidz berhasil disimpan!</p></div>';
    }

    $existing_data = get_option('pondok_asatidz_list', array());
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola Data Asatidz</h1>
        <hr class="wp-header-end">
        
        <form method="post" action="">
            <?php wp_nonce_field('save_asatidz_action', 'pondok_asatidz_nonce'); ?>
            
            <style>
                .asatidz-row { background: #fff; border: 1px solid #ccd0d4; padding: 15px; margin-bottom: 15px; box-shadow: 0 1px 1px rgba(0,0,0,.04); display: flex; gap: 15px; align-items: flex-start; }
                .asatidz-row .col-img { width: 100px; text-align: center; }
                .asatidz-row .img-preview { width: 80px; height: 80px; object-fit: cover; background: #f0f0f1; display: block; margin: 0 auto 10px; border-radius: 4px; }
                .asatidz-row .col-fields { flex: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 10px; }
                .asatidz-row .full-width { grid-column: span 2; }
                .asatidz-row input[type="text"], .asatidz-row textarea, .asatidz-row select { width: 100%; }
                .asatidz-row .remove-row { color: #b32d2e; align-self: center; cursor: pointer; font-size: 20px; }
            </style>

            <div id="asatidz-container">
                <?php 
                if (!empty($existing_data)) {
                    foreach ($existing_data as $index => $guru) {
                        pondok_render_asatidz_row($index, $guru);
                    }
                } else {
                    // Empty row for start
                    pondok_render_asatidz_row(0);
                }
                ?>
            </div>

            <button type="button" class="button button-secondary" id="add-row-btn">+ Tambah Ustadz/ah</button>
            <hr>
            <button type="submit" class="button button-primary button-hero">Simpan Perubahan</button>
        </form>
    </div>

    <!-- Template for JS -->
    <script type="text/template" id="row-template">
        <?php pondok_render_asatidz_row('INDEX_PLACEHOLDER'); ?>
    </script>

    <script>
    jQuery(document).ready(function($) {
        // Media Uploader Logic
        var mediaUploader;
        var currentButton; // Store reference to the button clicked

        $('#asatidz-container').on('click', '.upload-btn', function(e) {
            e.preventDefault();
            currentButton = $(this); // Capture the button that was clicked
            
            // If the uploader object has already been created, reopen the dialog
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            
            // Extend the wp.media object
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Pilih Foto Ustadz',
                button: { text: 'Gunakan Foto Ini' },
                multiple: false
            });

            // When a file is selected, grab the URL and set it as the text field's value
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                var row = currentButton.closest('.asatidz-row'); // Use the captured button to find row
                row.find('.img-input').val(attachment.url);
                row.find('.img-preview').attr('src', attachment.url);
            });

            // Open the uploader dialog
            mediaUploader.open();
        });

        // Add Row
        $('#add-row-btn').on('click', function() {
            var template = $('#row-template').html();
            var newIndex = $('.asatidz-row').length;
            // Use a unique index based on timestamp to avoid collision if rows deleted
            var timestamp = new Date().getTime(); 
            template = template.replace(/is_dismissible/g, 'dummy'); // Prevent weird WP replace issues if any
            template = template.replace(/INDEX_PLACEHOLDER/g, timestamp);
            
            $('#asatidz-container').append(template);
        });

        // Remove Row
        $('#asatidz-container').on('click', '.remove-row', function() {
            if (confirm('Hapus data ini? (Simpan perubahan agar permanen)')) {
                $(this).closest('.asatidz-row').remove();
            }
        });
    });
    </script>
    <?php
}

function pondok_render_asatidz_row($index, $data = array()) {
    $nama = isset($data['nama']) ? $data['nama'] : '';
    $jabatan = isset($data['jabatan']) ? $data['jabatan'] : '';
    $foto = isset($data['foto']) ? $data['foto'] : '';
    $bio = isset($data['bio']) ? $data['bio'] : '';
    $bidang = isset($data['bidang']) ? $data['bidang'] : '';
    
    // Bidang Options
    // Bidang Options (Simplified)
    $bidang_opts = array(
        'Struktural' => 'Jajaran Pengurus / Struktural',
        'Guru' => 'Dewan Guru / Asatidz',
        'Staff' => 'Staff / Tata Usaha'
    );
    ?>
    <div class="asatidz-row">
        <div class="col-img">
            <img src="<?php echo $foto ? $foto : 'https://via.placeholder.com/80?text=Foto'; ?>" class="img-preview">
            <input type="hidden" name="asatidz[<?php echo $index; ?>][foto]" class="img-input" value="<?php echo $foto; ?>">
            <button class="button upload-btn">Upload</button>
        </div>
        <div class="col-fields">
            <div>
                <label>Nama Lengkap</label>
                <input type="text" name="asatidz[<?php echo $index; ?>][nama]" value="<?php echo esc_attr($nama); ?>" placeholder="Contoh: Ustadz Ahmad">
            </div>
            <div>
                <label>Jabatan Tertulis</label>
                <input type="text" name="asatidz[<?php echo $index; ?>][jabatan]" value="<?php echo esc_attr($jabatan); ?>" placeholder="Contoh: Kepala Sekolah">
            </div>
            <div class="full-width">
                <label>Bidang / Kelompok</label>
                <select name="asatidz[<?php echo $index; ?>][bidang]">
                    <option value="">-- Pilih Bidang --</option>
                    <?php foreach($bidang_opts as $key => $label): ?>
                        <option value="<?php echo $key; ?>" <?php selected($bidang, $key); ?>><?php echo $label; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="full-width">
                <label>Biodata Singkat</label>
                <textarea name="asatidz[<?php echo $index; ?>][bio]" rows="2"><?php echo esc_textarea($bio); ?></textarea>
            </div>
        </div>
        <span class="dashicons dashicons-trash remove-row" title="Hapus"></span>
    </div>
    <?php
}
