<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function pondok_allow_jfif_upload( $mimes ) {
    $mimes['jfif'] = 'image/jpeg';
    return $mimes;
}
add_filter( 'upload_mimes', 'pondok_allow_jfif_upload' );

function pondok_convert_upload_to_webp( $file ) {
    if ( isset( $file['error'] ) || is_wp_error( $file ) ) {
        return $file;
    }

    if ( ! isset( $file['file'] ) || ! file_exists( $file['file'] ) ) {
        return $file;
    }

    $allowed_mimes = array( 'image/jpeg', 'image/png', 'image/pjpeg' );
    $file_ext      = strtolower( pathinfo( $file['file'], PATHINFO_EXTENSION ) );

    if ( ! in_array( $file['type'], $allowed_mimes ) && $file_ext !== 'jfif' ) {
        return $file;
    }

    if ( ! function_exists( 'imagewebp' ) ) {
        return $file;
    }

    $file_path = $file['file'];
    
    @ini_set( 'memory_limit', '256M' );

    $image_editor = wp_get_image_editor( $file_path );

    if ( ! is_wp_error( $image_editor ) ) {
        $file_info = pathinfo( $file_path );
        $dirname   = $file_info['dirname'];
        $filename  = $file_info['filename'];
        
        $new_file_path = $dirname . '/' . $filename . '.webp';

        $image_editor->set_quality( 90 );

        $saved = $image_editor->save( $new_file_path, 'image/webp' );

        if ( ! is_wp_error( $saved ) ) {
            @unlink( $file_path );

            $file['file'] = $new_file_path;
            $file['url']  = str_replace( '.' . $file_info['extension'], '.webp', $file['url'] );
            $file['type'] = 'image/webp';
        }
    }

    return $file;
}
add_filter( 'wp_handle_upload', 'pondok_convert_upload_to_webp' );
