<?php
/**
 * Simple Jadwal KBM Management Page (Repeater Style)
 */

function pondok_register_jadwal_page() {
    add_submenu_page(
        'pondok-theme-settings', // Parent slug
        'Kelola Jadwal KBM',
        'Kelola Jadwal',
        'manage_options',
        'pondok-jadwal',
        'pondok_jadwal_page_html'
    );
}
add_action('admin_menu', 'pondok_register_jadwal_page', 20);

function pondok_jadwal_page_html() {
    // Save Logic
    if (isset($_POST['pondok_jadwal_nonce']) && wp_verify_nonce($_POST['pondok_jadwal_nonce'], 'save_jadwal_action')) {
        $jadwal_data = isset($_POST['jadwal']) ? $_POST['jadwal'] : array();
        // Sanitize
        $clean_data = array();
        foreach ($jadwal_data as $item) {
            if (!empty($item['mapel'])) {
                $clean_data[] = array(
                    'hari' => sanitize_text_field(wp_unslash($item['hari'])),
                    'jam_mulai' => sanitize_text_field(wp_unslash($item['jam_mulai'])),
                    'jam_selesai' => sanitize_text_field(wp_unslash($item['jam_selesai'])),
                    'mapel' => sanitize_text_field(wp_unslash($item['mapel'])),
                    'kelas' => sanitize_text_field(wp_unslash($item['kelas'])),
                    'pengajar' => sanitize_text_field(wp_unslash($item['pengajar'])),
                    'ruang' => sanitize_text_field(wp_unslash($item['ruang'])),
                    'status' => sanitize_text_field(wp_unslash($item['status'])),
                    'tingkat' => sanitize_text_field(wp_unslash($item['tingkat'])), // Untuk filter Ula/Wustha
                );
            }
        }
        
        // Sort by Day and Time logic optional, but saving as is for now
        update_option('pondok_jadwal_list', $clean_data);
        echo '<div class="notice notice-success is-dismissible"><p>Data Jadwal KBM berhasil disimpan!</p></div>';
    }

    $existing_data = get_option('pondok_jadwal_list', array());
    
    // Check Global Focus (Locking)
    $focus_level = function_exists('pondok_get_option') ? pondok_get_option('school_level_focus', '') : '';
    $is_locked = !empty($focus_level);
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola Jadwal KBM</h1>
        <hr class="wp-header-end">
        
        <form method="post" action="">
            <?php wp_nonce_field('save_jadwal_action', 'pondok_jadwal_nonce'); ?>
            
            <style>
                .jadwal-row { background: #fff; border: 1px solid #ccd0d4; padding: 10px; margin-bottom: 10px; box-shadow: 0 1px 1px rgba(0,0,0,.04); display: flex; gap: 10px; align-items: flex-end; flex-wrap: wrap; }
                .jadwal-row .field-group { flex: 1; min-width: 100px; display: flex; flex-direction: column; gap: 2px;}
                .jadwal-row label { font-size: 11px; font-weight: 600; color: #666; }
                .jadwal-row input, .jadwal-row select { width: 100%; }
                .jadwal-row .remove-row { color: #b32d2e; cursor: pointer; padding: 5px; align-self: center; }
                .section-header { margin-top: 20px; font-weight: bold; font-size: 1.2em; border-bottom: 2px solid #ddd; padding-bottom: 5px; margin-bottom: 15px; }
            </style>

            <div id="jadwal-container">
                <?php 
                if (!empty($existing_data)) {
                    foreach ($existing_data as $index => $item) {
                        pondok_render_jadwal_row($index, $item, $focus_level, $is_locked);
                    }
                } else {
                    pondok_render_jadwal_row(0, array(), $focus_level, $is_locked);
                }
                ?>
            </div>

            <button type="button" class="button button-secondary" id="add-row-btn">+ Tambah Jadwal Baris</button>
            <hr>
            <button type="submit" class="button button-primary button-hero">Simpan Perubahan</button>
        </form>
    </div>

    <!-- Template for JS -->
    <script type="text/template" id="row-template">
        <?php pondok_render_jadwal_row('INDEX_PLACEHOLDER', array(), $focus_level, $is_locked); ?>
    </script>

    <script>
    jQuery(document).ready(function($) {
        $('#add-row-btn').on('click', function() {
            var template = $('#row-template').html();
            var timestamp = new Date().getTime(); 
            template = template.replace(/INDEX_PLACEHOLDER/g, timestamp);
            $('#jadwal-container').append(template);
        });

        $('#jadwal-container').on('click', '.remove-row', function() {
            if (confirm('Hapus baris ini?')) {
                $(this).closest('.jadwal-row').remove();
            }
        });
    });
    </script>
    <?php
}

function pondok_render_jadwal_row($index, $data = array(), $focus_level = '', $is_locked = false) {
    $hari = isset($data['hari']) ? $data['hari'] : 'Senin';
    $jam_mulai = isset($data['jam_mulai']) ? $data['jam_mulai'] : '07:00';
    $jam_selesai = isset($data['jam_selesai']) ? $data['jam_selesai'] : '08:30';
    $mapel = isset($data['mapel']) ? $data['mapel'] : '';
    $kelas = isset($data['kelas']) ? $data['kelas'] : '7A';
    $pengajar = isset($data['pengajar']) ? $data['pengajar'] : '';
    $ruang = isset($data['ruang']) ? $data['ruang'] : 'R. 101';
    $status = isset($data['status']) ? $data['status'] : 'Aktif';
    $tingkat = isset($data['tingkat']) ? $data['tingkat'] : '';
    
    // Auto-fill default for new items only
    if($is_locked && empty($tingkat)) {
        $tingkat = $focus_level;
    }

    $days = array('Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu', 'Ahad');
    $statuses = array('Aktif', 'Libur', 'Pengganti', 'Kosong');
    $levels = array('Wustho', 'Ulya');
    ?>
    <div class="jadwal-row">
        <div class="field-group" style="max-width: 80px;">
            <label>Hari</label>
            <select name="jadwal[<?php echo $index; ?>][hari]">
                <?php foreach($days as $d): ?>
                    <option value="<?php echo $d; ?>" <?php selected($hari, $d); ?>><?php echo $d; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="field-group" style="max-width: 70px;">
            <label>Mulai</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][jam_mulai]" value="<?php echo esc_attr($jam_mulai); ?>" placeholder="07:00">
        </div>
        <div class="field-group" style="max-width: 70px;">
            <label>Selesai</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][jam_selesai]" value="<?php echo esc_attr($jam_selesai); ?>" placeholder="08:30">
        </div>
        <div class="field-group" style="flex: 2;">
            <label>Mata Pelajaran</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][mapel]" value="<?php echo esc_attr($mapel); ?>" placeholder="Matematika">
        </div>
        <div class="field-group" style="max-width: 60px;">
            <label>Kelas</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][kelas]" value="<?php echo esc_attr($kelas); ?>" placeholder="7A">
        </div>
        <div class="field-group" style="flex: 1.5;">
            <label>Pengajar (Nama/Kode)</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][pengajar]" value="<?php echo esc_attr($pengajar); ?>" placeholder="Budi S.Pd">
        </div>
        <div class="field-group" style="max-width: 60px;">
            <label>Ruang</label>
            <input type="text" name="jadwal[<?php echo $index; ?>][ruang]" value="<?php echo esc_attr($ruang); ?>" placeholder="101">
        </div>
        <div class="field-group" style="max-width: 90px;">
            <label>Status</label>
            <select name="jadwal[<?php echo $index; ?>][status]">
                <?php foreach($statuses as $s): ?>
                    <option value="<?php echo $s; ?>" <?php selected($status, $s); ?>><?php echo $s; ?></option>
                <?php endforeach; ?>
            </select>
        </div>
         <div class="field-group" style="max-width: 80px;">
            <label>Tingkat</label>
            <select name="jadwal[<?php echo $index; ?>][tingkat]">
                <option value="">Umum</option>
                <?php foreach($levels as $l): ?>
                    <option value="<?php echo $l; ?>" <?php selected($tingkat, $l); ?>><?php echo $l; ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <span class="dashicons dashicons-trash remove-row" title="Hapus"></span>
    </div>
    <?php
}
