<?php
/**
 * Simple Agenda Settings Page
 * 
 * Provides a simple interface to manage academic calendar events.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function pondok_register_agenda_settings() {
    add_submenu_page(
        'pondok-theme-settings', // Parent slug
        'Kelola Agenda',
        'Kelola Agenda',
        'manage_options',
        'pondok-agenda-settings',
        'pondok_render_agenda_settings_page'
    );
}
add_action('admin_menu', 'pondok_register_agenda_settings', 20);

function pondok_render_agenda_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // Save Logic
    if (isset($_POST['pondok_agenda_save_nonce']) && wp_verify_nonce($_POST['pondok_agenda_save_nonce'], 'pondok_save_agenda')) {
        $agenda_data = array();
        
        if (isset($_POST['agenda']) && is_array($_POST['agenda'])) {
            foreach ($_POST['agenda'] as $item) {
                // Sanitize input
                $date = sanitize_text_field($item['date']);
                $title = sanitize_text_field($item['title']);
                $category = sanitize_text_field($item['category']);
                $time = sanitize_text_field($item['time']); // e.g., 08:00 - 12:00
                
                if (!empty($date) && !empty($title)) {
                    $agenda_data[] = array(
                        'date' => $date, // YYYY-MM-DD format preferred
                        'title' => $title,
                        'category' => $category,
                        'time' => $time
                    );
                }
            }
        }
        
        // Sort by date ascending
        usort($agenda_data, function($a, $b) {
            return strtotime($a['date']) - strtotime($b['date']);
        });

        update_option('pondok_agenda_list', $agenda_data);
        echo '<div class="notice notice-success is-dismissible"><p>Data agenda berhasil disimpan.</p></div>';
    }

    $agenda_list = get_option('pondok_agenda_list', array());

    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola Agenda & Kalender Akademik</h1>
        <hr class="wp-header-end">

        <form method="post" action="">
            <?php wp_nonce_field('pondok_save_agenda', 'pondok_agenda_save_nonce'); ?>
            
            <div id="agenda-repeater">
                <table class="widefat fixed striped" style="margin-bottom: 20px;">
                    <thead>
                        <tr>
                            <th style="width: 150px;">Tanggal</th>
                            <th>Nama Kegiatan / Agenda</th>
                            <th style="width: 150px;">Kategori</th>
                            <th style="width: 150px;">Waktu (Opsional)</th>
                            <th style="width: 50px;">Hapus</th>
                        </tr>
                    </thead>
                    <tbody id="agenda-rows">
                        <?php 
                        if (!empty($agenda_list)) {
                            foreach ($agenda_list as $index => $item) {
                                ?>
                                <tr>
                                    <td>
                                        <input type="date" name="agenda[<?php echo $index; ?>][date]" value="<?php echo esc_attr($item['date']); ?>" class="widefat" required>
                                    </td>
                                    <td>
                                        <input type="text" name="agenda[<?php echo $index; ?>][title]" value="<?php echo esc_attr($item['title']); ?>" class="widefat" placeholder="Contoh: Ujian Tengah Semester">
                                    </td>
                                    <td>
                                        <select name="agenda[<?php echo $index; ?>][category]" class="widefat">
                                            <option value="Akademik" <?php selected($item['category'], 'Akademik'); ?>>Akademik (Biru)</option>
                                            <option value="Libur" <?php selected($item['category'], 'Libur'); ?>>Libur Nasional (Merah)</option>
                                            <option value="Kegiatan" <?php selected($item['category'], 'Kegiatan'); ?>>Kegiatan Santri (Oranye)</option>
                                            <option value="Pendaftaran" <?php selected($item['category'], 'Pendaftaran'); ?>>Pendaftaran (Hijau)</option>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" name="agenda[<?php echo $index; ?>][time]" value="<?php echo isset($item['time']) ? esc_attr($item['time']) : ''; ?>" class="widefat" placeholder="08:00 - 12:00">
                                    </td>
                                    <td>
                                        <button type="button" class="button remove-row"><span class="dashicons dashicons-trash" style="color: #d63638;"></span></button>
                                    </td>
                                </tr>
                                <?php
                            }
                        }
                        ?>
                    </tbody>
                </table>
                
                <button type="button" id="add-row" class="button button-secondary">+ Tambah Agenda</button>
            </div>

            <br><br>
            <button type="submit" class="button button-primary button-large">Simpan Perubahan</button>
        </form>
    </div>

    <script>
    jQuery(document).ready(function($) {
        var container = $('#agenda-rows');
        
        $('#add-row').on('click', function() {
            var index = new Date().getTime(); // Unique ID
            var row = `
                <tr>
                    <td>
                        <input type="date" name="agenda[${index}][date]" class="widefat" required>
                    </td>
                    <td>
                        <input type="text" name="agenda[${index}][title]" class="widefat" placeholder="Kegiatan Baru">
                    </td>
                    <td>
                        <select name="agenda[${index}][category]" class="widefat">
                            <option value="Akademik">Akademik (Biru)</option>
                            <option value="Libur">Libur Nasional (Merah)</option>
                            <option value="Kegiatan">Kegiatan Santri (Oranye)</option>
                            <option value="Pendaftaran">Pendaftaran (Hijau)</option>
                        </select>
                    </td>
                    <td>
                        <input type="text" name="agenda[${index}][time]" class="widefat" placeholder="08:00 - 12:00">
                    </td>
                    <td>
                        <button type="button" class="button remove-row"><span class="dashicons dashicons-trash" style="color: #d63638;"></span></button>
                    </td>
                </tr>
            `;
            container.append(row);
        });

        $(document).on('click', '.remove-row', function() {
            if(confirm('Hapus agenda ini?')) {
                $(this).closest('tr').remove();
            }
        });
    });
    </script>
    <?php
}
