<?php
/**
 * Simple Legalitas Settings Page
 * 
 * Provides a simple interface to manage SK Pendirian & Legalitas documents.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function pondok_register_legalitas_settings() {
    add_submenu_page(
        'pondok-theme-settings', // Parent Slug
        'Kelola Legalitas',
        'Kelola Legalitas',
        'manage_options',
        'pondok-legalitas-settings',
        'pondok_render_legalitas_settings_page'
    );
}
add_action('admin_menu', 'pondok_register_legalitas_settings');

function pondok_render_legalitas_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // Save Logic
    if (isset($_POST['pondok_legalitas_save_nonce']) && wp_verify_nonce($_POST['pondok_legalitas_save_nonce'], 'pondok_save_legalitas')) {
        
        // Main SK Data
        $main_sk = array(
            'nomor' => sanitize_text_field($_POST['sk_nomor']),
            'tanggal' => sanitize_text_field($_POST['sk_tanggal']),
            'lokasi' => sanitize_text_field($_POST['sk_lokasi']),
            'notaris' => sanitize_text_field($_POST['sk_notaris']),
            'status' => sanitize_text_field($_POST['sk_status']),
            'tentang' => sanitize_textarea_field($_POST['sk_tentang']),
            'file_url' => esc_url_raw($_POST['sk_file_url']),
        );
        update_option('pondok_legalitas_main', $main_sk);

        // Other Docs Repeater
        $other_docs = array();
        if (isset($_POST['docs']) && is_array($_POST['docs'])) {
            foreach ($_POST['docs'] as $item) {
                if (!empty($item['title'])) {
                    $other_docs[] = array(
                        'title' => sanitize_text_field($item['title']),
                        'desc' => sanitize_textarea_field($item['desc']),
                        'issuer' => sanitize_text_field($item['issuer']),
                        'icon' => sanitize_text_field($item['icon']),
                        'file_url' => esc_url_raw($item['file_url']),
                    );
                }
            }
        }
        update_option('pondok_legalitas_others', $other_docs);
        
        echo '<div class="notice notice-success is-dismissible"><p>Data legalitas berhasil disimpan.</p></div>';
    }

    // Load Data
    $main_sk = get_option('pondok_legalitas_main', array(
        'nomor' => 'AHU-0012345.AH.01.04.Tahun 2020',
        'tanggal' => '20 Januari 2020',
        'lokasi' => 'Jakarta',
        'notaris' => 'H. Muhammad Zulkarnain, S.H., M.Kn.',
        'status' => 'Aktif / Valid',
        'tentang' => 'Pengesahan Pendirian Badan Hukum Yayasan Pondok Dengan sebagai penyelenggara pendidikan.',
        'file_url' => ''
    ));
    $other_docs = get_option('pondok_legalitas_others', array());

    // Enqueue Media
    wp_enqueue_media();
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola SK Pendirian & Legalitas</h1>
        <hr class="wp-header-end">

        <form method="post" action="">
            <?php wp_nonce_field('pondok_save_legalitas', 'pondok_legalitas_save_nonce'); ?>
            
            <!-- SECTION 1: SK UTAMA -->
            <div class="card" style="padding: 20px; max-width: 800px; margin-bottom: 20px;">
                <h2>Dokumen Utama: Keputusan Menteri Hukum dan HAM</h2>
                <table class="form-table">
                    <tr>
                        <th><label>Nomor Keputusan</label></th>
                        <td><input type="text" name="sk_nomor" value="<?php echo esc_attr($main_sk['nomor']); ?>" class="large-text"></td>
                    </tr>
                    <tr>
                        <th><label>Tanggal Penetapan</label></th>
                        <td><input type="text" name="sk_tanggal" value="<?php echo esc_attr($main_sk['tanggal']); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label>Ditetapkan Di</label></th>
                        <td><input type="text" name="sk_lokasi" value="<?php echo esc_attr($main_sk['lokasi']); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label>Notaris</label></th>
                        <td><input type="text" name="sk_notaris" value="<?php echo esc_attr($main_sk['notaris']); ?>" class="large-text"></td>
                    </tr>
                    <tr>
                        <th><label>Status</label></th>
                        <td><input type="text" name="sk_status" value="<?php echo esc_attr($main_sk['status']); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label>Tentang</label></th>
                        <td><textarea name="sk_tentang" rows="3" class="large-text"><?php echo esc_textarea($main_sk['tentang']); ?></textarea></td>
                    </tr>
                    <tr>
                        <th><label>File PDF SK Utama</label></th>
                        <td>
                            <input type="text" name="sk_file_url" id="sk_file_url" value="<?php echo esc_attr($main_sk['file_url']); ?>" class="large-text">
                            <button type="button" class="button upload-btn" data-target="#sk_file_url">Upload PDF</button>
                        </td>
                    </tr>
                </table>
            </div>

            <!-- SECTION 2: DOKUMEN LAINNYA -->
            <h2>Dokumen Legalitas Lainnya</h2>
            <div id="docs-repeater">
                <?php 
                if (!empty($other_docs)) {
                    foreach ($other_docs as $index => $item) {
                        ?>
                        <div class="card doc-item" style="padding: 15px; margin-bottom: 15px; max-width: 800px;">
                            <h3 style="margin-top:0;">Dokumen #<?php echo $index + 1; ?> <button type="button" class="button remove-row" style="float:right; color: #d63638; border-color: #d63638;">Hapus</button></h3>
                            <p>
                                <label>Judul Dokumen:</label><br>
                                <input type="text" name="docs[<?php echo $index; ?>][title]" value="<?php echo esc_attr($item['title']); ?>" class="large-text">
                            </p>
                            <p>
                                <label>Deskripsi Singkat:</label><br>
                                <textarea name="docs[<?php echo $index; ?>][desc]" rows="2" class="large-text"><?php echo esc_textarea($item['desc']); ?></textarea>
                            </p>
                            <div style="display: flex; gap: 10px;">
                                <div style="flex:1;">
                                    <label>Penerbit / Instansi:</label><br>
                                    <input type="text" name="docs[<?php echo $index; ?>][issuer]" value="<?php echo esc_attr($item['issuer']); ?>" class="widefat">
                                </div>
                                <div style="flex:1;">
                                    <label>Material Icon Name:</label><br>
                                    <input type="text" name="docs[<?php echo $index; ?>][icon]" value="<?php echo esc_attr($item['icon']); ?>" class="widefat" placeholder="verified">
                                </div>
                            </div>
                            <p>
                                <label>File URL (PDF/Gambar):</label><br>
                                <input type="text" name="docs[<?php echo $index; ?>][file_url]" id="doc_url_<?php echo $index; ?>" value="<?php echo esc_attr($item['file_url']); ?>" class="large-text">
                                <button type="button" class="button upload-btn" data-target="#doc_url_<?php echo $index; ?>">Upload File</button>
                            </p>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
            
            <button type="button" id="add-row" class="button button-secondary">+ Tambah Dokumen Lain</button>

            <br><br>
            <button type="submit" class="button button-primary button-large">Simpan Perubahan</button>
        </form>
    </div>

    <!-- JS Template for Repeater -->
    <script type="text/template" id="doc-template">
        <div class="card doc-item" style="padding: 15px; margin-bottom: 15px; max-width: 800px;">
            <h3 style="margin-top:0;">Dokumen Baru <button type="button" class="button remove-row" style="float:right; color: #d63638; border-color: #d63638;">Hapus</button></h3>
            <p>
                <label>Judul Dokumen:</label><br>
                <input type="text" name="docs[INDEX][title]" class="large-text" placeholder="Contoh: Ijin Operasional">
            </p>
            <p>
                <label>Deskripsi Singkat:</label><br>
                <textarea name="docs[INDEX][desc]" rows="2" class="large-text"></textarea>
            </p>
            <div style="display: flex; gap: 10px;">
                <div style="flex:1;">
                    <label>Penerbit / Instansi:</label><br>
                    <input type="text" name="docs[INDEX][issuer]" class="widefat" placeholder="Dinas Pendidikan">
                </div>
                <div style="flex:1;">
                    <label>Material Icon Name:</label><br>
                    <input type="text" name="docs[INDEX][icon]" class="widefat" value="description">
                </div>
            </div>
            <p>
                <label>File URL (PDF/Gambar):</label><br>
                <input type="text" name="docs[INDEX][file_url]" id="doc_url_INDEX" class="large-text">
                <button type="button" class="button upload-btn" data-target="#doc_url_INDEX">Upload File</button>
            </p>
        </div>
    </script>

    <script>
    jQuery(document).ready(function($) {
        // Media Uploader
        $(document).on('click', '.upload-btn', function(e) {
            e.preventDefault();
            var button = $(this);
            var targetInput = $(button.data('target'));
            
            var custom_uploader = wp.media({
                title: 'Pilih Dokumen',
                button: { text: 'Gunakan Dokumen Ini' },
                multiple: false
            }).on('select', function() {
                var attachment = custom_uploader.state().get('selection').first().toJSON();
                targetInput.val(attachment.url);
            }).open();
        });

        // Repeater Logic
        $('#add-row').on('click', function() {
            var template = $('#doc-template').html();
            var index = new Date().getTime();
            template = template.replace(/INDEX/g, index);
            $('#docs-repeater').append(template);
        });

        $(document).on('click', '.remove-row', function() {
            if(confirm('Hapus dokumen ini?')) {
                $(this).closest('.doc-item').remove();
            }
        });
    });
    </script>
    <?php
}
