<?php
/* 
=====================================================
   SISTEM PSB (PENERIMAAN SANTRI BARU) 
   Module: psb-system.php
=====================================================
*/

// 1. Register Custom Post Type for Registrations
function pondok_register_psb_cpt_direct() {
    $labels = array(
        'name'                  => 'Data Pendaftar',
        'singular_name'         => 'Pendaftar',
        'menu_name'             => 'Data Pendaftar',
        'name_admin_bar'        => 'Pendaftar Baru',
        'all_items'             => 'Semua Pendaftar',
        'not_found'             => 'Tidak ada pendaftar.',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => false, 
        'publicly_queryable' => false,
        'show_ui'            => true,
        'show_in_menu'       => true, // Temporary Top Level for Safety
        'menu_icon'          => 'dashicons-groups',
        'query_var'          => true,
        'capability_type'    => 'post',
        'menu_position'      => 3,
        'supports'           => array('title'), 
    );

    register_post_type('psb_registration', $args);
}
add_action('init', 'pondok_register_psb_cpt_direct');

// 2. Add Custom Columns & Filters
function pondok_psb_columns_direct($columns) {
    return array(
        'cb' => $columns['cb'],
        'title' => 'Nama Santri',
        'jenjang' => 'Jenjang',
        'nisn' => 'NISN / NIK',
        'status_pendaftaran' => 'Status',
        'kontak' => 'Kontak',
        'date' => 'Tgl Daftar'
    );
}
add_filter('manage_psb_registration_posts_columns', 'pondok_psb_columns_direct');

function pondok_psb_custom_column_direct($column, $post_id) {
    if ($column == 'nisn') {
        echo '<b>'.get_post_meta($post_id, 'psb_nisn', true).'</b>';
        echo '<br><span style="color:#888;font-size:11px;">'.get_post_meta($post_id, 'psb_nik', true).'</span>'; 
    }
    if ($column == 'jenjang') {
        echo '<span style="font-weight:500; color:#2271b1">'.get_post_meta($post_id, 'psb_jenjang', true).'</span>';
    }
    if ($column == 'kontak') {
        echo get_post_meta($post_id, 'psb_telepon', true); 
    }
    if ($column == 'status_pendaftaran') {
        $st = get_post_meta($post_id, 'psb_status', true) ?: 'Baru';
        $bg = ($st=='Diterima')?'#46b450':(($st=='Ditolak')?'#d63638':(($st=='Verifikasi')?'#f0ad4e':'#2271b1'));
        echo "<span class='psb-badge' style='background:$bg;'>$st</span>";
    }
}
add_action('manage_psb_registration_posts_custom_column', 'pondok_psb_custom_column_direct', 10, 2);

// Filter Dropdowns
function pondok_psb_add_filters(){
    global $typenow;
    if($typenow == 'psb_registration'){
        // Filter Jenjang
        $current_jenjang = isset($_GET['filter_jenjang']) ? $_GET['filter_jenjang'] : '';
        echo '<select name="filter_jenjang"><option value="">Semua Jenjang</option>';
        foreach(['Ula','Wustho','Ulya'] as $j) echo '<option value="'.$j.'" '.selected($current_jenjang,$j,false).'>'.$j.'</option>';
        echo '</select>';

        // Filter Status
        $current_status = isset($_GET['filter_status']) ? $_GET['filter_status'] : '';
        echo '<select name="filter_status"><option value="">Semua Status</option>';
        foreach(['Baru','Verifikasi','Diterima','Ditolak'] as $s) echo '<option value="'.$s.'" '.selected($current_status,$s,false).'>'.$s.'</option>';
        echo '</select>';
    }
}
add_action('restrict_manage_posts','pondok_psb_add_filters');

// Handle Filter Logic
function pondok_psb_filter_query($query){
    global $pagenow;
    if($pagenow=='edit.php' && isset($_GET['post_type']) && $_GET['post_type']=='psb_registration'){
        $meta_query = array();
        if(!empty($_GET['filter_jenjang'])) {
            $meta_query[] = array('key'=>'psb_jenjang','value'=>$_GET['filter_jenjang']);
        }
        if(!empty($_GET['filter_status'])) {
            $meta_query[] = array('key'=>'psb_status','value'=>$_GET['filter_status']);
        }
        if(!empty($meta_query)) $query->set('meta_query',$meta_query);
    }
}
add_filter('parse_query','pondok_psb_filter_query');

// Styling Admin Table
function pondok_psb_admin_styles(){
    echo '<style>
        .type-psb_registration .column-status_pendaftaran { width: 100px; }
        .type-psb_registration .column-jenjang { width: 80px; }
        .type-psb_registration .column-nisn { width: 120px; }
        .psb-badge { color:white; padding:4px 8px; border-radius:4px; font-weight:bold; font-size:11px; display:inline-block; text-align:center; min-width:60px; }
        .type-psb_registration tr:hover { background-color: #f0f6fc !important; }
    </style>';
}
add_action('admin_head', 'pondok_psb_admin_styles');

// 3. AJAX Submission Handler
function pondok_handle_submission_direct() {
    // Try JSON first
    $json = file_get_contents('php://input');
    $data_json = json_decode($json, true);
    
    // Setup Variables (Support JSON structure OR Flattened $_POST)
    $nama = ''; $nisn = ''; $jenjang = '';
    
    if (!empty($data_json)) {
        // Source: JSON
        $nama = sanitize_text_field($data_json['step1']['nama'] ?? '');
        $nisn = sanitize_text_field($data_json['step1']['nisn'] ?? '');
        $jenjang = sanitize_text_field($data_json['step1']['jenjang'] ?? '');
        $data = $data_json;
    } else {
        // Source: $_POST (FormData)
        $nama = sanitize_text_field($_POST['nama'] ?? '');
        $nisn = sanitize_text_field($_POST['nisn'] ?? '');
        $jenjang = sanitize_text_field($_POST['jenjang'] ?? '');
        $data = array( 'step1' => $_POST, 'step2' => $_POST, 'step3' => $_POST ); // Flattened
    }
    
    if(empty($nama)) {
        wp_send_json_error(['message'=>'Data Nama Kosong!']); 
    }

    $pid = wp_insert_post(['post_title' => $nama.' - Jenjang: '.$jenjang, 'post_type' => 'psb_registration', 'post_status' => 'publish']);
    
    if($pid && !is_wp_error($pid)) {
        // 1. Generate UUID (For System/URL Safety)
        $uuid = wp_generate_uuid4();
        update_post_meta($pid, 'psb_uuid', $uuid);

        // 2. Generate Human Readable Reg Number (PSB-YYYY-XXXX)
        $year = date('Y');
        $counter_key = 'psb_reg_counter_' . $year;
        $current_count = (int) get_option($counter_key, 0);
        $new_count = $current_count + 1;
        update_option($counter_key, $new_count);

        $reg_code = 'PSB-' . $year . '-' . sprintf('%04d', $new_count); 
        update_post_meta($pid, 'psb_reg_code', $reg_code);

        // Update Title for easier admin search
        $update_args = array(
            'ID'         => $pid,
            'post_title' => $reg_code . ' - ' . $nama
        );
        wp_update_post( $update_args );

        // Save Metadata - COMPLETE LIST
        update_post_meta($pid, 'psb_nama', $nama);
        update_post_meta($pid, 'psb_nisn', $nisn);
        update_post_meta($pid, 'psb_jenjang', $jenjang);
        
        // ... (rest of metadata)
        
        $fields = [
            // Data Pribadi
            'nik', 'no_kk', 'tempat_lahir', 'tanggal_lahir', 'gender', 
            'hobi', 'cita_cita', 'anak_ke', 'jumlah_saudara',
            
            // Pendidikan & Alamat
            'asal_sekolah', 'npsn_sekolah', // Added NPSN if available
            'alamat', 'alamat_desa', 'alamat_kecamatan', 'alamat_kabupaten', 'alamat_provinsi', 'alamat_kodepos', 
            'telepon', 'email', 
            
             // Uploads
            'file_kk', 'file_foto',

            // Ortu Ayah
            'nama_ayah', 'nik_ayah', 'pekerjaan_ayah', 'pendidikan_ayah', 'penghasilan_ayah',
            
            // Ortu Ibu
            'nama_ibu', 'nik_ibu', 'pekerjaan_ibu', 'pendidikan_ibu', 'penghasilan_ibu',
            
            // Wali
            'nama_wali', 'nik_wali', 'pekerjaan_wali', 'hubungan_wali'
        ];

        foreach($fields as $f) {
            // Check multiple sources (JSON structure or Direct POST)
            $val = '';
            if(isset($data['step1'][$f])) $val = $data['step1'][$f];
            elseif(isset($data['step2'][$f])) $val = $data['step2'][$f];
            elseif(isset($data['step3'][$f])) $val = $data['step3'][$f];
            elseif(isset($_POST[$f])) $val = $_POST[$f];
            
            update_post_meta($pid, 'psb_'.$f, sanitize_text_field($val));
        }

        // Handle File Uploads (Standard PHP $_FILES)
        if(!function_exists('wp_handle_upload')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            require_once(ABSPATH . 'wp-admin/includes/media.php');
            require_once(ABSPATH . 'wp-admin/includes/image.php');
        }

        if(!empty($_FILES['file_kk']['name'])) {
            $file = $_FILES['file_kk'];
            // KK Allowed: Images + PDF
            $allowed_mimes = ['image/jpeg', 'image/png', 'image/jpg', 'application/pdf'];
            
            $file_mime = $file['type']; // Default fallback
            if(function_exists('mime_content_type')) {
                $file_mime = mime_content_type($file['tmp_name']);
            }
            
            if(in_array($file_mime, $allowed_mimes)) {
                 $upload = wp_handle_upload($file, ['test_form' => false]);
                 if(isset($upload['url'])) update_post_meta($pid, 'psb_file_kk', $upload['url']);
            }
        }
        if(!empty($_FILES['file_foto']['name'])) {
            $file = $_FILES['file_foto'];
            // Foto Allowed: Images Only
            $allowed_mimes = ['image/jpeg', 'image/png', 'image/jpg'];
            
            $file_mime = $file['type']; // Default fallback
            if(function_exists('mime_content_type')) {
                $file_mime = mime_content_type($file['tmp_name']);
            }
            
            if(in_array($file_mime, $allowed_mimes)) {
                $upload = wp_handle_upload($file, ['test_form' => false]);
                if(isset($upload['url'])) update_post_meta($pid, 'psb_file_foto', $upload['url']);
            }
        }

        update_post_meta($pid, 'psb_status', 'Baru');
        
        // Return Success with Redirect URL
        $redirect_url = home_url('/pembayaran-psb/'.$uuid);
        wp_send_json_success(['id'=>$pid, 'uuid'=>$uuid, 'reg_code'=>$reg_code, 'redirect_url'=>$redirect_url]);
    } else {
        wp_send_json_error(['message'=>'Gagal Simpan ke Database.']);
    }
}
add_action('wp_ajax_nopriv_pondok_submit_psb', 'pondok_handle_submission_direct');
add_action('wp_ajax_pondok_submit_psb', 'pondok_handle_submission_direct');

// 4. Meta Box Detail
function pondok_add_meta_psb_direct(){ add_meta_box('psb_det','Data Lengkap Santri','pondok_render_psb_direct','psb_registration','normal','high'); }
add_action('add_meta_boxes','pondok_add_meta_psb_direct');

function pondok_render_psb_direct($post){
    $m = get_post_custom($post->ID);
    $v = function($k)use($m){ return isset($m[$k][0]) ? $m[$k][0] : '-'; };
    
    // Status Logic
    $st = $v('psb_status');
    $st_color = '#2271b1';
    if($st == 'Diterima') $st_color = '#46b450';
    if($st == 'Ditolak') $st_color = '#d63638';
    if($st == 'Verifikasi') $st_color = '#f0ad4e';

    echo '<div style="background:#fff; padding:0; margin-top:10px;">';
        
        // Header Actions
        echo '<div style="background:#f0f6fc; padding:15px; border:1px solid #c5d7ed; border-left:4px solid '.$st_color.'; display:flex; justify-content:space-between; align-items:center; margin-bottom:20px;">
            <div>
                <h2 style="margin:0; font-size:18px; color:#1d2327;">Status: <span style="font-weight:bold; color:'.$st_color.'">'.strtoupper($st).'</span></h2>
                <p style="margin:5px 0 0; color:#646970;">UUID: '.$v('psb_uuid').' | Tanggal Daftar: '.get_the_date('d M Y, H:i').'</p>
            </div>
            <div style="display:flex; align-items:center; gap:10px;">
                <label for="psb_st" style="font-weight:600;">Ubah Status:</label>
                <select name="psb_st" id="psb_st" style="width:150px;">';
                foreach(['Baru','Verifikasi','Diterima','Ditolak','Cadangan'] as $s) echo "<option value='$s' ".selected($st,$s,0).">$s</option>";
        echo '  </select>
                <button type="submit" class="button button-primary">Update</button>
            </div>
        </div>';

        // Layout Grid
        echo '<div style="display:grid; grid-template-columns: 1fr 1fr; gap:20px;">';
            
            // COL 1
            echo '<div>';
                
                // Section: Data Diri (Editable for Correction)
                echo '<div style="border:1px solid #eee; padding:15px; border-radius:5px; margin-bottom:20px;">';
                echo '<h3 style="margin-top:0; border-bottom:1px solid #eee; padding-bottom:10px;">👤 Identitas Santri (Mode Koreksi)</h3>';
                echo '<table class="widefat striped" style="border:0;"><tbody>';
                    // Editable Fields
                    echo '<tr><td style="width:140px;">Nama Lengkap</td><td><input type="text" name="psb_nama" value="'.$v('psb_nama').'" style="width:100%;"></td></tr>';
                    echo '<tr><td>NISN</td><td><input type="text" name="psb_nisn" value="'.$v('psb_nisn').'" style="width:100%;"></td></tr>';
                    echo '<tr><td>NIK</td><td><input type="text" name="psb_nik" value="'.$v('psb_nik').'" style="width:100%;"></td></tr>';
                    echo '<tr><td>No. KK</td><td><input type="text" name="psb_no_kk" value="'.$v('psb_no_kk').'" style="width:100%;"></td></tr>';
                    echo '<tr><td>Jenjang</td><td><input type="text" name="psb_jenjang" value="'.$v('psb_jenjang').'" style="width:100%;"></td></tr>';
                    
                    // Read-only info
                    echo '<tr><td>TTL</td><td>'.$v('psb_tempat_lahir').', '.$v('psb_tanggal_lahir').'</td></tr>';
                    echo '<tr><td>Jenis Kelamin</td><td>'.$v('psb_gender').'</td></tr>';
                    echo '<tr><td>Anak ke</td><td>'.$v('psb_anak_ke').' dari '.$v('psb_jumlah_saudara').' bersaudara</td></tr>';
                echo '</tbody></table>';
                echo '<p style="color:#666; font-size:11px; font-style:italic;">* Edit nilai di kolom input lalu klik Update di pojok kanan atas untuk menyimpan koreksi.</p>';
                echo '</div>';

                // Section: Pendidikan & Alamat
                echo '<div style="border:1px solid #eee; padding:15px; border-radius:5px; margin-bottom:20px;">';
                echo '<h3 style="margin-top:0; border-bottom:1px solid #eee; padding-bottom:10px;">🏫 Pendidikan & Alamat</h3>';
                echo '<table class="widefat striped" style="border:0;"><tbody>';
                    echo '<tr><td>Jenjang Dituju</td><td><span style="background:#e5f5fa; color:#0e5a7e; padding:2px 6px; border-radius:3px; font-weight:bold;">'.$v('psb_jenjang').'</span></td></tr>';
                    echo '<tr><td>Asal Sekolah</td><td>'.$v('psb_asal_sekolah').'</td></tr>';
                    echo '<tr><td>Alamat Jalan</td><td>'.nl2br($v('psb_alamat')).'</td></tr>';
                    echo '<tr><td>Desa / Kelurahan</td><td>'.$v('psb_alamat_desa').'</td></tr>';
                    echo '<tr><td>Kecamatan</td><td>'.$v('psb_alamat_kecamatan').'</td></tr>';
                    echo '<tr><td>Kab / Kota</td><td>'.$v('psb_alamat_kabupaten').'</td></tr>';
                    echo '<tr><td>Provinsi</td><td>'.$v('psb_alamat_provinsi').'</td></tr>';
                    echo '<tr><td>Kode Pos</td><td>'.$v('psb_alamat_kodepos').'</td></tr>';
                echo '</tbody></table>';
                echo '</div>';

            echo '</div>'; // End Col 1

            // COL 2
            echo '<div>';
                
                // Section: Orang Tua
                echo '<div style="border:1px solid #eee; padding:15px; border-radius:5px; margin-bottom:20px;">';
                echo '<h3 style="margin-top:0; border-bottom:1px solid #eee; padding-bottom:10px;">👨‍👩‍👧 Data Orang Tua</h3>';
                
                // Ayah
                echo '<strong style="display:block; margin-bottom:5px; color:#555;">Ayah Kandung</strong>';
                echo '<table class="widefat striped" style="border:0; margin-bottom:15px;"><tbody>';
                    echo '<tr><td style="width:120px;">Nama</td><td>'.$v('psb_nama_ayah').'</td></tr>';
                    echo '<tr><td>NIK</td><td>'.$v('psb_nik_ayah').'</td></tr>';
                    echo '<tr><td>Pekerjaan</td><td>'.$v('psb_pekerjaan_ayah').'</td></tr>';
                    echo '<tr><td>Pendidikan</td><td>'.$v('psb_pendidikan_ayah').'</td></tr>';
                    echo '<tr><td>Penghasilan</td><td>'.$v('psb_penghasilan_ayah').'</td></tr>';
                echo '</tbody></table>';

                // Ibu
                echo '<strong style="display:block; margin-bottom:5px; color:#555;">Ibu Kandung</strong>';
                echo '<table class="widefat striped" style="border:0; margin-bottom:15px;"><tbody>';
                    echo '<tr><td style="width:120px;">Nama</td><td>'.$v('psb_nama_ibu').'</td></tr>';
                    echo '<tr><td>NIK</td><td>'.$v('psb_nik_ibu').'</td></tr>';
                    echo '<tr><td>Pekerjaan</td><td>'.$v('psb_pekerjaan_ibu').'</td></tr>';
                    echo '<tr><td>Pendidikan</td><td>'.$v('psb_pendidikan_ibu').'</td></tr>';
                    echo '<tr><td>Penghasilan</td><td>'.$v('psb_penghasilan_ibu').'</td></tr>';
                echo '</tbody></table>';
                
                // Wali
                if($v('psb_nama_wali') != '-' && $v('psb_nama_wali') != '') {
                    echo '<strong style="display:block; margin-bottom:5px; color:#555;">Wali</strong>';
                    echo '<table class="widefat striped" style="border:0;"><tbody>';
                        echo '<tr><td style="width:120px;">Nama</td><td>'.$v('psb_nama_wali').'</td></tr>';
                        echo '<tr><td>Hubungan</td><td>'.$v('psb_hubungan_wali').'</td></tr>';
                    echo '</tbody></table>';
                }
                // Section: Berkas Upload
                echo '<div style="border:1px solid #eee; padding:15px; border-radius:5px; margin-bottom:20px;">';
                echo '<h3 style="margin-top:0; border-bottom:1px solid #eee; padding-bottom:10px;">📂 Berkas Upload</h3>';
                
                $kk_url = $v('psb_file_kk');
                $foto_url = $v('psb_file_foto');
                
                if($foto_url != '-' && $foto_url != '') {
                    echo '<div style="margin-bottom:15px;">';
                    echo '<strong>Pas Foto:</strong><br>';
                    echo '<a href="'.$foto_url.'" target="_blank"><img src="'.$foto_url.'" style="width:100px; height:auto; border:1px solid #ddd; padding:3px; margin-top:5px;"></a>';
                    echo '</div>';
                } else {
                    echo '<p style="color:red;">Belum upload foto.</p>';
                }

                if($kk_url != '-' && $kk_url != '') {
                    echo '<div>';
                    echo '<strong>Kartu Keluarga:</strong><br>';
                    echo '<a href="'.$kk_url.'" target="_blank" class="button"><span class="dashicons dashicons-pdf"></span> Lihat File KK</a>';
                    echo '</div>';
                } else {
                    echo '<p style="color:red;">Belum upload KK.</p>';
                }

                echo '</div>';

                // Section: Kontak
                echo '<div style="border:1px solid #eee; padding:15px; border-radius:5px;">';
                echo '<h3 style="margin-top:0; border-bottom:1px solid #eee; padding-bottom:10px;">📞 Kontak</h3>';
                echo '<p><b>No. Handphone/WA:</b><br><span style="font-size:16px;">'.$v('psb_telepon').'</span></p>';
                echo '<p><b>Email:</b><br>'.$v('psb_email').'</p>';
                if($v('psb_telepon') != '-') {
                    $wa_num = preg_replace('/^0/','62', preg_replace('/[^0-9]/','', $v('psb_telepon')));
                    echo '<a href="https://wa.me/'.$wa_num.'" target="_blank" class="button button-secondary" style="width:100%; text-align:center;"><span class="dashicons dashicons-whatsapp"></span> Chat WhatsApp</a>';
                }
                echo '</div>';

            echo '</div>'; // End Col 2
            
        echo '</div>'; // End Grid

    echo '</div>'; 
}
function pondok_save_psb_direct($pid){ 
    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    
    // Status Update
    if(isset($_POST['psb_st'])) update_post_meta($pid,'psb_status',sanitize_text_field($_POST['psb_st'])); 

    // Manual Data Correction Handler
    $fields_to_edit = ['psb_nama','psb_nisn','psb_nik','psb_no_kk','psb_tempat_lahir','psb_jenjang','psb_asal_sekolah'];
    foreach($fields_to_edit as $f) {
        if(isset($_POST[$f])) {
            update_post_meta($pid, $f, sanitize_text_field($_POST[$f]));
        }
    }
}
add_action('save_post','pondok_save_psb_direct');
