<?php
/**
 * Simple Silabus Management Page (Repeater Style)
 */

function pondok_register_silabus_page() {
    add_submenu_page(
        'pondok-theme-settings', // Parent slug
        'Kelola Silabus',
        'Kelola Silabus',
        'manage_options',
        'pondok-silabus',
        'pondok_silabus_page_html'
    );
}
add_action('admin_menu', 'pondok_register_silabus_page');

function pondok_silabus_page_html() {
    // Save Logic
    if (isset($_POST['pondok_silabus_nonce']) && wp_verify_nonce($_POST['pondok_silabus_nonce'], 'save_silabus_action')) {
        $silabus_data = isset($_POST['silabus']) ? $_POST['silabus'] : array();
        // Sanitize
        $clean_data = array();
        foreach ($silabus_data as $item) {
            if (!empty($item['judul'])) {
                $clean_data[] = array(
                    'judul' => sanitize_text_field($item['judul']),
                    'kode' => sanitize_text_field($item['kode']),
                    'level' => sanitize_text_field($item['level']), // Ula, Wustha, Ulya
                    'kategori' => sanitize_text_field($item['kategori']), // Fiqh, Aqidah, dll
                    'deskripsi' => sanitize_textarea_field($item['deskripsi']),
                    'referensi' => sanitize_textarea_field($item['referensi']), // Simpan sebagai text dulu
                    'topik' => sanitize_textarea_field($item['topik']), // Multiline text
                    'file_url' => esc_url_raw($item['file_url']), // New PDF Field
                );
            }
        }
        update_option('pondok_silabus_list', $clean_data);
        echo '<div class="notice notice-success is-dismissible"><p>Data Silabus berhasil disimpan!</p></div>';
    }

    $existing_data = get_option('pondok_silabus_list', array());
    
    // Enqueue Media
    wp_enqueue_media();
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola Silabus Pembelajaran</h1>
        <hr class="wp-header-end">
        
        <form method="post" action="">
            <?php wp_nonce_field('save_silabus_action', 'pondok_silabus_nonce'); ?>
            
            <style>
                .silabus-row { background: #fff; border: 1px solid #ccd0d4; padding: 15px; margin-bottom: 15px; box-shadow: 0 1px 1px rgba(0,0,0,.04); display: flex; gap: 15px; align-items: flex-start; }
                .silabus-row .col-fields { flex: 1; display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 10px; }
                .silabus-row .full-width { grid-column: span 3; }
                .silabus-row .half-width { grid-column: span 1; }
                .silabus-row input[type="text"], .silabus-row textarea, .silabus-row select { width: 100%; }
                .silabus-row .remove-row { color: #b32d2e; align-self: flex-start; margin-top: 10px; cursor: pointer; font-size: 20px; }
                .pdf-wrapper { display: flex; gap: 5px; align-items: center; }
            </style>

            <div id="silabus-container">
                <?php 
                if (!empty($existing_data)) {
                    foreach ($existing_data as $index => $item) {
                        pondok_render_silabus_row($index, $item);
                    }
                } else {
                    pondok_render_silabus_row(0);
                }
                ?>
            </div>

            <button type="button" class="button button-secondary" id="add-row-btn">+ Tambah Mata Pelajaran</button>
            <hr>
            <button type="submit" class="button button-primary button-hero">Simpan Perubahan</button>
        </form>
    </div>

    <!-- Template for JS -->
    <script type="text/template" id="row-template">
        <?php pondok_render_silabus_row('INDEX_PLACEHOLDER'); ?>
    </script>

    <script>
    jQuery(document).ready(function($) {
        
        // Add Row
        $('#add-row-btn').on('click', function() {
            var template = $('#row-template').html();
            var timestamp = new Date().getTime(); 
            template = template.replace(/INDEX_PLACEHOLDER/g, timestamp);
            $('#silabus-container').append(template);
        });

        // Remove Row
        $('#silabus-container').on('click', '.remove-row', function() {
            if (confirm('Hapus mapel ini?')) {
                $(this).closest('.silabus-row').remove();
            }
        });

        // Media Uploader Logic
        var file_frame;
        $('#silabus-container').on('click', '.upload-pdf-btn', function(event) {
            event.preventDefault();
            var button = $(this);
            var inputField = button.prev('input');

            // If the media frame already exists, reopen it.
            if (file_frame) {
                // Check if we need to update the target input
                file_frame.off('select'); // Remove old listener
                file_frame.on('select', function() {
                    var attachment = file_frame.state().get('selection').first().toJSON();
                    inputField.val(attachment.url);
                });
                file_frame.open();
                return;
            }

            // Create the media frame.
            file_frame = wp.media.frames.file_frame = wp.media({
                title: 'Pilih File Silabus (PDF)',
                button: { text: 'Gunakan File Ini' },
                multiple: false
            });

            // When an image is selected, run a callback.
            file_frame.on('select', function() {
                var attachment = file_frame.state().get('selection').first().toJSON();
                inputField.val(attachment.url);
            });

            file_frame.open();
        });

    });
    </script>
    <?php
}

function pondok_render_silabus_row($index, $data = array()) {
    $judul = isset($data['judul']) ? $data['judul'] : '';
    $kode = isset($data['kode']) ? $data['kode'] : '';
    $level = isset($data['level']) ? $data['level'] : '';
    $kategori = isset($data['kategori']) ? $data['kategori'] : '';
    $deskripsi = isset($data['deskripsi']) ? $data['deskripsi'] : '';
    $referensi = isset($data['referensi']) ? $data['referensi'] : '';
    $topik = isset($data['topik']) ? $data['topik'] : '';
    $file_url = isset($data['file_url']) ? $data['file_url'] : '';
    
    $level_opts = array('Wustho' => 'Wustho (Menengah)', 'Ulya' => 'Ulya (Atas)');
    $cat_opts = array('Fiqh' => 'Fiqh & Ushul', 'Aqidah' => 'Aqidah & Akhlak', 'Bahasa' => 'Bahasa Arab', 'Quran' => 'Al-Quran & Hadits', 'Sejarah' => 'Sejarah (SKI)', 'Umum' => 'Umum');
    
    // Check Global Focus
    $focus_level = function_exists('pondok_get_option') ? pondok_get_option('school_level_focus', '') : '';
    $is_locked = !empty($focus_level);
    
    // Logic: If locked, force the level to match focus_level only for NEW items.
    // Do NOT overwrite existing data.
    if ($is_locked && empty($level)) {
        $level = $focus_level;
    }
    ?>
    <div class="silabus-row">
        <div class="col-fields">
            <div class="half-width">
                <label>Nama Mata Pelajaran</label>
                <input type="text" name="silabus[<?php echo $index; ?>][judul]" value="<?php echo esc_attr($judul); ?>" placeholder="Contoh: Fiqh Dasar">
            </div>
            <div class="half-width">
                <label>Kode Mapel</label>
                <input type="text" name="silabus[<?php echo $index; ?>][kode]" value="<?php echo esc_attr($kode); ?>" placeholder="FQ-101">
            </div>
            <div class="half-width">
                <label>Tingkatan</label>
                <select name="silabus[<?php echo $index; ?>][level]">
                    <?php foreach($level_opts as $k => $v): ?>
                        <option value="<?php echo $k; ?>" <?php selected($level, $k); ?>><?php echo $v; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="half-width" style="grid-column: span 3;">
                <label>Kategori</label>
                 <select name="silabus[<?php echo $index; ?>][kategori]">
                    <?php foreach($cat_opts as $k => $v): ?>
                        <option value="<?php echo $k; ?>" <?php selected($kategori, $k); ?>><?php echo $v; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="full-width">
                <label>File Silabus (PDF)</label>
                <div class="pdf-wrapper">
                    <input type="text" name="silabus[<?php echo $index; ?>][file_url]" value="<?php echo esc_attr($file_url); ?>" placeholder="Upload file PDF...">
                    <button type="button" class="button upload-pdf-btn">Upload PDF</button>
                </div>
            </div>
            <div class="full-width">
                <label>Capaian Pembelajaran (Deskripsi)</label>
                <textarea name="silabus[<?php echo $index; ?>][deskripsi]" rows="2"><?php echo esc_textarea($deskripsi); ?></textarea>
            </div>
            <div class="full-width">
                <label>Referensi/Kitab (Pisahkan dengan koma)</label>
                <input type="text" name="silabus[<?php echo $index; ?>][referensi]" value="<?php echo esc_attr($referensi); ?>" placeholder="Safinatun Najah, Fathul Qorib...">
            </div>
            <div class="full-width">
                <label>Daftar Topik/Materi (Satu per baris)</label>
                <textarea name="silabus[<?php echo $index; ?>][topik]" rows="4" placeholder="Bab 1: Thaharah&#10;Bab 2: Shalat&#10;..."><?php echo esc_textarea($topik); ?></textarea>
            </div>
        </div>
        <span class="dashicons dashicons-trash remove-row" title="Hapus"></span>
    </div>
    <?php
}
