<?php get_header(); ?>

<main class="flex-grow w-full w-full max-w-[1440px] mx-auto px-4 md:px-8 xl:px-12 py-8">
    
    <!-- Breadcrumbs -->
    <div class="mb-6 flex items-center flex-wrap gap-2 text-sm text-gray-500 dark:text-gray-400">
        <a class="hover:text-primary transition-colors" href="<?php echo esc_url(home_url('/')); ?>">Beranda</a>
        <span class="material-symbols-outlined text-[16px]">chevron_right</span>
        <span class="text-[#111318] dark:text-white font-medium"><?php single_post_title(); ?></span>
    </div>

    <!-- Page Heading -->
    <div class="mb-10">
        <h1 class="text-3xl md:text-4xl font-black tracking-tight text-[#111318] dark:text-white mb-3">
            <?php single_post_title(); ?>
        </h1>
        <p class="text-lg text-gray-600 dark:text-gray-400 max-w-3xl">
            Temukan berita terkini, wawasan pendidikan mendalam, serta dokumentasi kegiatan inspiratif dari para santri Pondok Dengan.
        </p>
    </div>

    <!-- Search and Filter Section -->
    <div class="flex flex-col lg:flex-row gap-6 mb-10 items-start lg:items-center justify-between">
        <!-- Search Bar -->
        <div class="w-full lg:w-96">
            <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="relative group">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <span class="material-symbols-outlined text-gray-400 dark:text-gray-500">search</span>
                </div>
                <input
                    type="search"
                    name="s"
                    value="<?php echo get_search_query(); ?>"
                    class="block w-full pl-10 pr-3 py-2.5 border-none rounded-lg leading-5 bg-gray-100 dark:bg-surface text-[#111318] dark:text-gray-900 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary/50 sm:text-sm transition-shadow"
                    placeholder="Cari artikel, topik, atau kata kunci..."
                />
            </form>
        </div>

        <!-- Chips / Categories -->
        <div class="flex flex-wrap gap-2">
            <a href="<?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>" 
               class="px-4 py-2 rounded-lg <?php echo !is_category() ? 'bg-primary text-white' : 'bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-300 hover:bg-gray-200'; ?> text-sm font-medium transition-colors">
               Semua
            </a>
            <?php
            $categories = get_categories( array(
                'orderby' => 'name',
                'order'   => 'ASC',
                'number'  => 5 
            ) );
            foreach( $categories as $category ) :
                $active_class = ( is_category( $category->term_id ) ) ? 'bg-primary text-white' : 'bg-gray-100 dark:bg-gray-800 text-gray-600 dark:text-gray-300 hover:bg-gray-200';
            ?>
                <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>" 
                   class="px-4 py-2 rounded-lg border border-transparent <?php echo $active_class; ?> text-sm font-medium transition-colors">
                    <?php echo esc_html( $category->name ); ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>

    <?php if ( have_posts() ) : ?>

        <!-- Loop Start -->
        <?php 
        $post_counter = 0;
        $grid_started = false;

        while ( have_posts() ) : the_post(); 
            $post_counter++;
            
            // Logic: Layout Featured hanya untuk Post Pertama di Halaman Pertama
            if ( $post_counter === 1 && !is_paged() ) :
        ?>
            <!-- Featured Article (First Post) -->
            <div class="mb-12">
                <div class="group relative flex flex-col md:flex-row gap-0 rounded-2xl bg-white dark:bg-[#1a202c] shadow-sm hover:shadow-md transition-all overflow-hidden border border-gray-200 dark:border-gray-700">
                    <div class="w-full md:w-2/3 h-64 md:h-[400px] overflow-hidden relative">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <img
                                src="<?php the_post_thumbnail_url('large'); ?>"
                                alt="<?php the_title_attribute(); ?>"
                                class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500"
                            />
                        <?php else : ?>
                             <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                <span class="material-symbols-outlined text-6xl text-gray-400">image</span>
                             </div>
                        <?php endif; ?>
                        
                        <!-- Badge for Featured -->
                         <div class="absolute top-4 left-4">
                            <span class="px-3 py-1 rounded-full bg-primary text-white text-xs font-bold uppercase tracking-wide shadow-lg">
                                Terbaru
                            </span>
                        </div>
                    </div>
                    
                    <div class="w-full md:w-1/3 p-6 md:p-8 flex flex-col justify-center">
                        <div class="flex items-center gap-3 mb-4">
                            <?php 
                                $categories = get_the_category();
                                if ( ! empty( $categories ) ) {
                                    echo '<span class="text-primary font-bold text-xs uppercase tracking-wide">' . esc_html( $categories[0]->name ) . '</span>';
                                }
                            ?>
                            <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                            <span class="text-xs text-gray-500 font-medium"><?php echo get_the_date(); ?></span>
                        </div>
                        
                        <h2 class="text-2xl font-bold text-[#111318] dark:text-white mb-3 leading-tight group-hover:text-primary transition-colors">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h2>
                        
                        <div class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed mb-6 line-clamp-3">
                            <?php the_excerpt(); ?>
                        </div>
                        
                        <a href="<?php the_permalink(); ?>" class="inline-flex items-center text-sm font-bold text-primary hover:text-green-700 transition-colors mt-auto">
                            Baca Selengkapnya
                            <span class="material-symbols-outlined text-lg ml-1">arrow_forward</span>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Start Grid Wrapper -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
            <?php $grid_started = true; ?>

            <?php else : ?>
                <!-- Standard Grid Item -->
                <?php if ( ! $grid_started ) { echo '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">'; $grid_started = true; } ?>
                
                <article id="post-<?php the_ID(); ?>" <?php post_class('flex flex-col bg-white dark:bg-[#1a202c] rounded-xl overflow-hidden shadow-sm hover:shadow-lg transition-all border border-gray-200 dark:border-gray-700 group h-full'); ?>>
                    <div class="aspect-[16/9] overflow-hidden relative">
                         <a href="<?php the_permalink(); ?>">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <img
                                    src="<?php the_post_thumbnail_url('medium_large'); ?>"
                                    alt="<?php the_title_attribute(); ?>"
                                    class="w-full h-full object-cover transform group-hover:scale-105 transition-transform duration-500"
                                />
                            <?php else : ?>
                                <div class="w-full h-full bg-gray-200 flex items-center justify-center">
                                    <span class="material-symbols-outlined text-4xl text-gray-400">image</span>
                                </div>
                            <?php endif; ?>
                        </a>
                    </div>
                    
                    <div class="p-5 flex flex-col flex-grow">
                        <div class="flex items-center justify-between mb-3">
                             <?php 
                                $categories = get_the_category();
                                if ( ! empty( $categories ) ) {
                                    echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '" class="text-xs font-bold text-primary uppercase tracking-wider hover:underline">' . esc_html( $categories[0]->name ) . '</a>';
                                }
                            ?>
                            <span class="text-xs text-gray-500 flex items-center gap-1">
                                <span class="material-symbols-outlined text-[14px]">calendar_today</span>
                                <?php echo get_the_date('d M Y'); ?>
                            </span>
                        </div>
                        
                        <h3 class="text-lg font-bold text-[#111318] dark:text-white mb-2 leading-snug group-hover:text-primary transition-colors">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h3>
                        
                        <div class="text-sm text-gray-600 dark:text-gray-400 mb-4 line-clamp-3 flex-grow">
                            <?php the_excerpt(); ?>
                        </div>
                        
                        <div class="mt-auto pt-4 border-t border-gray-100 dark:border-gray-700">
                            <a href="<?php the_permalink(); ?>" class="text-sm font-bold text-primary hover:underline">
                                Baca Selengkapnya
                            </a>
                        </div>
                    </div>
                </article>

            <?php endif; ?>

        <?php endwhile; ?>
        
        <?php if ( $grid_started ) echo '</div>'; // Close Grid ?>

        <!-- Pagination -->
        <div class="flex justify-center items-center gap-2 mb-12">
            <?php
            the_posts_pagination( array(
                'mid_size'  => 2,
                'prev_text' => '<span class="material-symbols-outlined">chevron_left</span>',
                'next_text' => '<span class="material-symbols-outlined">chevron_right</span>',
                'screen_reader_text' => ' ',
                'class'     => 'flex items-center gap-2'
            ) );
            ?>
        </div>

    <?php else : ?>
        <div class="text-center py-20">
            <span class="material-symbols-outlined text-6xl text-gray-300 mb-4">search_off</span>
            <h2 class="text-2xl font-bold text-gray-700">Belum ada artikel</h2>
            <p class="text-gray-500">Silakan kembali lagi nanti untuk melihat update terbaru.</p>
        </div>
    <?php endif; ?>

</main>

<?php get_footer(); ?>
