<?php
/**
 * Template Name: Dewan Asatidz
 */
get_header(); 

// Get stored data
$all_asatidz = get_option('pondok_asatidz_list', array());
?>

<main class="flex-1 flex flex-col items-center py-8 px-4 md:px-10 lg:px-40 bg-white dark:bg-background-dark min-h-screen">
    <div class="layout-content-container flex flex-col w-full max-w-[1200px] gap-8">
        
        <!-- Page Heading -->
        <div class="flex flex-wrap justify-between gap-6 px-4">
            <div class="flex flex-col gap-3 max-w-2xl">
                <h1 class="text-[#111318] dark:text-white text-4xl md:text-5xl font-black leading-tight tracking-[-0.033em]">
                    <?php the_title(); ?>
                </h1>
                <div class="text-[#616f89] dark:text-gray-400 text-lg font-normal leading-normal">
                    <?php 
                    if(have_posts()) {
                        while(have_posts()) { the_post(); the_content(); }
                    } else {
                        echo 'Para pendidik berdedikasi yang membimbing generasi penerus di Pondok Dengan.';
                    }
                    ?>
                </div>
            </div>
        </div>

        <!-- Filters & Search -->
        <form method="get" class="flex w-full flex-wrap items-center gap-4 px-4 py-2">
            <div class="relative flex-1 min-w-[280px] max-w-[480px]">
                <span class="absolute left-4 top-1/2 -translate-y-1/2 text-[#616f89] dark:text-gray-500 material-symbols-outlined">search</span>
                <input
                    type="search"
                    name="q_asatidz"
                    value="<?php echo esc_attr(isset($_GET['q_asatidz']) ? $_GET['q_asatidz'] : ''); ?>"
                    class="w-full rounded-lg border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-gray-800 text-[#111318] dark:text-white focus:outline-none focus:ring-2 focus:ring-primary h-12 pl-12 pr-4 text-base placeholder:text-[#616f89] dark:placeholder:text-gray-500"
                    placeholder="Cari nama Ustadz..."
                />
            </div>
            
            <div class="relative flex-1 min-w-[200px] max-w-[320px]">
                <span class="absolute right-4 top-1/2 -translate-y-1/2 text-[#616f89] dark:text-gray-500 material-symbols-outlined pointer-events-none z-10">expand_more</span>
                <select
                    name="bidang"
                    onchange="this.form.submit()"
                    class="appearance-none w-full cursor-pointer rounded-lg border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-gray-800 text-[#111318] dark:text-white focus:outline-none focus:ring-2 focus:ring-primary h-12 px-4 text-base pr-10"
                    style="-webkit-appearance: none; -moz-appearance: none; appearance: none; background-image: none;"
                >
                    <option value="">Semua Kategori</option>
                    <option value="Struktural" <?php selected(isset($_GET['bidang']) ? $_GET['bidang'] : '', 'Struktural'); ?>>Jajaran Pengurus</option>
                    <option value="Guru" <?php selected(isset($_GET['bidang']) ? $_GET['bidang'] : '', 'Guru'); ?>>Dewan Guru</option>
                    <option value="Staff" <?php selected(isset($_GET['bidang']) ? $_GET['bidang'] : '', 'Staff'); ?>>Staff & TU</option>
                </select>
            </div>

            <button type="submit" class="h-12 px-6 rounded-lg bg-primary hover:bg-green-700 text-white font-bold transition-colors">
                Cari
            </button>
        </form>

        <?php
        $q_nama = isset($_GET['q_asatidz']) ? strtolower(trim($_GET['q_asatidz'])) : '';
        $q_bidang = isset($_GET['bidang']) ? $_GET['bidang'] : '';
        $is_searching = !empty($q_nama) || !empty($q_bidang);

        // Helper function to render card
        if (!function_exists('pondok_render_asatidz_card')) {
            function pondok_render_asatidz_card($guru) {
                $foto = $guru['foto'] ? $guru['foto'] : '';
                ?>
                <div class="group flex flex-col overflow-hidden rounded-xl bg-white dark:bg-gray-800 border border-[#e5e7eb] dark:border-gray-700 shadow-sm hover:shadow-lg hover:border-primary/30 transition-all duration-300">
                    <div class="aspect-[3/4] w-full overflow-hidden relative bg-gray-100 dark:bg-gray-700">
                        <?php if ( $foto ) : ?>
                            <img 
                                src="<?php echo esc_url($foto); ?>" 
                                alt="<?php echo esc_attr($guru['nama']); ?>"
                                class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-105"
                            >
                        <?php else : ?>
                            <div class="w-full h-full flex items-center justify-center bg-gray-200 dark:bg-gray-600">
                                <span class="material-symbols-outlined text-6xl text-gray-400">person</span>
                            </div>
                        <?php endif; ?>
                        <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-end p-4"></div>
                    </div>
                    <div class="flex flex-col p-5 gap-2 flex-1">
                        <div>
                            <h3 class="text-lg font-bold text-[#111318] dark:text-white leading-tight">
                                <?php echo esc_html($guru['nama']); ?>
                            </h3>
                            <p class="text-primary text-sm font-semibold mt-1">
                                <?php echo esc_html($guru['jabatan']); ?>
                            </p>
                        </div>
                        <div class="text-[#616f89] dark:text-gray-400 text-sm leading-relaxed line-clamp-3 mb-4">
                            <?php echo nl2br(esc_html($guru['bio'])); ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        }

        // --- DISPLAY LOGIC ---

        if ($is_searching) {
            // VIEW 1: SEARCH RESULTS (Unified Grid)
            ?>
            <h2 class="text-2xl font-bold px-4 mb-4 text-[#111318] dark:text-white">Hasil Pencarian</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 px-4">
                <?php
                $count = 0;
                if (!empty($all_asatidz)) {
                    foreach ($all_asatidz as $guru) {
                        if ($q_nama && strpos(strtolower($guru['nama']), $q_nama) === false) continue;
                        // Filter Logic Smart Grouping
                        if ($q_bidang) {
                            if ($q_bidang === 'Guru') {
                                // Match any teaching role (NOT Struktural AND NOT Staff)
                                if ($guru['bidang'] === 'Struktural' || $guru['bidang'] === 'Staff') continue;
                            } else {
                                // Exact match for Struktural / Staff
                                if ($guru['bidang'] !== $q_bidang) continue;
                            }
                        }
                        pondok_render_asatidz_card($guru);
                        $count++;
                    }
                }
                if ($count == 0) echo '<div class="col-span-full text-center py-20 text-gray-500">Data tidak ditemukan.</div>';
                ?>
            </div>
            <?php

        } else {
            // VIEW 2: SPLIT LAYOUT (Default)
            
            // Filter Data (Split into 3 Groups)
            $pimpinan = array();
            $guru_list = array();
            $staff = array();
            
            if (!empty($all_asatidz)) {
                foreach ($all_asatidz as $guru) {
                    $bidang = isset($guru['bidang']) ? $guru['bidang'] : '';

                    if ($bidang === 'Struktural') {
                        $pimpinan[] = $guru;
                    } elseif ($bidang === 'Staff') {
                        $staff[] = $guru;
                    } else {
                        $guru_list[] = $guru; // Semua guru (Tahfidz, Kitab, Bahasa, Umum)
                    }
                }
            }
            ?>
            
            <!-- SECTION 1: JAJARAN PENGURUS / STRUKTURAL -->
            <?php if (!empty($pimpinan)): ?>
            <div class="mb-12">
                <div class="flex items-center gap-4 px-4 mb-6">
                    <div class="h-8 w-1.5 bg-primary rounded-full"></div>
                    <h2 class="text-2xl md:text-3xl font-bold text-[#111318] dark:text-white">Jajaran Pengurus</h2>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 px-4">
                    <?php foreach ($pimpinan as $guru) pondok_render_asatidz_card($guru); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- SECTION 2: DEWAN GURU / PENGAJAR -->
            <?php if (!empty($guru_list)): ?>
            <div class="mb-12">
                <div class="flex items-center gap-4 px-4 mb-6">
                    <div class="h-8 w-1.5 bg-blue-600 rounded-full"></div>
                    <h2 class="text-2xl md:text-3xl font-bold text-[#111318] dark:text-white">Dewan Asatidz</h2>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 px-4">
                    <?php foreach ($guru_list as $guru) pondok_render_asatidz_card($guru); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- SECTION 3: STAFF & TATA USAHA -->
            <?php if (!empty($staff)): ?>
            <div class="mb-12">
                <div class="flex items-center gap-4 px-4 mb-6">
                    <div class="h-8 w-1.5 bg-gray-500 rounded-full"></div>
                    <h2 class="text-2xl md:text-3xl font-bold text-[#111318] dark:text-white">Staff & Tata Usaha</h2>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 px-4">
                    <?php foreach ($staff as $guru) pondok_render_asatidz_card($guru); ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (empty($pimpinan) && empty($guru_list) && empty($staff)): ?>
                <div class="text-center py-20">
                    <span class="material-symbols-outlined text-6xl text-gray-300 mb-4">groups</span>
                    <h3 class="text-xl font-bold text-gray-700 dark:text-gray-300">Belum Ada Data</h3>
                    <p class="text-gray-500">Silakan input data asatidz di menu Dashboard > Kelola Asatidz.</p>
                </div>
            <?php endif; ?>

        <?php } // End If Searching ?>

    </div>
</main>

<?php get_footer(); ?>
