<?php
/**
 * Template Name: Brosur Page
 */
get_header(); 

// Get stored data
$all_brosur = get_option('pondok_brosur_list', array());
?>

<main class="flex-grow flex flex-col bg-white dark:bg-background-dark min-h-screen">
    <!-- Hero Section -->
    <div class="w-full bg-white dark:bg-[#1a202c]">
        <div class="max-w-[1280px] mx-auto px-4 md:px-10 py-8 md:py-12">
            <div class="@container">
            <div
                class="flex min-h-[320px] md:min-h-[400px] flex-col gap-6 bg-cover bg-center bg-no-repeat rounded-xl items-center justify-center p-6 md:p-12 relative overflow-hidden group shadow-lg"
                style="
                background-image: linear-gradient(
                    rgba(16, 22, 34, 0.7) 0%,
                    rgba(19, 91, 236, 0.8) 100%
                    ),
                    url('https://lh3.googleusercontent.com/aida-public/AB6AXuDxZDPtITfbPrWE4mmoj_YpIxroVtQOumXVgynZrJxCZgwETq7B5tu-RfHVyZZ7SS6d-idG6FCdxaUAHRnqcKbID7WRRI740a0WcXtn1vqRBtQHgi-ONMC74elm5R9FPE9VeOfQpf4uMgSTUY32pw5eGDWldTsVN_s6w4DO6SyEgeYxxVW-7gWKE9zGmgIUd8cOk9_Cbv0TjEIb5vK57En-5WE_GVfbsdMtZ6EJGCaG0W3IMS6o3nSJTpgZEyZyE_FwD6lBT9vmzgmK');
                "
            >
                <div class="relative z-10 flex flex-col gap-4 text-center max-w-2xl">
                    <h1 class="text-white text-4xl md:text-5xl font-black leading-tight tracking-[-0.033em]">
                        Arsip Brosur &amp; Informasi
                    </h1>
                    <p class="text-white/90 text-base md:text-lg font-normal leading-relaxed">
                        Temukan dan unduh panduan lengkap mengenai pendaftaran, kurikulum akademik, laporan tahunan, serta dokumentasi kegiatan.
                    </p>
                </div>
            </div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="w-full max-w-[1280px] mx-auto px-4 md:px-10 py-8">
        
        <!-- Filter & Search Container -->
        <form method="get" class="flex flex-col lg:flex-row gap-6 mb-10 items-start lg:items-center justify-between">
            <!-- Search Bar -->
            <div class="w-full lg:max-w-md">
                <label class="flex flex-col w-full">
                    <div class="flex w-full items-stretch rounded-lg h-12 shadow-sm focus-within:shadow-md transition-shadow bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 overflow-hidden">
                        <div class="flex items-center justify-center pl-4 text-gray-500 dark:text-gray-400">
                            <span class="material-symbols-outlined">search</span>
                        </div>
                        <input
                            type="search"
                            name="q_brosur"
                            value="<?php echo esc_attr(isset($_GET['q_brosur']) ? $_GET['q_brosur'] : ''); ?>"
                            class="flex w-full flex-1 bg-transparent border-none focus:ring-0 h-full px-4 text-base text-[#111318] dark:text-white placeholder:text-gray-500 font-normal focus:outline-none"
                            placeholder="Cari judul brosur, tahun, atau topik..."
                        />
                    </div>
                </label>
            </div>
            
            <!-- Chips / Categories -->
            <div class="flex gap-2 flex-wrap items-center">
                <?php
                $current_cat = isset($_GET['kategori']) ? $_GET['kategori'] : '';
                $cats = array('' => 'Semua', 'PSB' => 'PSB', 'Akademik' => 'Akademik', 'Laporan' => 'Laporan', 'Kegiatan' => 'Kegiatan');
                
                foreach($cats as $val => $label) {
                    $active_class = ($current_cat === $val) 
                        ? 'bg-primary text-white hover:bg-primary/90' 
                        : 'bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 text-[#111318] dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-800';
                ?>
                <a href="<?php echo esc_url(add_query_arg('kategori', $val)); ?>" class="flex h-9 items-center justify-center gap-x-2 rounded-lg px-4 shadow-sm transition-all <?php echo $active_class; ?>">
                    <span class="text-sm font-bold leading-normal"><?php echo $label; ?></span>
                </a>
                <?php } ?>
            </div>
        </form>

        <!-- Brochure Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 md:gap-8">
            <?php
            $q_nama = isset($_GET['q_brosur']) ? strtolower(trim($_GET['q_brosur'])) : '';
            $q_cat = isset($_GET['kategori']) ? $_GET['kategori'] : '';

            $count = 0;
            if (!empty($all_brosur)) :
                foreach ($all_brosur as $item) {
                    // Filter Logic
                    if ($q_nama && strpos(strtolower($item['judul']), $q_nama) === false) continue;
                    if ($q_cat && $item['kategori'] !== $q_cat) continue;
                    
                    $count++;
                    $cover = $item['cover'] ? $item['cover'] : '';
                    
                    // Kategori Color Logic
                    $cat_colors = array(
                        'PSB' => 'blue',
                        'Akademik' => 'purple',
                        'Laporan' => 'orange',
                        'Kegiatan' => 'green',
                        'Umum' => 'teal'
                    );
                    $color = isset($cat_colors[$item['kategori']]) ? $cat_colors[$item['kategori']] : 'gray';
            ?>
            <!-- Card Item -->
            <div class="group flex flex-col bg-white dark:bg-[#1a202c] rounded-xl shadow-sm hover:shadow-xl hover:-translate-y-1 transition-all duration-300 border border-gray-100 dark:border-gray-800 overflow-hidden">
                <div class="relative p-6 pb-2 flex justify-center bg-gray-50 dark:bg-gray-800/50">
                    <div class="w-3/4 aspect-[1/1.4] shadow-lg rounded-sm overflow-hidden transform group-hover:scale-105 transition-transform duration-300 relative bg-white">
                        <?php if($cover): ?>
                            <div class="absolute inset-0 bg-cover bg-center" style="background-image: url('<?php echo esc_url($cover); ?>');"></div>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-60"></div>
                            <div class="absolute bottom-4 left-4 text-white font-bold text-lg drop-shadow-md line-clamp-2 leading-tight">
                                <?php echo esc_html($item['judul']); ?>
                            </div>
                        <?php else: 
                            // Fallback Cover Generator based on Category Color
                            $bg_gradient = 'from-gray-500 to-gray-700'; // Default
                            if($item['kategori'] == 'PSB') $bg_gradient = 'from-blue-500 to-blue-700';
                            if($item['kategori'] == 'Akademik') $bg_gradient = 'from-purple-500 to-purple-700';
                            if($item['kategori'] == 'Laporan') $bg_gradient = 'from-orange-500 to-orange-700';
                            if($item['kategori'] == 'Kegiatan') $bg_gradient = 'from-green-500 to-green-700';
                            if($item['kategori'] == 'Umum') $bg_gradient = 'from-teal-500 to-teal-700';
                        ?>
                            <div class="absolute inset-0 bg-gradient-to-br <?php echo $bg_gradient; ?> p-4 flex flex-col justify-between">
                                <span class="material-symbols-outlined text-white/50 text-5xl">description</span>
                                <div class="text-white font-bold text-lg leading-tight drop-shadow-md line-clamp-3">
                                    <?php echo esc_html($item['judul']); ?>
                                </div>
                            </div>
                            <!-- Decorative Circle -->
                            <div class="absolute -top-10 -right-10 w-32 h-32 bg-white/10 rounded-full blur-2xl"></div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="p-5 flex flex-col flex-1">
                    <div class="flex items-start justify-between mb-2">
                        <span class="inline-flex items-center rounded-md bg-<?php echo $color; ?>-50 px-2 py-1 text-xs font-medium text-<?php echo $color; ?>-700 ring-1 ring-inset ring-<?php echo $color; ?>-700/10">
                            <?php echo esc_html($item['kategori']); ?>
                        </span>
                        <span class="text-xs text-gray-400 dark:text-gray-500 font-medium">
                            <?php echo esc_html($item['tanggal']); ?>
                        </span>
                    </div>
                    <h3 class="text-[#111318] dark:text-white text-lg font-bold leading-snug mb-1 line-clamp-2">
                        <?php echo esc_html($item['judul']); ?>
                    </h3>
                    <p class="text-gray-500 dark:text-gray-400 text-sm font-normal mb-4 line-clamp-2">
                        <?php echo esc_html($item['deskripsi']); ?>
                    </p>
                    <div class="mt-auto flex gap-3">
                        <?php if($item['file_url']): ?>
                        <a href="<?php echo esc_url($item['file_url']); ?>" target="_blank" download class="flex-1 h-9 flex items-center justify-center rounded-lg bg-primary text-white text-sm font-bold hover:bg-primary/90 transition-colors gap-1 shadow-sm">
                            <span class="material-symbols-outlined text-[18px]">download</span>
                            Unduh
                        </a>
                        <button onclick="openPdfViewer('<?php echo esc_js($item['file_url']); ?>', '<?php echo esc_js($item['judul']); ?>')" class="flex-1 h-9 flex items-center justify-center rounded-lg border border-gray-200 dark:border-gray-700 text-gray-700 dark:text-gray-300 text-sm font-bold hover:bg-gray-50 dark:hover:bg-gray-800 transition-colors">
                            Baca
                        </button>
                        <?php else: ?>
                            <button disabled class="w-full h-9 rounded-lg bg-gray-100 text-gray-400 text-sm font-bold cursor-not-allowed">
                                File Tidak Tersedia
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <?php 
                } // End foreach
            endif; 
            
            if ($count == 0) :
            ?>
                <div class="col-span-full text-center py-20">
                     <span class="material-symbols-outlined text-6xl text-gray-300 mb-4">folder_off</span>
                     <h3 class="text-xl font-bold text-gray-700 dark:text-gray-300">Dokumen Tidak Ditemukan</h3>
                     <p class="text-gray-500">Belum ada brosur yang diunggah atau tidak sesuai pencarian.</p>
                </div>
            <?php endif; ?>
        </div>

    </div>
</main>

<!-- PDF Viewer Modal -->
<div id="pdfModal" class="fixed inset-0 z-[100] hidden" role="dialog" aria-modal="true">
    <!-- Backdrop -->
    <div class="absolute inset-0 bg-black/80 backdrop-blur-sm transition-opacity" onclick="closePdfViewer()"></div>
    
    <!-- Modal Content -->
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="relative bg-white dark:bg-gray-900 w-full max-w-5xl h-[85vh] rounded-xl shadow-2xl flex flex-col overflow-hidden animate-in fade-in zoom-in duration-200">
            <!-- Header -->
            <div class="flex items-center justify-between px-4 py-3 border-b border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 z-10">
                <h3 id="pdfTitle" class="text-lg font-bold text-gray-900 dark:text-white truncate pr-4">Document Viewer</h3>
                <button onclick="closePdfViewer()" class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-800 text-gray-500 hover:text-red-500 transition-colors">
                    <span class="material-symbols-outlined">close</span>
                </button>
            </div>
            
            <!-- Body -->
            <div class="flex-1 bg-gray-100 dark:bg-gray-800 relative">
                <div id="pdfLoader" class="absolute inset-0 flex items-center justify-center">
                    <span class="material-symbols-outlined animate-spin text-4xl text-primary">progress_activity</span>
                </div>
                <iframe id="pdfFrame" src="" class="w-full h-full" onload="document.getElementById('pdfLoader').style.display='none'"></iframe>
            </div>
        </div>
    </div>
</div>

<script>
function openPdfViewer(url, title) {
    var viewerUrl = 'https://docs.google.com/viewer?embedded=true&url=' + encodeURIComponent(url);
    document.getElementById('pdfFrame').src = viewerUrl;
    document.getElementById('pdfTitle').innerText = title;
    document.getElementById('pdfModal').classList.remove('hidden');
    document.body.style.overflow = 'hidden'; // Prevent body scroll
}

function closePdfViewer() {
    document.getElementById('pdfModal').classList.add('hidden');
    document.getElementById('pdfFrame').src = ''; // Clear src to stop loading
    document.body.style.overflow = ''; // Restore body scroll
}
</script>

<?php get_footer(); ?>
