<?php
/**
 * Template Name: Jadwal KBM Page
 */
get_header();

// Get stored data
$all_jadwal = get_option('pondok_jadwal_list', array());

// Get Global School Level Focus
$focus_level = pondok_get_option('school_level_focus', ''); 
// $focus_level = 'Ulya'; // HARDCODE DEBUG 
if(!empty($focus_level)) {
    $filter_level = $focus_level;
} else {
    $filter_level = isset($_GET['level']) ? $_GET['level'] : '';
}

// Other Filters
$filter_hari = isset($_GET['hari']) ? $_GET['hari'] : date_i18n('l'); // Default to Today if possible, else 'Senin'
// Translate English day to Indonesian if needed for default
$english_days = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
$indo_days = array('Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu', 'Ahad');
$today_indo = str_replace($english_days, $indo_days, date('l'));

// If no filter set, default to show ALL DAYS so user sees data immediately
if(!isset($_GET['hari'])) {
    $filter_hari = 'Semua Hari';
}

$filter_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';
$search_q = isset($_GET['q_jadwal']) ? strtolower(trim($_GET['q_jadwal'])) : '';

// Process Data for Display & Stats
$filtered_data = array();
$stats_kelas_today = 0;
$stats_pengajar = array();
$active_classes_count = 0;

if (!empty($all_jadwal)) {
    foreach ($all_jadwal as $item) {
        // 1. Level Filter (Strict & Smart)
        $i_lvl = strtolower(trim(isset($item['tingkat']) ? $item['tingkat'] : ''));
        $f_lvl = strtolower(trim($filter_level));
        
        if (!empty($f_lvl)) {
            $is_level_match = false;

            // Logika Deteksi Wustho
            if (strpos($f_lvl, 'wusth') !== false) {
                if (strpos($i_lvl, 'wusth') !== false) $is_level_match = true;
            }
            // Logika Deteksi Ulya (termasuk typo Ula jika ada data lama)
            elseif (strpos($f_lvl, 'ulya') !== false || $f_lvl === 'ula') {
                if (strpos($i_lvl, 'ulya') !== false || $i_lvl === 'ula') $is_level_match = true;
            }
            // Logika Fallback (Exact Match)
            elseif ($i_lvl === $f_lvl) {
                $is_level_match = true;
            }
            
            if (!$is_level_match) continue; // Skip item ini, level beda.
        }
        
        // 2. Search Filter
        if ($search_q) {
            $match = false;
            if (strpos(strtolower($item['mapel']), $search_q) !== false) $match = true;
            if (strpos(strtolower($item['pengajar']), $search_q) !== false) $match = true;
            if (strpos(strtolower($item['kelas']), $search_q) !== false) $match = true;
            if (!$match) continue;
        }

        // 3. Day Filter (Robust)
        $item_day = isset($item['hari']) ? trim($item['hari']) : '';
        $item_day_valid = ($filter_hari == 'Semua Hari' || strcasecmp($item_day, $filter_hari) == 0);
        
        // 4. Class Filter (Robust)
        $item_class = isset($item['kelas']) ? trim($item['kelas']) : '';
        $item_class_valid = ($filter_kelas == '' || $filter_kelas == 'Semua Kelas' || strcasecmp($item_class, $filter_kelas) == 0);
        
        if ($item_day_valid && $item_class_valid) {
            $filtered_data[] = $item;
            if(!in_array($item['pengajar'], $stats_pengajar)) $stats_pengajar[] = $item['pengajar'];
             if($item['status'] == 'Aktif') $active_classes_count++;
        }
    }
}

// Sorting: Sort by Jam Mulai
usort($filtered_data, function($a, $b) {
    return strtotime($a['jam_mulai']) - strtotime($b['jam_mulai']);
});

// Extract Unique Classes for Dropdown (Context-Aware: Only show classes for current Level)
$unique_classes = array();
foreach($all_jadwal as $j) {
    if(empty($j['kelas'])) continue;
    
    // Check Level Match manually for Dropdown
    if (!empty($filter_level)) {
        $ft_i_lvl = strtolower(trim(isset($j['tingkat']) ? $j['tingkat'] : ''));
        $ft_f_lvl = strtolower(trim($filter_level));
        $allow_in_dropdown = false;
        
        if (strpos($ft_f_lvl, 'wusth') !== false) { if (strpos($ft_i_lvl, 'wusth') !== false) $allow_in_dropdown = true; }
        elseif (strpos($ft_f_lvl, 'ulya') !== false || $ft_f_lvl === 'ula') { if (strpos($ft_i_lvl, 'ulya') !== false || $ft_i_lvl === 'ula') $allow_in_dropdown = true; }
        elseif ($ft_i_lvl === $ft_f_lvl) { $allow_in_dropdown = true; }

        if (!$allow_in_dropdown) continue; // Skip class from other level
    }

    if(!in_array($j['kelas'], $unique_classes)) $unique_classes[] = $j['kelas'];
}
sort($unique_classes);

?>

<div class="relative flex min-h-screen w-full flex-col overflow-x-hidden bg-[#f6f6f8] dark:bg-background-dark font-display text-[#111318] dark:text-white transition-colors duration-200">
      
      <!-- Print Styles -->
      <style>
        @media print {
            @page { margin: 1cm; size: landscape; }
            body * { visibility: hidden; }
            main, main * { visibility: visible; }
            main { position: absolute; left: 0; top: 0; width: 100%; margin: 0; padding: 0; }
            
            /* Hide specific elements */
            header, footer, .hide-print { display: none !important; }
            
            /* Reset Colors for Ink Saving */
            body, main { background: white !important; color: black !important; }
            .bg-white, .dark\:bg-\[\#1a202c\] { background: transparent !important; box-shadow: none !important; border: none !important; }
            .text-gray-500, .text-gray-400, .dark\:text-gray-400 { color: #333 !important; }
            
            /* Table Borders */
            table { border-collapse: collapse; wi dth: 100%; font-size: 11px; font-family: sans-serif; }
            th, td { border: 1px solid #000 !important; padding: 6px !important; }
            th { background-color: #eee !important; -webkit-print-color-adjust: exact; }
            
            /* Badges */
            .rounded-full { border: 1px solid #999; }
        }
      </style>

      <!-- Main Content -->
      <main class="flex-grow">
        <div class="max-w-[1280px] mx-auto px-4 sm:px-6 lg:px-8 py-8">
          <!-- Breadcrumbs -->
          <nav aria-label="Breadcrumb" class="flex mb-6 hide-print">
            <ol class="flex items-center space-x-2">
              <li>
                <a class="text-[#616f89] dark:text-gray-400 hover:text-primary text-sm font-medium" href="<?php echo home_url(); ?>">Beranda</a>
              </li>
              <li>
                <span class="text-[#616f89] dark:text-gray-500 text-sm">/</span>
              </li>
              <li>
                <span aria-current="page" class="text-[#111318] dark:text-white text-sm font-medium">Jadwal KBM</span>
              </li>
            </ol>
          </nav>

          <!-- Page Heading & Actions -->
          <div class="flex flex-col md:flex-row md:items-end justify-between gap-4 mb-8">
            <div>
              <h1 class="text-3xl md:text-4xl font-black text-[#111318] dark:text-white mb-2 tracking-tight">
                Jadwal KBM <?php echo $focus_level ? esc_html($focus_level) : ''; ?>
              </h1>
              <p class="text-[#616f89] dark:text-gray-400 text-base">
                Semester Ganjil Tahun Ajaran <?php echo date('Y'); ?>/<?php echo date('Y')+1; ?>
              </p>
            </div>
            <div class="flex gap-3 hide-print">
              <button onclick="window.print()" class="flex items-center justify-center gap-2 rounded-lg h-10 px-4 bg-white dark:bg-gray-800 border border-[#dbdfe6] dark:border-gray-700 text-[#111318] dark:text-white text-sm font-bold shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                <span class="material-symbols-outlined text-[20px]">print</span>
                <span class="hidden sm:inline">Cetak</span>
              </button>
              <!-- PDF Download Placeholder -->
              <?php /*
              <button class="flex items-center justify-center gap-2 rounded-lg h-10 px-4 bg-primary text-white text-sm font-bold shadow-md hover:bg-primary/90 transition-all">
                <span class="material-symbols-outlined text-[20px]">download</span>
                <span>Download PDF</span>
              </button>
              */ ?>
            </div>
          </div>

          <!-- Filters & Search Toolbar -->
          <form method="get" class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#dbdfe6] dark:border-gray-700 shadow-sm p-4 mb-6 hide-print">
            <div class="flex flex-col lg:flex-row gap-4 justify-between items-center">
              <div class="relative w-full lg:w-96">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                  <span class="material-symbols-outlined text-gray-400">search</span>
                </div>
                <input
                  name="q_jadwal"
                  value="<?php echo esc_attr($search_q); ?>"
                  class="block w-full pl-10 pr-3 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg leading-5 bg-white dark:bg-gray-800 text-gray-900 dark:text-white placeholder-gray-500 focus:outline-none focus:ring-1 focus:ring-primary focus:border-primary sm:text-sm"
                  placeholder="Cari mata pelajaran atau pengajar..."
                  type="text"
                />
              </div>
              <div class="flex flex-wrap w-full lg:w-auto gap-3 items-center">
                <div class="flex items-center gap-2 w-full sm:w-auto">
                  <span class="text-sm font-medium text-gray-700 dark:text-gray-300 whitespace-nowrap hidden sm:block">
                      Filter: <?php echo !empty($focus_level) ? '<span class="text-primary font-bold">(' . esc_html($focus_level) . ')</span>' : ''; ?>
                  </span>
                  
                  <?php if(empty($focus_level)): ?>
                  <select name="level" onchange="this.form.submit()" class="form-select block w-full sm:w-auto pl-3 pr-10 py-2.5 text-sm border-gray-300 dark:border-gray-600 focus:outline-none focus:ring-primary focus:border-primary rounded-lg dark:bg-gray-800 dark:text-white">
                    <option value="">Semua Jenjang</option>
                    <option value="Wustho" <?php selected($filter_level, 'Wustho'); ?>>Wustho</option>
                    <option value="Ulya" <?php selected($filter_level, 'Ulya'); ?>>Ulya</option>
                  </select>
                  <?php else: ?>
                    <input type="hidden" name="level" value="<?php echo esc_attr($focus_level); ?>">
                  <?php endif; ?>

                </div>
                
                <select name="kelas" onchange="this.form.submit()" class="form-select block w-full sm:w-auto pl-3 pr-10 py-2.5 text-sm border-gray-300 dark:border-gray-600 focus:outline-none focus:ring-primary focus:border-primary rounded-lg dark:bg-gray-800 dark:text-white">
                  <option value="">Semua Kelas</option>
                  <?php foreach($unique_classes as $cls): ?>
                    <option value="<?php echo esc_attr($cls); ?>" <?php selected($filter_kelas, $cls); ?>><?php echo esc_html($cls); ?></option>
                  <?php endforeach; ?>
                </select>

                <select name="hari" onchange="this.form.submit()" class="form-select block w-full sm:w-auto pl-3 pr-10 py-2.5 text-sm border-gray-300 dark:border-gray-600 focus:outline-none focus:ring-primary focus:border-primary rounded-lg dark:bg-gray-800 dark:text-white font-medium">
                  <option value="Semua Hari" <?php selected($filter_hari, 'Semua Hari'); ?>>Semua Hari</option>
                  <?php foreach($indo_days as $day): ?>
                    <option value="<?php echo $day; ?>" <?php selected($filter_hari, $day); ?>><?php echo $day; ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
          </form>

          <!-- Info Notice (Static for now, can be dynamic later) -->
          <!--
          <div class="flex items-start gap-3 p-4 mb-6 rounded-lg bg-blue-50 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800 text-blue-800 dark:text-blue-200">
            <span class="material-symbols-outlined text-blue-600 dark:text-blue-400 mt-0.5">info</span>
            <div class="text-sm">
              <span class="font-bold block mb-1">Info Jadwal</span>
              Jadwal dapat berubah sewaktu-waktu.
            </div>
          </div>
          -->

          <!-- Schedule Table -->
          <div class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#dbdfe6] dark:border-gray-700 shadow-sm overflow-hidden min-h-[400px]">
            <div class="overflow-x-auto">
              <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-800">
                  <tr>
                    <?php if($filter_hari == 'Semua Hari'): ?>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Hari</th>
                    <?php endif; ?>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Waktu KBM</th>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Mata Pelajaran</th>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Kelas</th>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Pengajar</th>
                    <th class="px-6 py-4 text-left text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Ruangan</th>
                    <th class="px-6 py-4 text-right text-xs font-bold text-gray-500 dark:text-gray-400 uppercase tracking-wider">Status</th>
                  </tr>
                </thead>
                <tbody class="bg-white dark:bg-[#1a202c] divide-y divide-gray-200 dark:divide-gray-700">
                  
                  <?php if(empty($filtered_data)): ?>
                  <tr>
                      <td colspan="7" class="px-6 py-10 text-center text-gray-500">
                          <span class="material-symbols-outlined text-4xl mb-2 text-gray-400">event_busy</span>
                          <p class="font-bold text-gray-700 dark:text-gray-300">Belum ada data jadwal.</p>
                          <p class="text-sm">Silakan pilih filter lain atau Import Data Jadwal via Dashboard Admin.</p>
                      </td>
                  </tr>
                  <?php else: ?>
                  
                  <?php foreach($filtered_data as $row): 
                        // Color Initials based on Subject Name Hash
                        $colors = ['bg-purple-100 text-purple-600', 'bg-blue-100 text-blue-600', 'bg-green-100 text-green-600', 'bg-yellow-100 text-yellow-600', 'bg-red-100 text-red-600'];
                        $idx = crc32($row['mapel']) % count($colors);
                        $badge_class = $colors[$idx];
                        $initials = strtoupper(substr($row['mapel'], 0, 3));
                  ?>
                  <tr class="hover:bg-gray-50 dark:hover:bg-gray-800/50 transition-colors group">
                    <?php if($filter_hari == 'Semua Hari'): ?>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-700 dark:text-gray-300">
                        <?php echo esc_html($row['hari']); ?>
                        <!-- Debug: Mapel [<?php echo $row['mapel']; ?>] Lvl [<?php echo isset($row['tingkat']) ? $row['tingkat'] : '-'; ?>] Filter [<?php echo $filter_level; ?>] -->
                    </td>
                    <?php endif; ?>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                      <div class="flex items-center gap-2">
                        <span class="material-symbols-outlined text-gray-400 text-sm">schedule</span>
                        <?php echo esc_html($row['jam_mulai']); ?> - <?php echo esc_html($row['jam_selesai']); ?>
                      </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                      <div class="flex items-center">
                        <div class="flex-shrink-0 h-8 w-8 rounded-full <?php echo $badge_class; ?> dark:bg-opacity-20 flex items-center justify-center font-bold text-xs">
                          <?php echo $initials; ?>
                        </div>
                        <div class="ml-4">
                          <div class="text-sm font-medium text-gray-900 dark:text-white">
                            <?php echo esc_html($row['mapel']); ?>
                          </div>
                        </div>
                      </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                      <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900/50 dark:text-blue-200">
                        <?php echo esc_html($row['kelas']); ?>
                      </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                      <div class="flex items-center gap-2">
                        <div class="h-6 w-6 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-xs overflow-hidden">
                            <span class="material-symbols-outlined text-[16px] text-gray-500">person</span>
                        </div>
                        <span><?php echo esc_html($row['pengajar']); ?></span>
                      </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                      <?php echo esc_html($row['ruang']); ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                      <?php 
                        $status_color = 'text-green-600 dark:text-green-400'; 
                        $dot_color = 'bg-green-500';
                        if($row['status'] == 'Libur') { $status_color = 'text-red-600'; $dot_color = 'bg-red-500'; }
                        if($row['status'] == 'Pengganti') { $status_color = 'text-yellow-600'; $dot_color = 'bg-yellow-500'; }
                        if($row['status'] == 'Kosong') { $status_color = 'text-gray-400'; $dot_color = 'bg-gray-400'; }
                      ?>
                      <span class="<?php echo $status_color; ?> flex items-center justify-end gap-1">
                        <span class="w-2 h-2 rounded-full <?php echo $dot_color; ?>"></span>
                        <?php echo esc_html($row['status']); ?>
                      </span>
                    </td>
                  </tr>
                  <?php endforeach; ?>
                  
                  <?php endif; ?>

                </tbody>
              </table>
            </div>
            
          </div> <!-- End Table Card -->

           <!-- Stats Summary (Outside Card) -->
            <div class="flex flex-col sm:flex-row items-center justify-between gap-4 mt-4 px-2">
              <div class="text-sm text-gray-500 dark:text-gray-400 font-medium">
                Menampilkan <span class="text-gray-900 dark:text-white font-bold"><?php echo count($filtered_data); ?></span> kelas
              </div>
              
              <div class="flex flex-wrap items-center gap-4 text-sm text-gray-500 dark:text-gray-400">
                  <div class="flex items-center gap-1.5">
                      <span class="material-symbols-outlined text-[18px]">person</span>
                      <span><?php echo count($stats_pengajar); ?> Pengajar</span>
                  </div>
                  <div class="hidden sm:block w-px h-4 bg-gray-300 dark:bg-gray-600"></div>
                  <div class="flex items-center gap-1.5">
                       <span class="material-symbols-outlined text-[18px]">calendar_today</span>
                      <span><?php echo esc_html($filter_hari); ?></span>
                  </div>
              </div>
            </div>
        </div>
      </main>

</div>
<?php get_footer(); ?>
