<?php
/**
 * Template Name: Kalender Akademik Page
 */
get_header();

// 1. Get Current Month & Year context
$current_month = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
$current_year = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

// Validate
if($current_month < 1 || $current_month > 12) $current_month = date('n');
if($current_year < 2000 || $current_year > 2100) $current_year = date('Y');

// 2. Navigation Logic
$prev_month = $current_month - 1;
$prev_year = $current_year;
if($prev_month < 1) { $prev_month = 12; $prev_year--; }

$next_month = $current_month + 1;
$next_year = $current_year;
if($next_month > 12) { $next_month = 1; $next_year++; }

// 3. Calendar Math
$total_days = cal_days_in_month(CAL_GREGORIAN, $current_month, $current_year);
$first_day_timestamp = mktime(0, 0, 0, $current_month, 1, $current_year);
$first_day_of_week = date('w', $first_day_timestamp); // 0 (Sun) - 6 (Sat)

// 4. Fetch Events for this Month
$all_agenda = get_option('pondok_agenda_list', array());
$month_events = array(); // Indexed by day number

if(!empty($all_agenda)) {
    foreach($all_agenda as $ev) {
        $ev_time = strtotime($ev['date']);
        $ev_m = date('n', $ev_time);
        $ev_y = date('Y', $ev_time);
        $ev_d = intval(date('j', $ev_time));
        
        if($ev_m == $current_month && $ev_y == $current_year) {
            if(!isset($month_events[$ev_d])) $month_events[$ev_d] = array();
            $month_events[$ev_d][] = $ev;
        }
    }
}

// Helper for Indonesian Month Name
$indo_months = array(1=>'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember');
?>

<div class="relative flex min-h-screen w-full flex-col overflow-x-hidden bg-[#f6f6f8] dark:bg-background-dark font-display text-[#111318] dark:text-white transition-colors duration-200">
      
      <!-- Main Content -->
      <main class="flex-1 px-4 md:px-10 py-8 max-w-[1440px] mx-auto w-full">
        <!-- Page Title Area -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8">
          <div class="flex flex-col gap-1">
            <h1 class="text-[#111318] dark:text-white text-3xl md:text-4xl font-black leading-tight tracking-[-0.033em]">
              Kalender Akademik
            </h1>
            <p class="text-[#616f89] dark:text-gray-400 text-base font-normal">
              Agenda Kegiatan Tahun <?php echo $current_year; ?>
            </p>
          </div>
          <div class="flex gap-3">
            <button onclick="window.print()" class="flex cursor-pointer items-center justify-center overflow-hidden rounded-lg h-10 px-4 bg-white dark:bg-gray-800 border border-[#e5e7eb] dark:border-gray-700 text-[#111318] dark:text-white text-sm font-bold shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
              <span class="material-symbols-outlined mr-2 !text-lg">print</span>
              <span class="truncate">Cetak</span>
            </button>
            <?php /*
            <button class="flex cursor-pointer items-center justify-center overflow-hidden rounded-lg h-10 px-4 bg-[#f0f2f4] dark:bg-gray-800 text-[#111318] dark:text-white text-sm font-bold hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors">
              <span class="material-symbols-outlined mr-2 !text-lg">download</span>
              <span class="truncate">Download PDF</span>
            </button>
            */ ?>
          </div>
        </div>

        <!-- Controls & Filters -->
        <div class="flex flex-col lg:flex-row gap-6 mb-6">
          <!-- Left: Legend -->
          <div class="flex-1 flex flex-col gap-6">
            <!-- Category Chips -->
            <div class="flex flex-wrap gap-3">
              <div class="group flex h-8 items-center gap-x-2 rounded-full border border-blue-100 bg-blue-50 dark:bg-blue-900/20 dark:border-blue-800 px-3">
                <div class="size-2 rounded-full bg-blue-500"></div>
                <span class="text-blue-700 dark:text-blue-300 text-sm font-medium">Akademik</span>
              </div>
              <div class="group flex h-8 items-center gap-x-2 rounded-full border border-red-100 bg-red-50 dark:bg-red-900/20 dark:border-red-800 px-3">
                <div class="size-2 rounded-full bg-red-500"></div>
                <span class="text-red-700 dark:text-red-300 text-sm font-medium">Libur Nasional</span>
              </div>
              <div class="group flex h-8 items-center gap-x-2 rounded-full border border-emerald-100 bg-emerald-50 dark:bg-emerald-900/20 dark:border-emerald-800 px-3">
                <div class="size-2 rounded-full bg-emerald-500"></div>
                <span class="text-emerald-700 dark:text-emerald-300 text-sm font-medium">Pendaftaran</span>
              </div>
              <div class="group flex h-8 items-center gap-x-2 rounded-full border border-orange-100 bg-orange-50 dark:bg-orange-900/20 dark:border-orange-800 px-3">
                <div class="size-2 rounded-full bg-orange-500"></div>
                <span class="text-orange-700 dark:text-orange-300 text-sm font-medium">Kegiatan Santri</span>
              </div>
            </div>
          </div>
          <!-- Right: Month Navigation -->
          <div class="flex items-center justify-between lg:justify-end gap-4 min-w-[300px] bg-white dark:bg-gray-800 p-2 rounded-xl border border-gray-100 dark:border-gray-700 shadow-sm">
            <a href="?bulan=<?php echo $prev_month; ?>&tahun=<?php echo $prev_year; ?>" class="size-10 flex items-center justify-center rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 text-[#111318] dark:text-white transition-colors">
              <span class="material-symbols-outlined">chevron_left</span>
            </a>
            <span class="text-lg font-bold text-[#111318] dark:text-white whitespace-nowrap">
                <?php echo $indo_months[$current_month] . ' ' . $current_year; ?>
            </span>
            <a href="?bulan=<?php echo $next_month; ?>&tahun=<?php echo $next_year; ?>" class="size-10 flex items-center justify-center rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 text-[#111318] dark:text-white transition-colors">
              <span class="material-symbols-outlined">chevron_right</span>
            </a>
          </div>
        </div>

        <!-- Main Grid Layout -->
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-6 h-full">
          
          <!-- Calendar Grid (3/4 width) -->
          <div class="lg:col-span-3 bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
            <!-- Days Header -->
            <div class="grid grid-cols-7 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-900/50">
              <div class="py-3 text-center text-sm font-bold text-red-500 dark:text-red-400">MIN</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">SEN</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">SEL</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">RAB</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">KAM</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">JUM</div>
              <div class="py-3 text-center text-sm font-bold text-gray-500 dark:text-gray-400">SAB</div>
            </div>
            
            <!-- Calendar Body -->
            <div class="grid grid-cols-7 auto-rows-[minmax(120px,auto)] text-sm">
              
              <!-- Empty Previous Month Days -->
              <?php for($i=0; $i<$first_day_of_week; $i++): ?>
              <div class="border-b border-r border-gray-100 dark:border-gray-700 p-2 bg-gray-50/30 dark:bg-gray-900/20"></div>
              <?php endfor; ?>

              <!-- Loop Dates -->
              <?php 
              $current_loop_day = 1;
              while($current_loop_day <= $total_days): 
                $day_int = $current_loop_day;
                $has_events = isset($month_events[$day_int]);
                
                // Check if Sunday (for styling red)
                $loop_timestamp = mktime(0,0,0, $current_month, $day_int, $current_year);
                $is_sunday = (date('w', $loop_timestamp) == 0);
                $bg_class = $is_sunday ? 'bg-red-50/20 dark:bg-red-900/5' : '';
                $num_class = $is_sunday ? 'text-red-600 dark:text-red-400' : 'text-gray-700 dark:text-gray-300';
                
                // If Today
                if($day_int == date('j') && $current_month == date('n') && $current_year == date('Y')) {
                    $bg_class = 'bg-blue-50/50 dark:bg-blue-900/10';
                    $num_class = 'bg-primary text-white shadow-md'; // override number style
                } else {
                    $num_class .= ' font-medium'; // normal weight
                }
              ?>
                <div class="group relative border-b border-r border-gray-100 dark:border-gray-700 p-2 hover:bg-gray-50 dark:hover:bg-gray-700/30 transition-colors cursor-pointer <?php echo $bg_class; ?>">
                    <span class="flex size-7 items-center justify-center rounded-full text-sm <?php echo $num_class; ?>">
                        <?php echo $day_int; ?>
                    </span>
                    
                    <div class="mt-1 flex flex-col gap-1">
                        <?php if($has_events): 
                            foreach($month_events[$day_int] as $ev):
                                // Color logic based on category
                                $cat_lower = strtolower($ev['category']);
                                $pill_color = 'bg-gray-100 text-gray-700'; // Default
                                if($cat_lower == 'akademik') $pill_color = 'bg-blue-100 text-blue-700 dark:bg-blue-900/40 dark:text-blue-300';
                                elseif(strpos($cat_lower, 'libur') !== false) $pill_color = 'bg-red-100 text-red-700 dark:bg-red-900/40 dark:text-red-300';
                                elseif(strpos($cat_lower, 'kegiatan') !== false) $pill_color = 'bg-orange-100 text-orange-700 dark:bg-orange-900/40 dark:text-orange-300';
                                elseif(strpos($cat_lower, 'daftar') !== false || strpos($cat_lower, 'psb') !== false) $pill_color = 'bg-emerald-100 text-emerald-700 dark:bg-emerald-900/40 dark:text-emerald-300';
                        ?>
                        <div class="truncate rounded px-1.5 py-0.5 text-xs font-medium <?php echo $pill_color; ?>" title="<?php echo esc_attr($ev['title']); ?>">
                            <?php echo esc_html($ev['title']); ?>
                        </div>
                        <?php endforeach; endif; ?>
                    </div>
                </div>
              <?php $current_loop_day++; endwhile; ?>

              <!-- Fill remaining empty cells to make it square-ish grid if needed, or just let css grid handle -->

            </div>
          </div>

          <!-- Sidebar / Agenda List (1/4 width) -->
          <div class="lg:col-span-1 flex flex-col gap-6">
            <!-- Agenda Card -->
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-5">
              <h3 class="text-lg font-bold text-[#111318] dark:text-white mb-4">
                Agenda <?php echo $indo_months[$current_month]; ?>
              </h3>
              
              <?php if(empty($month_events)): ?>
                 <p class="text-gray-500 text-sm">Belum ada agenda bulan ini.</p>
              <?php else: 
                  // Flatten and sort again locally for sidebar list if needed, stored by days already
                  // Let's iterate days in order
              ?>
              <div class="flex flex-col gap-4 max-h-[500px] overflow-y-auto custom-scrollbar pr-2">
                <?php foreach($month_events as $day => $events): 
                        foreach($events as $ev):
                           $day_str = str_pad($day, 2, '0', STR_PAD_LEFT);
                           $month_short = strtoupper(substr($indo_months[$current_month], 0, 3));
                            // Color for date box
                            $cat_lower = strtolower($ev['category']);
                            $box_color = 'bg-gray-50 text-gray-600 dark:bg-gray-700';
                            if($cat_lower == 'akademik') $box_color = 'bg-blue-50 text-blue-600 dark:bg-blue-900/30';
                            elseif(strpos($cat_lower, 'libur') !== false) $box_color = 'bg-red-50 text-red-600 dark:bg-red-900/30';
                            elseif(strpos($cat_lower, 'kegiatan') !== false) $box_color = 'bg-orange-50 text-orange-600 dark:bg-orange-900/30';
                            elseif(strpos($cat_lower, 'daftar') !== false || strpos($cat_lower, 'psb') !== false) $box_color = 'bg-emerald-50 text-emerald-600 dark:bg-emerald-900/30';
                ?>
                <div class="flex gap-4 items-start group">
                  <div class="flex flex-col items-center justify-center min-w-[3rem] <?php echo $box_color; ?> rounded-lg py-2 transition-colors">
                    <span class="text-xs font-bold opacity-80"><?php echo $month_short; ?></span>
                    <span class="text-lg font-bold text-[#111318] dark:text-white"><?php echo $day_str; ?></span>
                  </div>
                  <div class="flex flex-col">
                    <p class="text-sm font-bold text-[#111318] dark:text-white line-clamp-2"><?php echo esc_html($ev['title']); ?></p>
                    <div class="flex flex-wrap gap-2 mt-1">
                        <?php if(!empty($ev['time'])): ?>
                        <span class="text-xs text-gray-500 flex items-center gap-1">
                          <span class="material-symbols-outlined !text-sm">schedule</span>
                          <?php echo esc_html($ev['time']); ?>
                        </span>
                        <?php endif; ?>
                         <span class="text-xs text-gray-500 flex items-center gap-1">
                          <span class="material-symbols-outlined !text-sm">label</span>
                          <?php echo esc_html($ev['category']); ?>
                        </span>
                    </div>
                  </div>
                </div>
                <?php endforeach; endforeach; ?>
              </div>
              <?php endif; ?>
              
            </div>

            <!-- Additional Info Card (Static/General) -->
            <div class="bg-primary/5 dark:bg-primary/10 rounded-xl p-5 border border-primary/10">
              <div class="flex items-center gap-3 mb-2">
                <div class="bg-white dark:bg-transparent p-2 rounded-full shadow-sm text-primary">
                  <span class="material-symbols-outlined">info</span>
                </div>
                <h4 class="font-bold text-[#111318] dark:text-white">Catatan</h4>
              </div>
              <p class="text-sm text-gray-600 dark:text-gray-300 leading-relaxed">
                Jadwal dapat berubah sewaktu-waktu menyesuaikan kondisi pondok dan kebijakan pengasuh.
              </p>
            </div>
          </div>
        </div>
      </main>
</div>
<?php get_footer(); ?>
