<?php
/**
 * Template Name: Pembayaran PSB
 */

// 1. Get UUID from URL
$uuid = get_query_var('psb_uuid'); 
if(!$uuid && isset($_GET['uuid'])) $uuid = sanitize_text_field($_GET['uuid']);

$registration = null;

// 2. Fetch Registration Data
if($uuid) {
    $args = [
        'post_type'  => 'psb_registration',
        'meta_key'   => 'psb_uuid',
        'meta_value' => $uuid,
        'posts_per_page' => 1,
        'post_status' => ['publish','pending','draft'] 
    ];
    $query = new WP_Query($args);
    if($query->have_posts()) {
        $registration = $query->posts[0];
    }
}

get_header(); 
?>

<main class="flex-grow flex flex-col bg-[#f6f6f8] dark:bg-background-dark text-[#111318] dark:text-gray-100 min-h-screen py-8 px-4 sm:px-6 lg:px-8">
    <div class="mx-auto max-w-4xl w-full">
        
        <!-- Breadcrumbs -->
        <div class="mb-6 flex items-center gap-2 text-sm text-[#616f89] dark:text-gray-400">
            <a class="hover:text-primary transition-colors" href="<?php echo home_url(); ?>">Beranda</a>
            <span class="material-symbols-outlined text-[16px]">chevron_right</span>
            <a class="hover:text-primary transition-colors" href="<?php echo home_url('/pendaftaran'); ?>">Pendaftaran</a>
            <span class="material-symbols-outlined text-[16px]">chevron_right</span>
            <span class="font-medium text-[#111318] dark:text-white">Pembayaran</span>
        </div>

        <?php if($registration): 
            $meta = get_post_custom($registration->ID);
            $nama = $meta['psb_nama'][0] ?? '-';
            $jenjang = $meta['psb_jenjang'][0] ?? '-';
            $nisn = $meta['psb_nisn'][0] ?? '-';
            $phone = $meta['psb_telepon'][0] ?? '-';
            
            // Biaya Configuration (Hardcoded for Demo)
            $biaya_daftar = 250000;
            $kode_unik = rand(1, 99); // Simulation
            $total_bayar = $biaya_daftar + $kode_unik;
        ?>

        <div class="grid grid-cols-1 md:grid-cols-12 gap-8">
            
            <!-- Left: Main Content (8/12) -->
            <div class="md:col-span-12 lg:col-span-8 space-y-6">
                
                <!-- Success Header -->
                <div class="bg-white dark:bg-[#1a202c] rounded-xl p-8 text-center border border-green-100 dark:border-green-900 shadow-sm relative overflow-hidden">
                    <div class="absolute top-0 left-0 w-full h-2 bg-green-500"></div>
                    <div class="inline-flex items-center justify-center size-20 rounded-full bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 mb-4">
                        <span class="material-symbols-outlined text-4xl">check_circle</span>
                    </div>
                    <h1 class="text-2xl font-black text-[#111318] dark:text-white mb-2">Pendaftaran Berhasil Diterima!</h1>
                    <p class="text-[#616f89] dark:text-gray-400">
                        Alhamdulillah, data santri atas nama <strong><?php echo esc_html($nama); ?></strong> telah tersimpan di sistem kami.
                    </p>
                </div>

                <!-- Invoice Card -->
                <div class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#e5e7eb] dark:border-gray-700 shadow-sm overflow-hidden">
                    <div class="p-6 border-b border-[#e5e7eb] dark:border-gray-700 bg-gray-50 dark:bg-[#2d3748] flex justify-between items-center">
                        <h3 class="font-bold text-lg text-[#111318] dark:text-white flex items-center gap-2">
                            <span class="material-symbols-outlined text-primary">receipt_long</span> Rincian Biaya
                        </h3>
                        <span class="bg-yellow-100 text-yellow-800 text-xs font-bold px-3 py-1 rounded-full uppercase tracking-wide">Menunggu Pembayaran</span>
                    </div>
                    
                    <div class="p-6 space-y-4">
                        <div class="flex justify-between items-center text-sm text-gray-600 dark:text-gray-400">
                            <span>Biaya Pendaftaran (Gelombang 1)</span>
                            <span class="font-medium text-[#111318] dark:text-white">Rp <?php echo number_format($biaya_daftar, 0, ',', '.'); ?></span>
                        </div>
                        <div class="flex justify-between items-center text-sm text-gray-600 dark:text-gray-400">
                            <span>Kode Unik (Untuk Verifikasi Otomatis)</span>
                            <span class="font-medium text-[#111318] dark:text-white">Rp <?php echo number_format($kode_unik, 0, ',', '.'); ?></span>
                        </div>
                        <div class="h-px bg-gray-200 dark:bg-gray-700 my-2"></div>
                        <div class="flex justify-between items-center text-lg font-bold text-primary">
                            <span>Total Tagihan</span>
                            <span>Rp <?php echo number_format($total_bayar, 0, ',', '.'); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Educational Warning / Instructions -->
                <div class="p-5 bg-blue-50 dark:bg-blue-900/20 border border-blue-100 dark:border-blue-800 rounded-xl flex gap-4">
                     <span class="material-symbols-outlined text-blue-600 dark:text-blue-400 shrink-0 text-3xl">info</span>
                     <div class="space-y-2">
                         <h4 class="font-bold text-blue-900 dark:text-blue-100">Sebelum Melakukan Pembayaran</h4>
                         <ul class="text-sm text-blue-800 dark:text-blue-200 list-disc ml-4 space-y-1">
                             <li>Mohon pastikan kembali data yang Anda kirimkan sudah benar. Jika ada kesalahan, segera hubungi Admin.</li>
                             <li>Lakukan konfirmasi terlebih dahulu kepada Admin jika Anda ragu mengenai nominal atau metode pembayaran.</li>
                             <li>Setelah pembayaran sukses, notifikasi akan dikirimkan melalui <strong>WhatsApp</strong> ke nomor <?php echo esc_html($phone); ?>.</li>
                         </ul>
                     </div>
                </div>

            </div>

            <!-- Right: Action Sidebar (4/12) -->
            <div class="md:col-span-12 lg:col-span-4 space-y-6">
                
                <!-- Santri Summary -->
                <div class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#e5e7eb] dark:border-gray-700 p-6 shadow-sm">
                    <h3 class="font-bold text-gray-500 uppercase text-xs tracking-wider mb-4">Ringkasan Data Santri</h3>
                    <div class="space-y-3">
                        <div>
                            <span class="text-xs text-gray-400 block">Nama Lengkap</span>
                            <span class="font-semibold text-sm"><?php echo esc_html($nama); ?></span>
                        </div>
                        <div>
                            <span class="text-xs text-gray-400 block">Jenjang</span>
                            <span class="font-semibold text-sm"><?php echo esc_html($jenjang); ?></span>
                        </div>
                        <div>
                            <span class="text-xs text-gray-400 block">NISN</span>
                            <span class="font-semibold text-sm"><?php echo esc_html($nisn); ?></span>
                        </div>
                        <div>
                            <span class="text-xs text-gray-400 block">No. Registrasi (UUID)</span>
                            <span class="font-mono text-xs bg-gray-100 dark:bg-gray-800 p-1 rounded break-all"><?php echo esc_html($uuid); ?></span>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="space-y-3">
                    <button type="button" class="w-full flex items-center justify-center gap-2 bg-primary hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-xl shadow-lg shadow-blue-500/30 transition-all hover:-translate-y-1">
                        <span class="material-symbols-outlined">credit_card</span>
                        Bayar Sekarang (Tripay)
                    </button>
                    
                    <a href="https://wa.me/6281234567890?text=Assalamualaikum,%20Saya%20ingin%20konfirmasi%20pendaftaran%20santri%20atas%20nama%20<?php echo urlencode($nama); ?>%20(ID:%20<?php echo substr($uuid,0,8); ?>)" target="_blank" class="w-full flex items-center justify-center gap-2 bg-white border border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-white text-gray-700 font-bold py-3 px-4 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-700 transition-all">
                        <span class="material-symbols-outlined text-green-500">chat</span>
                        Konfirmasi ke Admin
                    </a>
                    
                    <a href="<?php echo home_url(); ?>" class="block text-center text-sm text-gray-500 hover:text-primary mt-4">
                        Kembali ke Beranda
                    </a>
                </div>

                <!-- Security Note -->
                <div class="flex gap-2 items-center justify-center text-xs text-gray-400 mt-4">
                    <span class="material-symbols-outlined text-[14px]">lock</span>
                    Pembayaran Anda dijamin aman.
                </div>

            </div>

        </div>

        <?php else: ?>
            
            <!-- Not Found State -->
            <div class="flex flex-col items-center justify-center min-h-[400px] text-center">
                <span class="material-symbols-outlined text-6xl text-gray-300 mb-4">search_off</span>
                <h2 class="text-2xl font-bold text-gray-800 dark:text-white">Data Pendaftaran Tidak Ditemukan</h2>
                <p class="text-gray-500 mt-2 mb-6">Mungkin link yang Anda akses kadaluarsa atau salah.</p>
                <a href="<?php echo home_url('/pendaftaran'); ?>" class="bg-primary text-white px-6 py-2 rounded-lg font-bold">Daftar Baru</a>
            </div>

        <?php endif; ?>

    </div>
</main>

<?php get_footer(); ?>
