<?php
/**
 * Template Name: Silabus Page
 */
get_header(); 

// Get stored data
$all_silabus = get_option('pondok_silabus_list', array());

// Get Global School Level Focus
$focus_level = pondok_get_option('school_level_focus', ''); 

// Get Filters
// If Focus Level is set globally, FORCE it as the default filter level, unless URL overrides it (optional, usually we want to Lock it).
// Let's Lock it: If focus_level is active, ignore $_GET['level'] or force it.
if(!empty($focus_level)) {
    $filter_level = $focus_level;
} else {
    $filter_level = isset($_GET['level']) ? $_GET['level'] : '';
}

$filter_cat = isset($_GET['kategori']) ? $_GET['kategori'] : '';
$search_q = isset($_GET['q_silabus']) ? strtolower(trim($_GET['q_silabus'])) : '';
?>

<div class="relative flex h-auto min-h-screen w-full flex-col overflow-x-hidden bg-[#f6f6f8] dark:bg-background-dark font-display">
      
      <div class="flex flex-1 justify-center py-5 px-4 md:px-10 lg:px-40">
        <div class="flex flex-col max-w-[1200px] flex-1">
          <!-- Breadcrumbs -->
          <div class="flex flex-wrap gap-2 px-4 pt-4 pb-2">
            <a class="text-[#616f89] dark:text-gray-400 text-sm font-medium leading-normal hover:text-primary" href="<?php echo home_url(); ?>">Beranda</a>
            <span class="text-[#616f89] dark:text-gray-400 text-sm font-medium leading-normal">/</span>
            <span class="text-[#111318] dark:text-white text-sm font-medium leading-normal"><?php the_title(); ?></span>
          </div>

          <!-- Page Heading -->
          <div class="flex flex-wrap justify-between gap-3 px-4 pb-8">
            <div class="flex min-w-72 flex-col gap-3">
              <h1 class="text-[#111318] dark:text-white text-4xl font-black leading-tight tracking-[-0.033em]">
                Silabus Pembelajaran <?php echo $focus_level ? ' - Tingkat ' . esc_html($focus_level) : ''; ?>
              </h1>
              <p class="text-[#616f89] dark:text-gray-400 text-base font-normal leading-normal max-w-2xl">
                Panduan lengkap kurikulum, materi ajar, dan capaian pembelajaran di setiap tingkatan pendidikan Pondok.
              </p>
            </div>
            
             <!-- PDF Download Button (Optional Logic) -->
             <!-- PDF Download Button -->
             <?php 
                $katalog_pdf = pondok_get_option('silabus_pdf_url'); 
                if($katalog_pdf): 
             ?>
            <div class="flex items-end">
              <a href="#" onclick="openPdfViewer('<?php echo esc_js($katalog_pdf); ?>', 'Katalog Kurikulum & Silabus'); return false;" class="group flex items-center gap-2 px-5 py-2.5 bg-white dark:bg-[#1e2330] border border-[#dbdfe6] dark:border-gray-700 rounded-lg text-sm font-bold hover:bg-primary hover:text-white hover:border-primary transition-all shadow-sm text-[#111318] dark:text-white">
                <span class="material-symbols-outlined text-[20px] group-hover:animate-pulse">visibility</span>
                Lihat Katalog PDF
              </a>
            </div>
             <?php endif; ?>

          </div>

          <!-- Main Layout: Sidebar & Content -->
          <div class="flex flex-col lg:flex-row gap-8 px-4">
            
            <!-- Sidebar Filters -->
            <aside class="w-full lg:w-72 shrink-0 flex flex-col gap-6">
                <form id="silabusFilterForm" method="get">
                  <!-- Preserve Kategori if exists when changing Level -->
                  <?php if($filter_cat) echo '<input type="hidden" name="kategori" value="'.esc_attr($filter_cat).'">'; ?>

                  <!-- Search Bar (Mobile Only) -->
                  <div class="block lg:hidden mb-4">
                    <label class="flex flex-col w-full h-12">
                      <div class="flex w-full flex-1 items-stretch rounded-lg h-full border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-[#1e2330] focus-within:ring-2 focus-within:ring-primary/20 transition-shadow">
                        <div class="text-[#616f89] flex items-center justify-center pl-4">
                          <span class="material-symbols-outlined">search</span>
                        </div>
                        <input
                          name="q_silabus"
                          value="<?php echo esc_attr($search_q); ?>"
                          class="flex w-full min-w-0 flex-1 bg-transparent border-none text-[#111318] dark:text-white focus:outline-none focus:ring-0 placeholder:text-[#616f89] px-3 text-base font-normal leading-normal"
                          placeholder="Cari mata pelajaran..."
                        />
                      </div>
                    </label>
                  </div>

                  <?php if(empty($focus_level)): // ONLY Show Level Filter if NO global focus is set ?>
                  <!-- Filter: Tingkatan -->
                  <div class="rounded-xl border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-[#1e2330] p-5 shadow-sm mb-6">
                    <h3 class="text-[#111318] dark:text-white text-base font-bold mb-4">Tingkatan</h3>
                    <div class="flex flex-col gap-3">
                         <?php 
                         $levels = array('' => 'Semua Tingkatan', 'Wustho' => 'Wustho (Menengah)', 'Ulya' => 'Ulya (Atas)');
                         foreach($levels as $key => $label):
                         ?>
                          <label class="flex items-center gap-3 cursor-pointer group">
                            <input
                              type="radio"
                              name="level"
                              value="<?php echo esc_attr($key); ?>"
                              onchange="this.form.submit()"
                              class="h-5 w-5 border-2 border-[#dbdfe6] bg-transparent text-transparent checked:border-primary checked:bg-primary focus:ring-primary/20 text-primary"
                              <?php checked($filter_level, $key); ?>
                            />
                            <span class="text-[#111318] dark:text-gray-300 text-sm font-medium group-hover:text-primary transition-colors"><?php echo $label; ?></span>
                          </label>
                         <?php endforeach; ?>
                    </div>
                  </div>
                  <?php endif; ?>

                  <!-- Filter: Kategori -->
                  <div class="rounded-xl border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-[#1e2330] p-5 shadow-sm">
                    <h3 class="text-[#111318] dark:text-white text-base font-bold mb-4">Kategori Pelajaran</h3>
                    <div class="flex flex-col gap-3">
                        <?php 
                        // Option All
                        $is_all_active = empty($filter_cat);
                        ?>
                          <a href="<?php echo esc_url(remove_query_arg('kategori')); ?>" 
                             class="flex items-center gap-3 cursor-pointer group">
                            <div class="h-5 w-5 rounded border-2 flex items-center justify-center <?php echo $is_all_active ? 'border-primary bg-primary' : 'border-[#dbdfe6] bg-transparent'; ?>">
                                <?php if($is_all_active): ?><span class="material-symbols-outlined text-white text-[16px] font-bold">check</span><?php endif; ?>
                            </div>
                            <span class="text-sm font-medium group-hover:text-primary transition-colors <?php echo $is_all_active ? 'text-primary font-bold' : 'text-[#111318] dark:text-gray-300'; ?>">
                                Semua Kategori
                            </span>
                          </a>

                        <?php
                        $cats = array('Fiqh' => 'Fiqh & Ushul', 'Aqidah' => 'Aqidah & Akhlak', 'Bahasa' => 'Bahasa Arab', 'Quran' => 'Al-Quran & Hadits', 'Sejarah' => 'Sejarah (SKI)', 'Umum' => 'Umum');
                        function get_silabus_link($key, $current) {
                            $args = $_GET;
                            if($current === $key) unset($args['kategori']); 
                            else $args['kategori'] = $key;
                            return add_query_arg($args);
                        }
                        
                        foreach($cats as $key => $label):
                             $is_active = ($filter_cat === $key);
                        ?>
                          <a href="<?php echo esc_url(get_silabus_link($key, $filter_cat)); ?>" 
                             class="flex items-center gap-3 cursor-pointer group">
                            <div class="h-5 w-5 rounded border-2 flex items-center justify-center <?php echo $is_active ? 'border-primary bg-primary' : 'border-[#dbdfe6] bg-transparent'; ?>">
                                <?php if($is_active): ?><span class="material-symbols-outlined text-white text-[16px] font-bold">check</span><?php endif; ?>
                            </div>
                            <span class="text-sm font-medium group-hover:text-primary transition-colors <?php echo $is_active ? 'text-primary font-bold' : 'text-[#111318] dark:text-gray-300'; ?>">
                                <?php echo $label; ?>
                            </span>
                          </a>
                        <?php endforeach; ?>
                    </div>
                  </div>
                </form>
            </aside>

            <!-- Main Content Area -->
            <main class="flex-1 flex flex-col gap-6">
              
              <!-- Search Bar (Desktop) -->
              <div class="hidden lg:block">
                <form method="get">
                    <!-- Preserve other filters -->
                    <?php if($filter_level) echo '<input type="hidden" name="level" value="'.esc_attr($filter_level).'">'; ?>
                    <?php if($filter_cat) echo '<input type="hidden" name="kategori" value="'.esc_attr($filter_cat).'">'; ?>
                    
                    <label class="flex flex-col w-full h-12">
                      <div class="flex w-full flex-1 items-stretch rounded-lg h-full border border-[#dbdfe6] dark:border-gray-700 bg-white dark:bg-[#1e2330] focus-within:ring-2 focus-within:ring-primary/20 transition-shadow shadow-sm">
                        <div class="text-[#616f89] flex items-center justify-center pl-4">
                          <span class="material-symbols-outlined text-primary">search</span>
                        </div>
                        <input
                          name="q_silabus"
                          value="<?php echo esc_attr($search_q); ?>"
                          class="flex w-full min-w-0 flex-1 bg-transparent border-none text-[#111318] dark:text-white focus:outline-none focus:ring-0 placeholder:text-[#616f89] px-3 text-base font-normal leading-normal"
                          placeholder="Cari mata pelajaran, topik, atau kode..."
                        />
                      </div>
                    </label>
                </form>
              </div>

              <!-- Syllabus List -->
              <div class="flex flex-col gap-4 min-h-[400px]">
                <?php
                $count = 0;
                if (!empty($all_silabus)) :
                    foreach ($all_silabus as $index => $item) {
                        // START FILTER LOGIC
                        if ($search_q) {
                            $match = false;
                            if (strpos(strtolower($item['judul']), $search_q) !== false) $match = true;
                            if (strpos(strtolower($item['kode']), $search_q) !== false) $match = true;
                            if (strpos(strtolower($item['topik']), $search_q) !== false) $match = true;
                            if (!$match) continue;
                        }
                        // Robust Filter
                        $lvl = trim($item['level']);
                        $foc = $filter_level ? trim($filter_level) : '';
                        
                        if ($foc) {
                            $match = false;
                            if(strcasecmp($lvl, $foc) == 0) $match = true;
                            if(stripos($lvl, $foc) !== false) $match = true;
                            // Alias
                            if((strcasecmp($foc, 'Wustho')==0 && strcasecmp($lvl, 'Wustha')==0) || (strcasecmp($foc, 'Wustha')==0 && strcasecmp($lvl, 'Wustho')==0)) $match = true;
                            if(!$match) continue;
                        }
                        if ($filter_cat && strcasecmp($item['kategori'], $filter_cat) !== 0) continue;
                        // END FILTER LOGIC
                        
                        $count++;

                        // Color Logic
                        $color_theme = 'blue'; // Default Ula
                        $icon = 'menu_book';
                        if ($item['level'] == 'Wustha') { $color_theme = 'emerald'; $icon = 'auto_stories'; }
                        if ($item['level'] == 'Ulya') { $color_theme = 'purple'; $icon = 'history_edu'; }
                        if ($item['level'] == 'Ula') { $color_theme = 'amber'; $icon = 'translate'; } // Override specific if needed or randomize
                        
                        // Strict Color Mapping
                        if($item['level'] == 'Ula') { 
                             $bg_light = 'bg-amber-100 dark:bg-amber-900/30'; 
                             $text_color = 'text-amber-700 dark:text-amber-400';
                             $icon_color = 'text-amber-600';
                        } elseif ($item['level'] == 'Wustha') {
                             $bg_light = 'bg-emerald-100 dark:bg-emerald-900/30';
                             $text_color = 'text-emerald-700 dark:text-emerald-400';
                             $icon_color = 'text-emerald-600';
                        } else { // Ulya
                             $bg_light = 'bg-purple-100 dark:bg-purple-900/30';
                             $text_color = 'text-purple-700 dark:text-purple-400';
                             $icon_color = 'text-purple-600';
                        }

                        $topiks = explode("\n", $item['topik']);
                        $refs = explode(",", $item['referensi']);
                ?>
                
                <!-- Card Item -->
                <details class="group bg-white dark:bg-[#1e2330] rounded-xl border border-[#dbdfe6] dark:border-gray-700 shadow-sm overflow-hidden open:ring-2 open:ring-primary/20 transition-all duration-300">
                  <summary class="flex items-center justify-between p-5 cursor-pointer bg-white dark:bg-[#1e2330] hover:bg-gray-50 dark:hover:bg-[#252b3b] transition-colors list-none">
                    <div class="flex items-center gap-4">
                      <div class="size-12 rounded-lg <?php echo $bg_light . ' ' . $icon_color; ?> flex items-center justify-center shrink-0">
                        <span class="material-symbols-outlined"><?php echo $icon; ?></span>
                      </div>
                      <div class="flex flex-col">
                        <div class="flex items-center gap-2 mb-1">
                          <?php if(empty($focus_level)): ?>
                          <span class="text-xs font-bold px-2 py-0.5 rounded <?php echo $bg_light . ' ' . $text_color; ?> uppercase tracking-wide">
                            <?php echo esc_html($item['level']); ?>
                          </span>
                          <?php endif; ?>
                          <span class="text-xs font-medium text-[#616f89] dark:text-gray-500">
                            <?php echo esc_html($item['kode']); ?>
                          </span>
                        </div>
                        <h3 class="text-[#111318] dark:text-white text-lg font-bold">
                            <?php echo esc_html($item['judul']); ?>
                        </h3>
                      </div>
                    </div>
                    <div class="text-[#616f89] transition-transform duration-300 group-open:rotate-180 group-open:text-primary">
                      <span class="material-symbols-outlined">expand_more</span>
                    </div>
                  </summary>

                  <!-- Accordion Content -->
                  <div class="px-5 pb-6 pt-2 border-t border-[#f0f2f4] dark:border-gray-700">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mt-4">
                      <!-- Left Content -->
                      <div class="flex flex-col gap-6">
                        <div>
                          <h4 class="text-sm font-bold text-[#111318] dark:text-white uppercase tracking-wider mb-2 flex items-center gap-2">
                            <span class="material-symbols-outlined text-primary text-[18px]">target</span>
                            Capaian Pembelajaran
                          </h4>
                          <p class="text-[#616f89] dark:text-gray-300 text-sm leading-relaxed">
                            <?php echo nl2br(esc_html($item['deskripsi'])); ?>
                          </p>
                        </div>
                        <?php if(!empty($item['referensi'])): ?>
                        <div>
                          <h4 class="text-sm font-bold text-[#111318] dark:text-white uppercase tracking-wider mb-2 flex items-center gap-2">
                            <span class="material-symbols-outlined text-primary text-[18px]">library_books</span>
                            Referensi Utama
                          </h4>
                          <ul class="flex flex-col gap-2">
                            <?php foreach($refs as $ref): if(empty(trim($ref))) continue; ?>
                            <li class="flex items-start gap-3 p-3 rounded-lg bg-[#f6f6f8] dark:bg-[#141a25]">
                              <div class="h-full w-1 bg-primary rounded-full"></div>
                              <div>
                                <p class="text-sm font-bold text-[#111318] dark:text-white"><?php echo esc_html(trim($ref)); ?></p>
                              </div>
                            </li>
                            <?php endforeach; ?>
                          </ul>
                        </div>
                        <?php endif; ?>
                      </div>
                      
                      <!-- Right Content -->
                      <div class="flex flex-col gap-6">
                         <?php if(!empty($item['topik'])): ?>
                        <div>
                          <h4 class="text-sm font-bold text-[#111318] dark:text-white uppercase tracking-wider mb-2 flex items-center gap-2">
                            <span class="material-symbols-outlined text-primary text-[18px]">list_alt</span>
                            Topik / Materi
                          </h4>
                          <ul class="list-none space-y-2">
                            <?php 
                            $idx = 1;
                            foreach($topiks as $topik): 
                                if(empty(trim($topik))) continue;
                            ?>
                            <li class="flex items-start gap-2 text-sm text-[#616f89] dark:text-gray-300">
                              <span class="text-primary font-bold min-w-[24px]"><?php echo str_pad($idx++, 2, '0', STR_PAD_LEFT); ?>.</span>
                              <span><?php echo esc_html(trim($topik)); ?></span>
                            </li>
                            <?php endforeach; ?>
                          </ul>
                        </div>
                        <?php endif; ?>
                      </div>

                    </div>
                    
                    <?php if(!empty($item['file_url'])): ?>
                    <div class="mt-8 pt-4 border-t border-[#f0f2f4] dark:border-gray-800 flex justify-end">
                      <a href="<?php echo esc_url($item['file_url']); ?>" target="_blank" class="inline-flex items-center gap-2 px-5 py-2.5 bg-primary hover:bg-blue-700 text-white text-sm font-bold rounded-lg transition-colors shadow-sm hover:shadow group/btn">
                        <span class="material-symbols-outlined text-[20px]">download</span>
                        Unduh File Silabus (PDF)
                        <span class="material-symbols-outlined text-[18px] group-hover/btn:translate-x-1 transition-transform">arrow_forward</span>
                      </a>
                    </div>
                    <?php endif; ?>
                  </div>
                </details>

                <?php 
                    } // End Foreach
                endif; 
                
                if($count == 0):
                ?>
                  <div class="flex flex-col items-center justify-center py-20 text-center">
                    <span class="material-symbols-outlined text-6xl text-gray-300 mb-4">search_off</span>
                    <h3 class="text-xl font-bold text-gray-700 dark:text-gray-300">Data Tidak Ditemukan</h3>
                    <p class="text-gray-500">Silakan coba kata kunci atau filter lain, atau tambahkan data di Admin.</p>
                  </div>
                <?php endif; ?>

              </div>
              
              <!-- Pagination (Static Placeholder - Future Impl if needed) -->
              <?php if($count > 10): ?>
              <div class="flex items-center justify-center gap-2 mt-8">
                <button disabled class="flex items-center justify-center w-10 h-10 rounded-lg border border-[#dbdfe6] dark:border-gray-700 text-[#616f89] opacity-50 cursor-not-allowed">
                  <span class="material-symbols-outlined">chevron_left</span>
                </button>
                <div class="text-sm text-gray-500">Menampilkan semua data</div>
                <button disabled class="flex items-center justify-center w-10 h-10 rounded-lg border border-[#dbdfe6] dark:border-gray-700 text-[#616f89] opacity-50 cursor-not-allowed">
                  <span class="material-symbols-outlined">chevron_right</span>
                </button>
              </div>
              <?php endif; ?>

            </main>
          </div>
        </div>
      </div>
</div>

<!-- PDF Viewer Modal (Matched with page-brosur.php) -->
<div id="pdfModal" class="fixed inset-0 z-[100] hidden" role="dialog" aria-modal="true">
    <!-- Backdrop -->
    <div class="absolute inset-0 bg-black/80 backdrop-blur-sm transition-opacity" onclick="closePdfViewer()"></div>
    
    <!-- Modal Content -->
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="relative bg-white dark:bg-gray-900 w-full max-w-5xl h-[85vh] rounded-xl shadow-2xl flex flex-col overflow-hidden animate-in fade-in zoom-in duration-200">
            <!-- Header -->
            <div class="flex items-center justify-between px-4 py-3 border-b border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 z-10 shrink-0">
                <h3 id="pdfTitle" class="text-lg font-bold text-gray-900 dark:text-white truncate pr-4">Document Viewer</h3>
                <div class="flex items-center gap-2">
                    <a id="downloadBtn" href="#" target="_blank" class="hidden sm:flex items-center gap-1 text-sm font-bold text-primary hover:underline px-3">
                        <span class="material-symbols-outlined text-[18px]">download</span> Unduh
                    </a>
                    <button onclick="closePdfViewer()" class="p-2 rounded-full hover:bg-gray-100 dark:hover:bg-gray-800 text-gray-500 hover:text-red-500 transition-colors">
                        <span class="material-symbols-outlined">close</span>
                    </button>
                </div>
            </div>
            
            <!-- Body -->
            <div class="flex-1 bg-gray-100 dark:bg-gray-800 relative">
                <div id="pdfLoader" class="absolute inset-0 flex items-center justify-center">
                    <span class="material-symbols-outlined animate-spin text-4xl text-primary">progress_activity</span>
                </div>
                <!-- Google Docs Viewer for better compatibility -->
                <iframe id="pdfFrame" src="" class="w-full h-full border-none" onload="document.getElementById('pdfLoader').style.display='none'"></iframe>
            </div>
        </div>
    </div>
</div>

<script>
function openPdfViewer(url, title) {
    // Check if URL is valid for Google Viewer (must be public). If local dev, direct iframe is better.
    // Assuming production or public accessible URL.
    var viewerUrl = 'https://docs.google.com/viewer?embedded=true&url=' + encodeURIComponent(url);
    
    // Fallback for local dev or simple generic display if needed:
    // var viewerUrl = url; 

    document.getElementById('pdfFrame').src = viewerUrl;
    document.getElementById('pdfTitle').innerText = title;
    document.getElementById('downloadBtn').href = url;
    document.getElementById('pdfModal').classList.remove('hidden');
    document.body.style.overflow = 'hidden'; // Prevent body scroll
}

function closePdfViewer() {
    document.getElementById('pdfModal').classList.add('hidden');
    document.getElementById('pdfFrame').src = ''; // Clear src
    document.body.style.overflow = ''; // Restore body scroll
}
</script>

<?php get_footer(); ?>
