<?php
/**
 * Template Name: SK Pendirian & Legalitas Page
 */
get_header();

// Fetch Data
$main_sk = get_option('pondok_legalitas_main', array(
    'nomor' => 'AHU-0012345.AH.01.04.Tahun 2020',
    'tanggal' => '20 Januari 2020',
    'lokasi' => 'Jakarta',
    'notaris' => 'H. Muhammad Zulkarnain, S.H., M.Kn.',
    'status' => 'Aktif / Valid',
    'tentang' => 'Pengesahan Pendirian Badan Hukum Yayasan Pondok Dengan sebagai penyelenggara pendidikan.',
    'file_url' => '#' // default fallback if empty
));

$docs = get_option('pondok_legalitas_others', array());
?>

<div class="relative flex min-h-screen w-full flex-col overflow-x-hidden bg-[#f6f6f8] dark:bg-background-dark font-display text-[#111318] dark:text-white transition-colors duration-200">
      
      <!-- Main Content -->
      <main class="flex-grow">
        <!-- Hero Section -->
        <section class="bg-[#f6f6f8] dark:bg-background-dark py-12 border-b border-gray-200 dark:border-gray-800">
          <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
            <nav aria-label="Breadcrumb" class="flex mb-6">
              <ol class="inline-flex items-center space-x-1 md:space-x-2">
                <li class="inline-flex items-center">
                  <a class="inline-flex items-center text-sm font-medium text-gray-500 hover:text-primary dark:text-gray-400 dark:hover:text-white" href="<?php echo home_url(); ?>">
                    <span class="material-symbols-outlined text-lg mr-1 ml-1">home</span>
                    Beranda
                  </a>
                </li>
                <li>
                  <div class="flex items-center">
                    <span class="material-symbols-outlined text-gray-400 text-sm">chevron_right</span>
                    <a class="ml-1 text-sm font-medium text-gray-500 hover:text-primary dark:text-gray-400 dark:hover:text-white md:ml-2" href="#">Profil</a>
                  </div>
                </li>
                <li aria-current="page">
                  <div class="flex items-center">
                    <span class="material-symbols-outlined text-gray-400 text-sm">chevron_right</span>
                    <span class="ml-1 text-sm font-medium text-primary md:ml-2">SK Pendirian</span>
                  </div>
                </li>
              </ol>
            </nav>
            <h1 class="text-3xl md:text-5xl font-black text-[#111318] dark:text-white mb-6 leading-tight">
              SK Pendirian &amp; Legalitas
            </h1>
            <p class="text-gray-600 dark:text-gray-400 max-w-3xl text-lg leading-relaxed">
              Transparansi dan akuntabilitas adalah prioritas kami. Halaman ini memuat dokumen resmi Surat Keputusan (SK) Pendirian serta legalitas operasional Pondok sebagai lembaga pendidikan yang diakui negara.
            </p>
          </div>
        </section>
        
        <!-- Main Document Section -->
        <section class="bg-white dark:bg-[#1a202c] py-16">
          <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
            <div class="flex flex-col lg:flex-row gap-12 items-start">
              
              <!-- Left: Document Visual -->
              <div class="w-full lg:w-5/12 sticky top-24">
                <div class="bg-gray-100 dark:bg-gray-800 rounded-2xl p-4 border border-gray-200 dark:border-gray-700 shadow-lg">
                  <div class="aspect-[1/1.41] bg-white dark:bg-gray-900 rounded-lg shadow-inner flex flex-col relative overflow-hidden group cursor-pointer border border-gray-200 dark:border-gray-700">
                    <div class="absolute inset-0 flex items-center justify-center opacity-5">
                      <span class="material-symbols-outlined text-[200px] text-gray-900 dark:text-white">gavel</span>
                    </div>
                    <!-- Skeleton visual for document look -->
                    <div class="p-8 flex flex-col gap-4 h-full opacity-60">
                      <div class="w-16 h-16 rounded-full bg-gray-200 dark:bg-gray-700 mx-auto mb-4"></div>
                      <div class="w-3/4 h-4 bg-gray-200 dark:bg-gray-700 mx-auto rounded"></div>
                      <div class="w-1/2 h-4 bg-gray-200 dark:bg-gray-700 mx-auto rounded"></div>
                      <div class="my-8 space-y-3">
                        <div class="w-full h-2 bg-gray-100 dark:bg-gray-800 rounded"></div>
                        <div class="w-full h-2 bg-gray-100 dark:bg-gray-800 rounded"></div>
                        <div class="w-full h-2 bg-gray-100 dark:bg-gray-800 rounded"></div>
                        <div class="w-5/6 h-2 bg-gray-100 dark:bg-gray-800 rounded"></div>
                      </div>
                      <div class="mt-auto flex justify-between items-end">
                        <div class="w-20 h-20 rounded-full border-2 border-dashed border-gray-300"></div>
                        <div class="w-32 h-8 bg-gray-200 dark:bg-gray-700 rounded"></div>
                      </div>
                    </div>
                    
                    <!-- Overlay Actions -->
                    <?php if(!empty($main_sk['file_url'])): ?>
                    <a href="<?php echo esc_url($main_sk['file_url']); ?>" target="_blank" class="absolute inset-0 bg-primary/90 flex flex-col items-center justify-center opacity-0 group-hover:opacity-100 transition-all duration-300 backdrop-blur-sm">
                      <span class="material-symbols-outlined text-white text-6xl mb-2 scale-75 group-hover:scale-100 transition-transform duration-300">visibility</span>
                      <span class="text-white font-bold text-lg">Lihat Dokumen</span>
                    </a>
                    <?php else: ?>
                    <div class="absolute inset-0 bg-gray-900/90 flex flex-col items-center justify-center opacity-0 group-hover:opacity-100 transition-all duration-300 backdrop-blur-sm">
                        <span class="material-symbols-outlined text-white text-6xl mb-2">lock</span>
                        <span class="text-white font-bold text-lg">Dokumen Belum Tersedia</span>
                    </div>
                    <?php endif; ?>
                  </div>
                  
                  <?php if(!empty($main_sk['file_url'])): ?>
                  <div class="mt-4 flex justify-between items-center px-2">
                    <div class="flex items-center gap-2">
                      <span class="material-symbols-outlined text-red-500">picture_as_pdf</span>
                      <span class="text-sm font-medium text-gray-700 dark:text-gray-300 truncate max-w-[200px]">
                        <?php echo basename($main_sk['file_url']); ?>
                      </span>
                    </div>
                    <span class="text-xs text-gray-500 dark:text-gray-400">PDF</span>
                  </div>
                  <?php endif; ?>
                </div>
              </div>
              
              <!-- Right: Document Details -->
              <div class="w-full lg:w-7/12 flex flex-col gap-8">
                <div>
                  <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-blue-50 dark:bg-blue-900/30 text-primary text-xs font-bold uppercase tracking-wider mb-4">
                    <span class="w-2 h-2 rounded-full bg-primary animate-pulse"></span>
                    Dokumen Utama
                  </div>
                  <h2 class="text-2xl md:text-3xl font-bold text-[#111318] dark:text-white mb-4">
                    Keputusan Menteri Hukum dan Hak Asasi Manusia Republik Indonesia
                  </h2>
                  <p class="text-gray-600 dark:text-gray-300 leading-relaxed mb-6">
                    Pondok berdiri di atas landasan hukum yang kuat. Dokumen ini mensahkan pendirian badan hukum yayasan sesuai dengan peraturan perundang-undangan yang berlaku di Indonesia.
                  </p>
                  <div class="bg-background-light dark:bg-background-dark rounded-xl border border-gray-200 dark:border-gray-700 overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-800/50 flex justify-between items-center">
                      <h3 class="font-bold text-[#111318] dark:text-white">Detail SK</h3>
                      <span class="material-symbols-outlined text-gray-400">info</span>
                    </div>
                    <div class="p-6">
                      <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-6 gap-y-6">
                        <div class="sm:col-span-2">
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Nomor Keputusan</dt>
                          <dd class="mt-1 text-lg font-mono font-semibold text-[#111318] dark:text-white select-all">
                            <?php echo esc_html($main_sk['nomor']); ?>
                          </dd>
                        </div>
                        <div>
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Tanggal Penetapan</dt>
                          <dd class="mt-1 text-base font-semibold text-[#111318] dark:text-white">
                            <?php echo esc_html($main_sk['tanggal']); ?>
                          </dd>
                        </div>
                        <div>
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Ditetapkan Di</dt>
                          <dd class="mt-1 text-base font-semibold text-[#111318] dark:text-white">
                            <?php echo esc_html($main_sk['lokasi']); ?>
                          </dd>
                        </div>
                        <div>
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Notaris</dt>
                          <dd class="mt-1 text-base font-semibold text-[#111318] dark:text-white">
                            <?php echo esc_html($main_sk['notaris']); ?>
                          </dd>
                        </div>
                        <div>
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Status</dt>
                          <dd class="mt-1 inline-flex items-center gap-1 text-base font-semibold text-green-600 dark:text-green-400">
                            <span class="material-symbols-outlined text-lg">check_circle</span>
                            <?php echo esc_html($main_sk['status']); ?>
                          </dd>
                        </div>
                        <div class="sm:col-span-2 pt-4 border-t border-gray-200 dark:border-gray-700">
                          <dt class="text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wide">Tentang</dt>
                          <dd class="mt-1 text-base font-medium text-[#111318] dark:text-white leading-relaxed">
                            <?php echo esc_html($main_sk['tentang']); ?>
                          </dd>
                        </div>
                      </dl>
                    </div>
                  </div>
                </div>
                
                <?php if(!empty($main_sk['file_url'])): ?>
                <div class="flex flex-col sm:flex-row gap-4 pt-4 border-t border-gray-100 dark:border-gray-800">
                  <a href="<?php echo esc_url($main_sk['file_url']); ?>" download class="flex-1 group flex items-center justify-center gap-3 bg-primary hover:bg-blue-700 text-white font-bold py-4 px-8 rounded-xl transition-all shadow-lg hover:shadow-primary/30">
                    <span class="material-symbols-outlined group-hover:-translate-y-1 transition-transform">download</span>
                    <div class="flex flex-col items-start leading-none">
                      <span class="text-xs font-normal opacity-80">Download File</span>
                      <span>Unduh PDF</span>
                    </div>
                  </a>
                  <button onclick="window.print()" class="flex-none flex items-center justify-center gap-2 bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-800 text-[#111318] dark:text-white font-bold py-4 px-6 rounded-xl transition-colors">
                    <span class="material-symbols-outlined">print</span>
                  </button>
                  <button class="flex-none flex items-center justify-center gap-2 bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-800 text-[#111318] dark:text-white font-bold py-4 px-6 rounded-xl transition-colors">
                    <span class="material-symbols-outlined">share</span>
                  </button>
                </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </section>
        
        <!-- Other Documents Section -->
        <section class="bg-[#f6f6f8] dark:bg-background-dark py-16 border-t border-gray-200 dark:border-gray-800">
          <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
            <div class="flex flex-col md:flex-row justify-between items-end mb-10 gap-4">
              <div>
                <h2 class="text-2xl font-bold text-[#111318] dark:text-white mb-2">
                  Dokumen Legalitas Lainnya
                </h2>
                <p class="text-gray-600 dark:text-gray-400">
                  Berkas pendukung operasional dan akreditasi lembaga.
                </p>
              </div>
              <div class="relative w-full md:w-auto">
                <input id="docSearch" class="w-full md:w-64 pl-10 pr-4 py-2 rounded-lg border-gray-200 dark:border-gray-700 bg-white dark:bg-[#1a202c] text-sm focus:border-primary focus:ring-primary" placeholder="Cari dokumen..." type="text">
                <span class="material-symbols-outlined absolute left-3 top-2.5 text-gray-400 text-lg">search</span>
              </div>
            </div>
            
            <div id="docGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <?php 
              if(empty($docs)): 
                  // Fallback dummy data if empty
                  $docs = array(
                      array('title'=>'Ijin Operasional Pesantren', 'desc'=>'Surat Keputusan Kementerian Agama', 'issuer'=>'Kemenag', 'icon'=>'verified', 'file_url'=>'#'),
                      array('title'=>'Ijin Operasional SMP', 'desc'=>'Izin penyelenggaraan Sekolah Menengah', 'issuer'=>'Dinas Pendidikan', 'icon'=>'school', 'file_url'=>'#'),
                  );
              endif;

              $color_classes = ['green', 'blue', 'orange', 'purple', 'red'];
              
              foreach($docs as $idx => $doc):
                  $color_key = $color_classes[$idx % count($color_classes)];
                  
                  // Map colors to specific Tailwind classes to ensure they are purged correctly
                  $bg_class = '';
                  $text_class = '';
                  
                  switch($color_key) {
                      case 'green': 
                          $bg_class = 'bg-green-50 dark:bg-green-900/20';
                          $text_class = 'text-green-600 dark:text-green-400';
                          break;
                      case 'blue': 
                          $bg_class = 'bg-blue-50 dark:bg-blue-900/20';
                          $text_class = 'text-blue-600 dark:text-blue-400';
                          break;
                      case 'orange': 
                          $bg_class = 'bg-orange-50 dark:bg-orange-900/20';
                          $text_class = 'text-orange-600 dark:text-orange-400';
                          break;
                      case 'purple': 
                          $bg_class = 'bg-purple-50 dark:bg-purple-900/20';
                          $text_class = 'text-purple-600 dark:text-purple-400';
                          break;
                      case 'red': 
                          $bg_class = 'bg-red-50 dark:bg-red-900/20';
                          $text_class = 'text-red-600 dark:text-red-400';
                          break;
                  }
              ?>
              <a href="<?php echo esc_url($doc['file_url']); ?>" target="_blank" class="doc-card group flex flex-col bg-white dark:bg-[#1a202c] rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary/50 hover:shadow-lg transition-all p-6">
                <div class="flex justify-between items-start mb-4">
                  <div class="size-12 rounded-lg <?php echo $bg_class; ?> <?php echo $text_class; ?> flex items-center justify-center">
                    <span class="material-symbols-outlined"><?php echo esc_html(!empty($doc['icon']) ? $doc['icon'] : 'description'); ?></span>
                  </div>
                  <span class="material-symbols-outlined text-gray-300 group-hover:text-primary transition-colors">arrow_outward</span>
                </div>
                <h3 class="doc-title text-lg font-bold text-[#111318] dark:text-white mb-2 group-hover:text-primary transition-colors">
                  <?php echo esc_html($doc['title']); ?>
                </h3>
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-4 line-clamp-2">
                   <?php echo esc_html($doc['desc']); ?>
                </p>
                <div class="mt-auto pt-4 border-t border-gray-100 dark:border-gray-800 flex items-center justify-between text-xs text-gray-500">
                  <span><?php echo esc_html($doc['issuer']); ?></span>
                  <span class="flex items-center gap-1 bg-gray-100 dark:bg-gray-800 px-2 py-1 rounded">PDF</span>
                </div>
              </a>
              <?php endforeach; ?>
            </div>
          </div>
        </section>

      </main>
</div>

<script>
// Simple Filter Script
document.getElementById('docSearch').addEventListener('keyup', function() {
    let filter = this.value.toUpperCase();
    let cards = document.querySelectorAll('.doc-card');
    
    cards.forEach(card => {
        let title = card.querySelector('.doc-title').textContent || card.querySelector('.doc-title').innerText;
        if (title.toUpperCase().indexOf(filter) > -1) {
            card.style.display = "";
        } else {
            card.style.display = "none";
        }
    });
});
</script>

<?php get_footer(); ?>
