/**
 * Main JS
 * Handles Mobile Menu Toggle and other interactions.
 */
document.addEventListener("DOMContentLoaded", () => {
  // Select elements
  const mobileMenuBtn = document.getElementById("mobile-menu-btn");
  const mobileMenu = document.getElementById("mobile-menu");

  // Toggle Mobile Menu
  if (mobileMenuBtn && mobileMenu) {
    mobileMenuBtn.addEventListener("click", () => {
      // Toggle 'hidden' class to show/hide menu
      mobileMenu.classList.toggle("hidden");

      // Optional: Toggle icon (menu <-> close)
      const icon = mobileMenuBtn.querySelector(".material-symbols-outlined");
      if (icon) {
        if (mobileMenu.classList.contains("hidden")) {
          icon.textContent = "menu";
        } else {
          icon.textContent = "close";
        }
      }
    });
  }
});
