        </main>
        
        <!-- Footer -->
        <footer class="bg-white dark:bg-[#11161f] border-t border-gray-200 dark:border-gray-800 pt-16 pb-8">
            <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
                    <!-- Brand -->
                    <div class="flex flex-col gap-4">
                        <div class="flex items-center gap-3 text-[#111318] dark:text-white">
                            <?php 
                            $site_logo = pondok_get_option('site_logo');
                            if ( ! empty( $site_logo ) ) : 
                            ?>
                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                    <img src="<?php echo esc_url( $site_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>" class="h-10 w-auto object-contain">
                                </a>
                            <?php else : ?>
                                <div class="size-8 text-primary">
                                    <span class="material-symbols-outlined" style="font-size: 32px;">school</span>
                                </div>
                                <h2 class="text-xl font-bold"><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </div>
                        <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
                            <?php echo esc_html( pondok_get_option('footer_desc') ); ?>
                        </p>
                        <div class="flex gap-4 mt-2">
                             <?php if ( pondok_get_option('social_facebook') !== '#' ) : ?>
                            <a class="size-10 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-600 dark:text-gray-300 hover:bg-primary hover:text-white transition-colors" href="<?php echo esc_url( pondok_get_option('social_facebook') ); ?>">
                                <span class="material-symbols-outlined text-xl">thumb_up</span>
                            </a>
                            <?php endif; ?>
                            <?php if ( pondok_get_option('social_instagram') !== '#' ) : ?>
                            <a class="size-10 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-600 dark:text-gray-300 hover:bg-primary hover:text-white transition-colors" href="<?php echo esc_url( pondok_get_option('social_instagram') ); ?>">
                                <span class="material-symbols-outlined text-xl">photo_camera</span>
                            </a>
                            <?php endif; ?>
                            <?php if ( pondok_get_option('social_youtube') !== '#' ) : ?>
                            <a class="size-10 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-600 dark:text-gray-300 hover:bg-primary hover:text-white transition-colors" href="<?php echo esc_url( pondok_get_option('social_youtube') ); ?>">
                                <span class="material-symbols-outlined text-xl">smart_display</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Quick Links -->
                    <div class="flex flex-col gap-4">
                        <h3 class="text-[#111318] dark:text-white font-bold text-lg">Pintasan</h3>
                        <ul class="flex flex-col gap-2">
                             <?php
                            wp_nav_menu( array(
                                'theme_location' => 'footer',
                                'container'      => false,
                                'items_wrap'     => '%3$s',
                                'fallback_cb'    => false,
                                'walker'         => new class extends Walker_Nav_Menu {
                                    function start_el(&$output, $item, $depth=0, $args=null, $id=0) {
                                        $output .= "<li><a href='" . $item->url . "' class='text-gray-600 dark:text-gray-400 hover:text-primary text-sm'>" . $item->title . "</a></li>";
                                    }
                                }
                            ) );
                            ?>
                        </ul>
                    </div>

                    <!-- Programs (Static for now, could be dynamic) -->
                     <!-- Ideally this would be another Menu Location like 'footer-2' -->
                    <!-- Footer Column 2: Programs -->
                    <div class="flex flex-col gap-4">
                        <h3 class="text-[#111318] dark:text-white font-bold text-lg">Program Pendidikan</h3>
                        <ul class="flex flex-col gap-2">
                             <?php
                            wp_nav_menu( array(
                                'theme_location' => 'footer-academic',
                                'container'      => false,
                                'items_wrap'     => '%3$s',
                                'fallback_cb'    => false,
                                'walker'         => new class extends Walker_Nav_Menu {
                                    function start_el(&$output, $item, $depth=0, $args=null, $id=0) {
                                        $output .= "<li><a href='" . $item->url . "' class='text-gray-600 dark:text-gray-400 hover:text-primary text-sm'>" . $item->title . "</a></li>";
                                    }
                                }
                            ) );
                            ?>
                        </ul>
                    </div>

                    <!-- Contact -->
                    <div class="flex flex-col gap-4">
                        <h3 class="text-[#111318] dark:text-white font-bold text-lg">Contact Us</h3>
                        <ul class="flex flex-col gap-3">
                            <li class="flex items-start gap-3 text-gray-600 dark:text-gray-400 text-sm">
                                <span class="material-symbols-outlined text-primary mt-0.5">location_on</span>
                                <span><?php echo nl2br( esc_html( pondok_get_option('office_address') ) ); ?></span>
                            </li>
                            <li class="flex items-center gap-3 text-gray-600 dark:text-gray-400 text-sm">
                                <span class="material-symbols-outlined text-primary">call</span>
                                <span><?php echo esc_html( pondok_get_option('phone_number') ); ?></span>
                            </li>
                            <li class="flex items-center gap-3 text-gray-600 dark:text-gray-400 text-sm">
                                <span class="material-symbols-outlined text-primary">mail</span>
                                <span><?php echo esc_html( pondok_get_option('email_address') ); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="border-t border-gray-200 dark:border-gray-800 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
                    <p class="text-gray-500 text-sm text-center md:text-left">
                        <?php echo esc_html( pondok_get_option('footer_copyright') ); ?>
                    </p>
                    <div class="flex gap-6">
                        <a class="text-gray-500 hover:text-primary text-sm" href="#">Privacy Policy</a>
                        <a class="text-gray-500 hover:text-primary text-sm" href="#">Terms of Service</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
    <?php wp_footer(); ?>
</body>
</html>
