<?php get_header(); ?>

<!-- Hero Section -->
<section class="relative bg-white dark:bg-[#1a202c]">
    <div class="w-full h-[600px] bg-cover bg-center bg-no-repeat relative flex items-center justify-center" 
         data-alt="Modern islamic boarding school campus exterior at sunset" 
         style='background-image: linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.6)), url("<?php echo esc_url( pondok_get_option( 'hero_image' ) ); ?>");'>
        <div class="container mx-auto px-4 text-center z-10 max-w-4xl">
            <h1 class="text-white text-4xl md:text-6xl font-black leading-tight tracking-tight mb-6 drop-shadow-lg">
                <?php echo esc_html( pondok_get_option( 'hero_title' ) ); ?>
            </h1>
            <p class="text-gray-100 text-lg md:text-xl font-normal leading-relaxed mb-8 max-w-2xl mx-auto drop-shadow-md">
                <?php echo esc_html( pondok_get_option( 'hero_desc' ) ); ?>
            </p>
            <div class="flex flex-wrap gap-4 justify-center">
                <a href="<?php echo esc_url( site_url('/kurikulum') ); ?>"
                 class="flex items-center justify-center rounded-lg h-12 px-8 bg-primary hover:brightness-90 text-white text-base font-bold transition-all">
                    Lihat Program
                </a>

                <a href="<?php echo esc_url( site_url('/pendaftaran') ); ?>"
                   class="flex items-center justify-center rounded-lg h-12 px-8 bg-white/10 hover:bg-white/20 backdrop-blur-md border border-white/30 text-white text-base font-bold transition-all">
                    Gabung Sekarang
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Features / Highlights -->
<section class="py-16 bg-background-light dark:bg-background-dark">
    <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
        <div class="flex flex-col gap-4 mb-12 text-center md:text-left">
            <h2 class="text-[#111318] dark:text-white text-3xl md:text-4xl font-bold leading-tight tracking-tight">
                Mengapa Memilih <?php bloginfo('name'); ?>?
            </h2>
            <p class="text-gray-600 dark:text-gray-400 text-base max-w-2xl">
                Nilai-nilai inti dan keunggulan kami dalam membentuk karakter santri yang berakhlak mulia dan berwawasan luas.
            </p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Card 1 -->
            <div class="flex flex-col gap-4 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-[#1a202c] p-6 shadow-sm hover:shadow-md transition-shadow">
                <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary mb-2">
                    <span class="material-symbols-outlined text-3xl">school</span>
                </div>
                <div class="flex flex-col gap-2">
                    <h3 class="text-[#111318] dark:text-white text-xl font-bold"><?php echo esc_html( pondok_get_option('feature_1_title') ); ?></h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
                        <?php echo esc_html( pondok_get_option('feature_1_desc') ); ?>
                    </p>
                </div>
            </div>
            <!-- Card 2 -->
            <div class="flex flex-col gap-4 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-[#1a202c] p-6 shadow-sm hover:shadow-md transition-shadow">
                <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary mb-2">
                    <span class="material-symbols-outlined text-3xl">menu_book</span>
                </div>
                <div class="flex flex-col gap-2">
                    <h3 class="text-[#111318] dark:text-white text-xl font-bold"><?php echo esc_html( pondok_get_option('feature_2_title') ); ?></h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
                         <?php echo esc_html( pondok_get_option('feature_2_desc') ); ?>
                    </p>
                </div>
            </div>
            <!-- Card 3 -->
            <div class="flex flex-col gap-4 rounded-xl border border-gray-200 dark:border-gray-700 bg-white dark:bg-[#1a202c] p-6 shadow-sm hover:shadow-md transition-shadow">
                <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary mb-2">
                    <span class="material-symbols-outlined text-3xl">mosque</span>
                </div>
                <div class="flex flex-col gap-2">
                    <h3 class="text-[#111318] dark:text-white text-xl font-bold"><?php echo esc_html( pondok_get_option('feature_3_title') ); ?></h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
                         <?php echo esc_html( pondok_get_option('feature_3_desc') ); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="py-16 bg-white dark:bg-[#1a202c]">
    <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
        <div class="flex flex-col lg:flex-row gap-12 items-center">
            <div class="w-full lg:w-1/2">
                <div class="relative rounded-2xl overflow-hidden shadow-2xl aspect-video lg:aspect-[4/3] bg-gray-200" style="background-image: url('https://najahteam.space/ponpesdev/wp-content/uploads/2025/12/mufid-majnun-IaZpwL9y1-I-unsplash-scaled.webp'); background-size: cover; background-position: center;">
                    <!-- Overlay gradient for text readability if needed inside image -->
                </div>
            </div>
            <div class="w-full lg:w-1/2 flex flex-col gap-6">
                <div class="flex flex-col gap-3">
                    <span class="text-primary font-bold tracking-wider uppercase text-sm">Tentang Pesantren</span>
                    <h2 class="text-[#111318] dark:text-white text-4xl font-black leading-tight tracking-tight">
                        Siapa Kami
                    </h2>
                    <p class="text-gray-600 dark:text-gray-300 text-lg leading-relaxed">
                        Didirikan untuk membina generasi penerus, <?php bloginfo('name'); ?> memadukan kearifan tradisional (Salaf) dengan pendidikan modern untuk mendorong pertumbuhan holistik setiap santri.
                    </p>
                    <p class="text-gray-600 dark:text-gray-300 text-base leading-relaxed">
                        Lembaga kami berkomitmen menyediakan lingkungan yang aman, inklusif, dan merangsang di mana santri dapat berkembang secara akademis, sosial, dan spiritual. Kami percaya pada kekuatan pendidikan untuk mengubah kehidupan dan masyarakat.
                    </p>
                </div>
                <button class="w-fit flex items-center justify-center rounded-lg h-12 px-6 bg-gray-100 hover:bg-gray-200 dark:bg-gray-700 dark:hover:bg-gray-600 text-[#111318] dark:text-white text-base font-bold transition-colors gap-2">
                    <span>Baca Selengkapnya</span>
                    <span class="material-symbols-outlined text-sm">arrow_forward</span>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Academic Resources Section -->
<section class="py-16 bg-background-light dark:bg-background-dark">
    <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
        <div class="flex justify-between items-end mb-8 px-2">
            <h2 class="text-[#111318] dark:text-white text-3xl font-bold leading-tight">Akademik & Fasilitas</h2>
            <a class="hidden md:flex items-center gap-1 text-primary font-bold hover:underline" href="https://najahteam.space/ponpesdev/kurikulum/">
                Lihat Semua <span class="material-symbols-outlined text-sm">arrow_forward</span>
            </a>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <!-- Academic Calendar -->
            <a class="group flex flex-col gap-4 p-6 rounded-xl bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:border-primary/50 hover:shadow-lg transition-all" href="#">
                <div class="size-10 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-primary flex items-center justify-center group-hover:scale-110 transition-transform">
                    <span class="material-symbols-outlined">calendar_month</span>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-[#111318] dark:text-white group-hover:text-primary transition-colors">Kalender Akademik</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Jadwal tahunan pesantren</p>
                </div>
            </a>
            <!-- Curriculum -->
            <a class="group flex flex-col gap-4 p-6 rounded-xl bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:border-primary/50 hover:shadow-lg transition-all" href="#">
                <div class="size-10 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-primary flex items-center justify-center group-hover:scale-110 transition-transform">
                    <span class="material-symbols-outlined">account_tree</span>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-[#111318] dark:text-white group-hover:text-primary transition-colors">Kurikulum</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Paduan Salaf & Nasional</p>
                </div>
            </a>
            <!-- KBM Schedule -->
            <a class="group flex flex-col gap-4 p-6 rounded-xl bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:border-primary/50 hover:shadow-lg transition-all" href="#">
                <div class="size-10 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-primary flex items-center justify-center group-hover:scale-110 transition-transform">
                    <span class="material-symbols-outlined">schedule</span>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-[#111318] dark:text-white group-hover:text-primary transition-colors">Jadwal KBM</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Kegiatan Harian Santri</p>
                </div>
            </a>
            <!-- Syllabus -->
            <a class="group flex flex-col gap-4 p-6 rounded-xl bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-700 hover:border-primary/50 hover:shadow-lg transition-all" href="#">
                <div class="size-10 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-primary flex items-center justify-center group-hover:scale-110 transition-transform">
                    <span class="material-symbols-outlined">description</span>
                </div>
                <div>
                    <h3 class="text-lg font-bold text-[#111318] dark:text-white group-hover:text-primary transition-colors">Silabus Kajian</h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">Kitab-kitab yang dikaji</p>
                </div>
            </a>
        </div>
    </div>
</section>

<!-- Latest Articles -->
<section class="py-16 bg-white dark:bg-[#1a202c]">
    <div class="container mx-auto px-4 lg:px-10 max-w-7xl">
        <div class="text-center mb-12">
            <h2 class="text-[#111318] dark:text-white text-3xl font-bold mb-4">Kabar Pesantren</h2>
            <p class="text-gray-600 dark:text-gray-400">Update berita, kajian, dan kegiatan terbaru dari Pondok.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php 
            $recent_posts = new WP_Query(array('posts_per_page' => 3));
            if($recent_posts->have_posts()) :
                while($recent_posts->have_posts()) : $recent_posts->the_post();
            ?>
            <!-- Dynamic Post Item -->
            <article class="flex flex-col group cursor-pointer">
                <div class="overflow-hidden rounded-xl mb-4 aspect-[4/3]">
                    <div class="w-full h-full bg-cover bg-center transform group-hover:scale-110 transition-transform duration-500" 
                         style="background-image: url('<?php echo has_post_thumbnail() ? get_the_post_thumbnail_url() : 'https://placehold.co/600x400'; ?>');">
                    </div>
                </div>
                <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                    <span class="material-symbols-outlined text-base">calendar_today</span>
                    <span><?php echo get_the_date(); ?></span>
                    <span class="w-1 h-1 rounded-full bg-gray-400"></span>
                    <span class="text-primary font-medium"><?php the_category(', '); ?></span>
                </div>
                <h3 class="text-xl font-bold text-[#111318] dark:text-white mb-2 group-hover:text-primary transition-colors">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
                <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                    <?php echo get_the_excerpt(); ?>
                </p>
            </article>
            <?php 
                endwhile;
                wp_reset_postdata();
            else:
            ?>
                <!-- Fallback/Placeholder if no posts exist yet -->
                 <article class="flex flex-col group cursor-pointer">
                    <div class="overflow-hidden rounded-xl mb-4 aspect-[4/3]">
                        <div class="w-full h-full bg-cover bg-center transform group-hover:scale-110 transition-transform duration-500" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuAxiWkzJS6xbIdKrhlBSRHH1IJ1hfLRb3zFHtc6719-FYB8xhWeM1hQENM1sIQK0Nv28Oc8XHuDCtSth5NLXUjAKjhmw8NcIm85XSIU0TTPlxufNcLF5OHtLghjyTL3Ps-R1iLZhaiQRNYL5Nco1xG7g4u-5kGiIbrtVEwQNX5NHVSnZjN_beIAZwIiSo4-Pwjqoz2XWGmdj_SifKYi3eosDNxm3NfNvUND8yyw6KW0HN7lzi_Q1PLulkGht94oM_u_EG35cK9qdKHp');"></div>
                    </div>
                    <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                        <span class="material-symbols-outlined text-base">calendar_today</span>
                        <span>Sample Date</span>
                        <span class="w-1 h-1 rounded-full bg-gray-400"></span>
                        <span class="text-primary font-medium">Sample</span>
                    </div>
                    <h3 class="text-xl font-bold text-[#111318] dark:text-white mb-2 group-hover:text-primary transition-colors">
                        Sample Post Title
                    </h3>
                    <p class="text-gray-600 dark:text-gray-400 text-sm line-clamp-2">
                        This is a sample post. It will appear until you add real posts to your WordPress.
                    </p>
                </article>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>
