<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once get_template_directory() . '/inc/theme-options.php';
require_once get_template_directory() . '/inc/nav-walker.php';
require_once get_template_directory() . '/inc/image-optimization.php';
require_once get_template_directory() . '/inc/asatidz-simple-settings.php'; // Simple Asatidz Settings
require_once get_template_directory() . '/inc/brosur-simple-settings.php'; // Simple Brosur Settings
require_once get_template_directory() . '/inc/silabus-simple-settings.php'; // Simple Silabus Settings
require_once get_template_directory() . '/inc/jadwal-simple-settings.php'; // Simple Jadwal Settings
require_once get_template_directory() . '/inc/kalender-simple-settings.php'; // Simple Kalender Settings
require_once get_template_directory() . '/inc/legalitas-simple-settings.php';
require_once get_template_directory() . '/inc/simple-csv-importer.php'; // CSV Importer Module
    // Load textdomain
    load_theme_textdomain( 'pondok', get_template_directory() . '/languages' );
    
    // Custom Rewrite Rule for Payment Page
    add_rewrite_rule('^pembayaran-psb/([a-zA-Z0-9-]+)/?', 'index.php?pagename=pembayaran-psb&psb_uuid=$matches[1]', 'top');
    add_filter('query_vars', function($vars) {
        $vars[] = 'psb_uuid';
        return $vars;
    });
    add_filter('template_include', function($template) {
        if ( get_query_var('pagename') == 'pembayaran-psb' ) {
            // Fix 404 Status for Virtual Page
            global $wp_query;
            $wp_query->is_404 = false;
            status_header(200);
            
            // Override Document Title
            add_filter('pre_get_document_title', function($title){
                return 'Pembayaran PSB - Pondok Pesantren Nurul Huda';
            });

            $new_template = locate_template( array( 'templates/page-pembayaran-psb.php' ) );
            if ( '' != $new_template ) {
                return $new_template;
            }
        }
        return $template;
    });

    // Auto Flush Re-write Rule (Run Once)
    add_action('init', function(){
        if(!get_option('pondok_rewrite_flushed_v1')) {
            flush_rewrite_rules();
            update_option('pondok_rewrite_flushed_v1', true);
        }
    });

    // Scripts & Styles
require_once get_template_directory() . '/inc/psb-system.php'; // PSB Backend System
require_once get_template_directory() . '/inc/theme-seeder.php'; // Dummy Data Seeder




function pondok_enqueue_scripts() {
    wp_enqueue_style( 'google-fonts', 'https://fonts.googleapis.com/css2?family=Lexend:wght@100..900&display=swap', array(), null );
    wp_enqueue_style( 'material-symbols', 'https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap', array(), null );

    wp_enqueue_style( 'pondok-style', get_template_directory_uri() . '/assets/css/app.css', array(), filemtime( get_template_directory() . '/assets/css/app.css' ) );

    wp_enqueue_script( 'pondok-main-js', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', true );

    // Tailwind CSS is now built into style.css, so we don't need the CDN.
    // wp_enqueue_script( 'tailwind-cdn', 'https://cdn.tailwindcss.com?plugins=forms,container-queries', array(), null, false );
    /*
    wp_add_inline_script( 'tailwind-cdn', '
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#65A30D",
                        "secondary": "#365314",
                        "accent": "#4D7C0F",
                        "background-light": "#F9FAFB", // Soft Gray (Slate 50) - Neutral & Clean
                        "surface": "#FFFFFF",
                        "background-dark": "#1A2E05",
                    },
                    fontFamily: {
                        "display": ["Lexend", "sans-serif"]
                    },
                    borderRadius: { "DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "full": "9999px" },
                },
            },
        }
    ' );
    */
}
add_action( 'wp_enqueue_scripts', 'pondok_enqueue_scripts' );

function pondok_get_option( $key, $default = '' ) {
    return Pondok_Theme_Controller::get_option( $key, $default );
}

function pondok_primary_menu_fallback() {
    if ( current_user_can( 'manage_options' ) ) {
        echo '<a href="' . esc_url( admin_url( 'nav-menus.php' ) ) . '" class="text-red-500 font-bold hover:underline">Assign a Menu</a>';
    }
}
