<!DOCTYPE html>
<html <?php language_attributes(); ?> class="light">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <?php wp_head(); ?>
    <style>
        /* Dynamic Theme Colors */
        :root {
            <?php 
            $focus = trim(pondok_get_option('school_level_focus', '')); 
            
            // Default Colors (Wustho / Lime)
            $primary = '#65A30D';
            $secondary = '#365314';
            $accent = '#4D7C0F';

            // Ulya Override (Emerald / Dark Green)
            if ( strcasecmp($focus, 'Ulya') == 0 ) {
                $primary = '#15803D'; // Emerald 700
                $secondary = '#14532D'; // Emerald 900
                $accent = '#16A34A'; // Emerald 600
            }
            ?>
            --color-primary: <?php echo $primary; ?>;
            --color-secondary: <?php echo $secondary; ?>;
            --color-accent: <?php echo $accent; ?>;
        }

        /* Custom scrollbar for better look */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: #f1f1f1; 
        }
        ::-webkit-scrollbar-thumb {
            background: #888; 
            border-radius: 4px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #555; 
        }
    </style>
</head>
<body <?php body_class( 'bg-background-light dark:bg-background-dark font-display text-[#111318] dark:text-white overflow-x-hidden' ); ?>>

    <?php wp_body_open(); ?>
    
    <div class="relative flex min-h-screen w-full flex-col">
        <!-- Navigation -->
        <header class="sticky top-0 z-50 bg-white dark:bg-[#1a202c] border-b border-[#f0f2f4] dark:border-gray-700 px-4 lg:px-10 py-2 shadow-sm">
            <div class="layout-container mx-auto max-w-7xl flex items-center justify-between">
                <div class="flex items-center gap-4 text-[#111318] dark:text-white">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="flex items-center gap-3 text-[#111318] dark:text-white text-lg font-bold leading-tight tracking-tight">
                        <?php 
                        $site_logo = pondok_get_option('site_logo');
                        $site_name = pondok_get_option('site_name');
                        if ( empty( $site_name ) ) {
                            $site_name = get_bloginfo( 'name' );
                        }
                        
                        if ( ! empty( $site_logo ) ) : 
                        ?>
                            <img src="<?php echo esc_url( $site_logo ); ?>" alt="<?php echo esc_attr( $site_name ); ?>" class="h-10 w-auto object-contain">
                            <span><?php echo esc_html( $site_name ); ?></span>
                        <?php else : ?>
                            <div class="size-8 text-primary">
                                <span class="material-symbols-outlined" style="font-size: 32px;">school</span>
                            </div>
                            <span><?php echo esc_html( $site_name ); ?></span>
                        <?php endif; ?>
                    </a>
                </div>

                <!-- Desktop Nav -->
                <div class="hidden xl:flex flex-1 justify-end gap-8 items-center">
                    <nav class="flex items-center gap-6">
                        <?php
                        wp_nav_menu( array(
                            'theme_location' => 'primary',
                            'container'      => false,
                            'menu_class'     => 'flex items-center gap-6',
                            'items_wrap'     => '%3$s', // Removes the <ul> wrap to fit the design
                            'fallback_cb'    => 'pondok_primary_menu_fallback',
                            'walker'         => class_exists('Pondok_Nav_Walker') ? new Pondok_Nav_Walker() : null,
                        ) );
                                                ?>
                    </nav>
                    <a href="<?php echo esc_url( pondok_get_option('registration_link', '#') ); ?>" class="flex cursor-pointer items-center justify-center overflow-hidden rounded-lg h-10 px-6 bg-primary hover:bg-accent transition-colors text-white text-sm font-bold leading-normal tracking-[0.015em]">
                        <span class="truncate">Pendaftaran</span>
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <button id="mobile-menu-btn" class="xl:hidden text-[#111318] dark:text-white p-2">
                    <span class="material-symbols-outlined">menu</span>
                </button>
            </div>

            <!-- Mobile Menu Dropdown -->
            <div id="mobile-menu" class="hidden xl:hidden border-t border-gray-100 dark:border-gray-800 bg-white dark:bg-[#1a202c] absolute top-full left-0 w-full shadow-lg transition-all duration-300">
                <nav class="flex flex-col p-4 gap-4">
                    <?php
                    wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'container'      => false,
                        'items_wrap'     => '%3$s',
                        'walker'         => class_exists('Pondok_Mobile_Nav_Walker') ? new Pondok_Mobile_Nav_Walker() : null,
                        'fallback_cb'    => false,
                    ) );
                    ?>
                    <!-- Mobile Buttons -->
                    <div class="flex flex-col gap-3 mt-2 pt-4 border-t border-gray-100 dark:border-gray-700">
                        <a href="<?php echo esc_url( pondok_get_option('registration_link', '#') ); ?>" class="w-full flex items-center justify-center rounded-lg h-10 px-6 bg-primary hover:bg-accent transition-colors text-white text-sm font-bold">
                            Pendaftaran
                        </a>
                    </div>
                </nav>
            </div>
        </header>

        <!-- Main Content -->
        <main class="flex-grow">
