<?php
/**
 * Simple Brosur/Download Management Page (Repeater Style)
 */

function pondok_register_brosur_page() {
    $hook = add_submenu_page(
        'pondok-theme-settings', // Parent Slug
        'Kelola Brosur',
        'Kelola Brosur',
        'manage_options',
        'pondok-brosur',
        'pondok_brosur_page_html'
    );
    add_action( "admin_print_scripts-$hook", 'pondok_brosur_enqueue_media' );
}
add_action('admin_menu', 'pondok_register_brosur_page');

function pondok_brosur_enqueue_media() {
    wp_enqueue_media();
}

function pondok_brosur_page_html() {
    // Save Logic
    if (isset($_POST['pondok_brosur_nonce']) && wp_verify_nonce($_POST['pondok_brosur_nonce'], 'save_brosur_action')) {
        $brosur_data = isset($_POST['brosur']) ? $_POST['brosur'] : array();
        // Sanitize
        $clean_data = array();
        foreach ($brosur_data as $item) {
            if (!empty($item['judul'])) {
                $clean_data[] = array(
                    'judul' => sanitize_text_field($item['judul']),
                    'kategori' => sanitize_text_field($item['kategori']), // PSB, Akademik, Umum
                    'tanggal' => sanitize_text_field($item['tanggal']),
                    'cover' => esc_url_raw($item['cover']), // Gambar Cover
                    'file_url' => esc_url_raw($item['file_url']), // Link PDF/Download
                    'deskripsi' => sanitize_textarea_field($item['deskripsi']),
                );
            }
        }
        update_option('pondok_brosur_list', $clean_data);
        echo '<div class="notice notice-success is-dismissible"><p>Data Brosur berhasil disimpan!</p></div>';
    }

    $existing_data = get_option('pondok_brosur_list', array());
    ?>
    <div class="wrap">
        <h1 class="wp-heading-inline">Kelola Brosur & Dokumen</h1>
        <hr class="wp-header-end">
        
        <form method="post" action="">
            <?php wp_nonce_field('save_brosur_action', 'pondok_brosur_nonce'); ?>
            
            <style>
                .brosur-row { background: #fff; border: 1px solid #ccd0d4; padding: 15px; margin-bottom: 15px; box-shadow: 0 1px 1px rgba(0,0,0,.04); display: flex; gap: 15px; align-items: flex-start; }
                .brosur-row .col-img { width: 120px; text-align: center; }
                .brosur-row .img-preview { width: 100px; height: 140px; object-fit: cover; background: #f0f0f1; display: block; margin: 0 auto 10px; border-radius: 4px; border:1px solid #ddd; }
                .brosur-row .col-fields { flex: 1; display: grid; grid-template-columns: 1fr 1fr; gap: 10px; }
                .brosur-row .full-width { grid-column: span 2; }
                .brosur-row input[type="text"], .brosur-row textarea, .brosur-row select { width: 100%; }
                .brosur-row .remove-row { color: #b32d2e; align-self: center; cursor: pointer; font-size: 20px; }
            </style>

            <div id="brosur-container">
                <?php 
                if (!empty($existing_data)) {
                    foreach ($existing_data as $index => $item) {
                        pondok_render_brosur_row($index, $item);
                    }
                } else {
                    pondok_render_brosur_row(0);
                }
                ?>
            </div>

            <button type="button" class="button button-secondary" id="add-row-btn">+ Tambah Brosur</button>
            <hr>
            <button type="submit" class="button button-primary button-hero">Simpan Perubahan</button>
        </form>
    </div>

    <!-- Template for JS -->
    <script type="text/template" id="row-template">
        <?php pondok_render_brosur_row('INDEX_PLACEHOLDER'); ?>
    </script>

    <script>
    jQuery(document).ready(function($) {
        var mediaUploader;
        var currentButton;

        // Generic Upload Handler (Works for Cover Image and PDF File)
        $('#brosur-container').on('click', '.upload-btn', function(e) {
            e.preventDefault();
            currentButton = $(this);
            var isFile = currentButton.hasClass('file-btn'); // Check if it's for PDF
            
            if (mediaUploader) { mediaUploader.open(); return; }
            
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: isFile ? 'Pilih File Dokumen (PDF)' : 'Pilih Gambar Cover',
                button: { text: 'Gunakan File Ini' },
                library: { type: isFile ? 'application/pdf' : 'image' }, 
                multiple: false
            });

            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                var row = currentButton.closest('.brosur-row');
                
                if (currentButton.hasClass('cover-btn')) {
                    row.find('.cover-input').val(attachment.url);
                    row.find('.img-preview').attr('src', attachment.url);
                } else {
                    row.find('.file-input').val(attachment.url);
                }
            });

            mediaUploader.open();
        });

        $('#add-row-btn').on('click', function() {
            var template = $('#row-template').html();
            var timestamp = new Date().getTime(); 
            template = template.replace(/INDEX_PLACEHOLDER/g, timestamp);
            $('#brosur-container').append(template);
        });

        $('#brosur-container').on('click', '.remove-row', function() {
            if (confirm('Hapus dokumen ini?')) {
                $(this).closest('.brosur-row').remove();
            }
        });
    });
    </script>
    <?php
}

function pondok_render_brosur_row($index, $data = array()) {
    $judul = isset($data['judul']) ? $data['judul'] : '';
    $kategori = isset($data['kategori']) ? $data['kategori'] : '';
    $tanggal = isset($data['tanggal']) ? $data['tanggal'] : date('d M Y');
    $cover = isset($data['cover']) ? $data['cover'] : '';
    $file_url = isset($data['file_url']) ? $data['file_url'] : '';
    $deskripsi = isset($data['deskripsi']) ? $data['deskripsi'] : '';
    
    $kategori_opts = array('PSB', 'Akademik', 'Laporan', 'Kegiatan', 'Umum');
    ?>
    <div class="brosur-row">
        <div class="col-img">
            <label style="font-weight:bold; display:block; margin-bottom:5px;">Cover</label>
            <img src="<?php echo $cover ? $cover : 'https://via.placeholder.com/100x140?text=Cover'; ?>" class="img-preview">
            <input type="hidden" name="brosur[<?php echo $index; ?>][cover]" class="cover-input" value="<?php echo $cover; ?>">
            <button class="button upload-btn cover-btn">Upload Cover</button>
        </div>
        <div class="col-fields">
            <div>
                <label>Judul Dokumen</label>
                <input type="text" name="brosur[<?php echo $index; ?>][judul]" value="<?php echo esc_attr($judul); ?>" placeholder="Contoh: Brosur PSB 2024">
            </div>
            <div>
                <label>Kategori</label>
                <select name="brosur[<?php echo $index; ?>][kategori]">
                    <?php foreach($kategori_opts as $opt): ?>
                        <option value="<?php echo $opt; ?>" <?php selected($kategori, $opt); ?>><?php echo $opt; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label>Tanggal Rilis</label>
                <input type="text" name="brosur[<?php echo $index; ?>][tanggal]" value="<?php echo esc_attr($tanggal); ?>" placeholder="12 Jan 2024">
            </div>
            <div>
                <label>File Dokumen (PDF/Doc)</label>
                <div style="display:flex; gap:5px;">
                    <input type="text" name="brosur[<?php echo $index; ?>][file_url]" class="file-input" value="<?php echo esc_attr($file_url); ?>" placeholder="URL File Download...">
                    <button class="button upload-btn file-btn">Pilih File</button>
                </div>
            </div>
            <div class="full-width">
                <label>Deskripsi Singkat</label>
                <textarea name="brosur[<?php echo $index; ?>][deskripsi]" rows="2"><?php echo esc_textarea($deskripsi); ?></textarea>
            </div>
        </div>
        <span class="dashicons dashicons-trash remove-row" title="Hapus"></span>
    </div>
    <?php
}
