<?php
/**
 * Custom Nav Walkers
 * 
 * Handles custom navigation structures for Desktop (Dropdown) and Mobile (Stacked).
 * 
 * @package Pondok_Dengan
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Desktop Nav Walker
 * Supports Dropdowns via CSS Group Hover
 */
class Pondok_Nav_Walker extends Walker_Nav_Menu {
    
    function start_lvl( &$output, $depth = 0, $args = null ) {
        // Dropdown Container
        $classes = 'absolute top-full left-0 w-56 bg-white dark:bg-[#1a202c] border border-gray-100 dark:border-gray-700 shadow-xl rounded-lg py-2 mt-2 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 z-50';
        $output .= "<div class='{$classes}'>";
    }

    function end_lvl( &$output, $depth = 0, $args = null ) {
        $output .= "</div>";
    }

    function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $has_children = in_array('menu-item-has-children', $classes);
        
        // --- 1. Top Level Item ---
        if ( $depth === 0 ) {
            // Container for relative positioning (needed for dropdown)
            $output .= "<div class='relative group h-full flex items-center'>";
            
            // Link Classes
            $link_classes = 'text-[#111318] dark:text-gray-200 text-sm font-medium leading-normal hover:text-primary transition-colors flex items-center gap-1 py-4'; // Added py-4 to increase hover area
            if ( in_array('current-menu-item', $classes) ) {
                $link_classes .= ' text-primary font-bold';
            }

            $output .= '<a href="' . esc_attr($item->url) . '" class="' . $link_classes . '">';
            $output .= $item->title;
            
            
            if ( $has_children ) {
                $output .= '<span class="material-symbols-outlined text-lg group-hover:rotate-180 transition-transform duration-200">keyboard_arrow_down</span>';
            }
            $output .= '</a>';
        } 
        
        // --- 2. Sub Menu Item ---
        else {
            $output .= "<div class='relative block'>"; 
            $link_classes = 'block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 hover:text-primary transition-colors';
            
            $output .= '<a href="' . esc_attr($item->url) . '" class="' . $link_classes . '">';
            $output .= $item->title;
            $output .= '</a>';
        }
    }

    function end_el( &$output, $item, $depth = 0, $args = null ) {
        $output .= "</div>"; 
    }
}


/**
 * Mobile Nav Walker
 * Simple Stacked/Indented list for Mobile
 */
class Pondok_Mobile_Nav_Walker extends Walker_Nav_Menu {
    
    function start_lvl( &$output, $depth = 0, $args = null ) {
        $output .= "<div class='pl-4 border-l border-gray-100 dark:border-gray-700 mt-2 flex flex-col gap-2'>";
    }

    function end_lvl( &$output, $depth = 0, $args = null ) {
        $output .= "</div>";
    }

    function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        
        $link_classes = 'block text-base font-medium text-[#111318] dark:text-gray-200 hover:text-primary transition-colors py-1';
        
        $output .= '<a href="' . esc_attr($item->url) . '" class="' . $link_classes . '">';
        $output .= $item->title;
        $output .= '</a>';
    }

    function end_el( &$output, $item, $depth = 0, $args = null ) {
        
    }
}
