<?php
/**
 * Theme Options / Controller
 * 
 * Handles theme setup and option retrieval using the WordPress Settings API.
 * 
 * @package Pondok_Dengan
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

class Pondok_Theme_Controller {

    private static $instance = null;
    private $option_group = 'pondok_theme_options';
    private $page_slug = 'pondok-theme-settings';

    // Define all your settings here for easy management
    private $settings = array();

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        // Initialize Settings Fields
        $this->init_settings();

        // Hooks
        add_action( 'after_setup_theme', array( $this, 'theme_setup' ) );
        add_action( 'admin_menu', array( $this, 'register_settings_page' ) );
        add_action( 'admin_init', array( $this, 'register_settings' ) );
    }

    /**
     * Define the fields configuration
     * Add new fields here to auto-generate them in the admin panel.
     */
    private function init_settings() {
        $this->settings = array(
            // Section: General / Contact
            'general' => array(
                'title' => 'General & Contact',
                'fields' => array(
                    array( 'id' => 'site_logo', 'label' => 'Site Logo', 'type' => 'image', 'default' => '' ), 
                    array( 'id' => 'registration_link', 'label' => 'Link Pendaftaran (PPDB)', 'type' => 'text', 'default' => '#' ), 
                    array( 
                        'id' => 'school_level_focus', 
                        'label' => 'Fokus Tingkatan Web Ini', 
                        'type' => 'select', 
                        'options' => array(
                            '' => 'Tampilkan Semua (Default)', 
                            'Wustho' => 'Khusus Wustho (Menengah)', 
                            'Ulya' => 'Khusus Ulya (Atas)'
                        ),
                        'default' => '' 
                    ),
                    array( 'id' => 'phone_number', 'label' => 'Phone Number', 'type' => 'text', 'default' => '+62 123 4567 890' ),
                    array( 'id' => 'email_address', 'label' => 'Email Address', 'type' => 'email', 'default' => 'info@pondokdengan.ac.id' ),
                    array( 'id' => 'office_address', 'label' => 'Office Address', 'type' => 'textarea', 'default' => "Jl. KH. Hasyim Asy'ari No 9 R,\nPoncokusumo, Kab. Malang, Jawa Timur" ),
                )
            ),
             // Section: Kurikulum & Ekstra
            'kurikulum' => array(
                'title' => 'Kurikulum & Ekstra',
                'fields' => array(
                    array(
                        'id' => 'kurikulum_daily_routine',
                        'label' => 'Rutinitas Harian',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'time', 'label' => 'Waktu', 'type' => 'text', 'placeholder' => '03:30 - 04:30'),
                            array('name' => 'activity', 'label' => 'Kegiatan', 'type' => 'text', 'placeholder' => 'Qiyamul Lail'),
                            array('name' => 'icon', 'label' => 'Foto Kegiatan', 'type' => 'image', 'placeholder' => 'Upload Foto')
                        )
                    ),
                    array(
                        'id' => 'kurikulum_ekstra',
                        'label' => 'Ekstrakurikuler',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'name', 'label' => 'Nama Ekstra', 'type' => 'text', 'placeholder' => 'Pramuka'),
                            array('name' => 'icon', 'label' => 'Icon (Material)', 'type' => 'text', 'placeholder' => 'hiking')
                        )
                    )
                )
            ),
            // Section: Hero
            'hero' => array(
                'title' => 'Home: Hero Section',
                'fields' => array(
                    array( 'id' => 'hero_title', 'label' => 'Hero Title', 'type' => 'text', 'default' => 'Building Future Leaders with Knowledge and Ethics' ),
                    array( 'id' => 'hero_desc', 'label' => 'Hero Description', 'type' => 'textarea', 'default' => 'Join a community dedicated to academic excellence, spiritual growth, and the harmonious integration of traditional wisdom.' ),
                    array( 'id' => 'hero_image', 'label' => 'Hero Image URL', 'type' => 'image', 'default' => 'https://lh3.googleusercontent.com/aida-public/AB6AXuB9Wr9MaJLs7Di-KjvTU2Nh8lmtU_vCLbSmK_roqjVjBy4LmvAmKMTRtBu7VtqVq0tlz9UrACTbSYYxubCwJuAuhj_p8JscCHouN0-hH_OxZD3lQDjErhkvU2ECgo4pTjo5YZ3mhg41fjZZClEkvru72vBT-jlKhgyoXvl9Tu3JftKvP_L9pziKow_qiTz7dpdSeN0aidKRQoNmsaZ60nW449b9kKx45O7Td-k8hQc1gZ6GoQxUEVclefGTfi20t-Wh0YhN1eb6e7X-' ),
                )
            ),
            // Section: Features
            'features' => array(
                'title' => 'Home: Features',
                'fields' => array(
                    array( 'id' => 'feature_1_title', 'label' => 'Feature 1 Title', 'type' => 'text', 'default' => 'Experienced Asatidz' ),
                    array( 'id' => 'feature_1_desc', 'label' => 'Feature 1 Desc', 'type' => 'textarea', 'default' => 'Learn from qualified scholars with years of experience.' ),
                    array( 'id' => 'feature_2_title', 'label' => 'Feature 2 Title', 'type' => 'text', 'default' => 'Modern Curriculum' ),
                    array( 'id' => 'feature_2_desc', 'label' => 'Feature 2 Desc', 'type' => 'textarea', 'default' => 'Integrated learning approach combining national standards.' ),
                    array( 'id' => 'feature_3_title', 'label' => 'Feature 3 Title', 'type' => 'text', 'default' => 'Islamic Values' ),
                    array( 'id' => 'feature_3_desc', 'label' => 'Feature 3 Desc', 'type' => 'textarea', 'default' => 'Building a strong moral foundation based on Quran and Sunnah.' ),
                )
            ),
            // Section: Footer
            'footer' => array(
                'title' => 'Footer & Layout',
                'fields' => array(
                    array( 'id' => 'footer_desc', 'label' => 'Footer Description', 'type' => 'textarea', 'default' => 'Educating the mind, purifying the heart, and serving the community since 1990.' ),
                    array( 'id' => 'footer_copyright', 'label' => 'Copyright Text', 'type' => 'text', 'default' => '© 2024 Yayasan Ma\'had Nurul Hikmah Assalafiyah. All rights reserved.' ),
                    
                    // Contact Info
                    array( 'id' => 'office_address', 'label' => 'Alamat Kantor', 'type' => 'textarea', 'default' => 'Jl. Pesantren No. 123, Kota Santri' ),
                    array( 'id' => 'phone_number', 'label' => 'Nomor Telepon', 'type' => 'text', 'default' => '+62 812-3456-7890' ),
                    array( 'id' => 'email_address', 'label' => 'Alamat Email', 'type' => 'text', 'default' => 'info@ponpes.com' ),

                    array( 'id' => 'social_facebook', 'label' => 'Facebook URL', 'type' => 'text', 'default' => '#' ),
                    array( 'id' => 'social_instagram', 'label' => 'Instagram URL', 'type' => 'text', 'default' => '#' ),
                    array( 'id' => 'social_youtube', 'label' => 'YouTube URL', 'type' => 'text', 'default' => '#' ),
                )
            ),
            // Section: Kurikulum Page Specifics
            'kurikulum_page' => array(
                'title' => 'Page: Kurikulum',
                'fields' => array(
                    // Hero
                    array( 'id' => 'kurikulum_hero_title_default', 'label' => 'Hero Title (Default)', 'type' => 'text', 'default' => 'Terpadu & Holistik', 'description' => 'Ditampilkan jika tidak ada filter Tingkat (Wustha/Ulya)' ),
                    array( 'id' => 'kurikulum_hero_desc_text', 'label' => 'Hero Subtitle', 'type' => 'textarea', 'default' => '', 'description' => 'Leave empty to use Page Excerpt or default text.' ),
                    array( 'id' => 'kurikulum_hero_btn1_text', 'label' => 'Button 1 Text', 'type' => 'text', 'default' => 'Unduh Brosur Kurikulum' ),
                    array( 'id' => 'kurikulum_hero_btn1_link', 'label' => 'Button 1 Link', 'type' => 'text', 'default' => '#' ),
                    array( 'id' => 'kurikulum_hero_btn2_text', 'label' => 'Button 2 Text', 'type' => 'text', 'default' => 'Lihat Kalender Akademik' ),
                    array( 'id' => 'kurikulum_hero_btn2_link', 'label' => 'Button 2 Link', 'type' => 'text', 'default' => '#' ),
                    array( 'id' => 'silabus_pdf_url', 'label' => 'File Katalog Silabus (PDF)', 'type' => 'file', 'description' => 'Upload file PDF lengkap Kurikulum/Silabus.' ),

                    // Section: Competencies
                    array( 'id' => 'kurikulum_competencies_title', 'label' => 'Judul Kompetensi', 'type' => 'text', 'default' => 'Kompetensi Utama Lulusan' ),
                    array( 'id' => 'kurikulum_competencies_subtitle', 'label' => 'Sub-Judul Kompetensi', 'type' => 'textarea', 'default' => 'Kurikulum kami dirancang untuk memastikan setiap santri mencapai standar kompetensi yang seimbang antara aspek spiritual, intelektual, dan emosional.' ),

                    // Competencies Repeater
                    array(
                        'id' => 'kurikulum_competencies',
                        'label' => 'Kompetensi Utama (Cards)',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'title', 'label' => 'Judul', 'type' => 'text', 'placeholder' => 'Tahfidz & Ulumul Syar\'i'),
                            array('name' => 'desc', 'label' => 'Deskripsi', 'type' => 'textarea', 'placeholder' => 'Deskripsi singkat...'),
                            array('name' => 'icon', 'label' => 'Icon (Material)', 'type' => 'text', 'placeholder' => 'auto_stories')
                        )
                    ),

                    // Quote
                    array( 'id' => 'kurikulum_quote_text', 'label' => 'Quote Text', 'type' => 'textarea', 'default' => '"Waktu bagaikan pedang, jika kau tidak memotongnya, ia akan memotongmu."' ),
                    array( 'id' => 'kurikulum_quote_author', 'label' => 'Quote Author', 'type' => 'text', 'default' => 'Imam Syafi\'i' ),
                    array( 'id' => 'kurikulum_quote_bg', 'label' => 'Quote Background Image', 'type' => 'image', 'default' => '' ),

                    // Levels (Jenjang)
                    array(
                        'id' => 'kurikulum_levels',
                        'label' => 'Jenjang Pendidikan (Levels)',
                        'type' => 'repeater',
                        'description' => 'Tambahkan jenjang pendidikan yang tersedia. Gunakan Tag "Wustha" atau "Ulya" agar sesuai dengan filter Fokus Tingkatan.',
                        'fields' => array(
                            array('name' => 'tag', 'label' => 'Tag Filter (Wustha/Ulya)', 'type' => 'text', 'placeholder' => 'Wustha'),
                            array('name' => 'label', 'label' => 'Label Badge', 'type' => 'text', 'placeholder' => 'Tingkat Dasar'),
                            array('name' => 'title', 'label' => 'Judul Jenjang', 'type' => 'text', 'placeholder' => 'Marhalah Ula'),
                            array('name' => 'image', 'label' => 'Gambar/Foto', 'type' => 'image', 'placeholder' => ''),
                            array('name' => 'desc', 'label' => 'Deskripsi', 'type' => 'textarea', 'placeholder' => 'Deskripsi singkat...'),
                            array('name' => 'points', 'label' => 'Poin Unggulan (1 per baris)', 'type' => 'textarea', 'placeholder' => '- Hafalan Juz 30')
                        )
                    ),

                    // Section: Rutinitas
                     array( 'id' => 'kurikulum_routine_title', 'label' => 'Judul Rutinitas', 'type' => 'text', 'default' => 'Rutinitas Harian' ),
                     array( 'id' => 'kurikulum_routine_subtitle', 'label' => 'Sub-Judul Rutinitas', 'type' => 'textarea', 'default' => 'Disiplin adalah kunci keberhasilan. Para santri dididik untuk menghargai waktu melalui jadwal harian yang teratur.' ),

                    // Section: Ekstra
                     array( 'id' => 'kurikulum_ekstra_title', 'label' => 'Judul Ekstrakurikuler', 'type' => 'text', 'default' => 'Ekstrakurikuler Penunjang' ),
                     array( 'id' => 'kurikulum_ekstra_subtitle', 'label' => 'Sub-Judul Ekstrakurikuler', 'type' => 'textarea', 'default' => 'Menyalurkan bakat dan minat santri di luar jam akademik.' ),
                )
            ),
            // Section: Page About Us
            'about_page' => array(
                'title' => 'Page: Tentang Kami',
                'fields' => array(
                    // Hero
                    array( 'id' => 'about_hero_image', 'label' => 'Hero Background Image', 'type' => 'image', 'default' => 'https://lh3.googleusercontent.com/aida-public/AB6AXuD-mlbR9tANGS0wWOj0QJwcrlV8rUlxA87i402I1JmW_fJg6_VvtBN83LrtU1VH4X4QkNpaVX2YZcNMsVsBCGNmHpduGby74frAz6bnMkmKEzapnB6W5d-nmbxCwW0GywBDaLJgZcnLqPaxUrs7I7rhgL8OHarYywcXW9HuMMV-ImcJ_Eh1kWi99Y4B9lZ6bzf7P4rL8Kaz6qh72kLvmdr8Q47Yz27ygHQ2iZbH0X0R9GKATTZ3VBjdG0f6XeoKXj7mE7mwMUNEnpyJ' ),
                    array( 'id' => 'about_hero_subtitle', 'label' => 'Hero Subtitle', 'type' => 'textarea', 'default' => 'Mengenal lebih dekat Pondok Dengan, tempat di mana tradisi keilmuan Islam bertemu dengan inovasi pendidikan modern.' ),

                    // History Section
                    array( 'id' => 'about_history_title', 'label' => 'Judul Sejarah', 'type' => 'text', 'default' => 'Perjalanan Dua Dekade Mengabdi' ),
                    array( 'id' => 'about_history_subtitle', 'label' => 'Sub-Judul Sejarah', 'type' => 'text', 'default' => 'Sejarah Kami' ),
                    array( 'id' => 'about_history_image', 'label' => 'Gambar Sejarah', 'type' => 'image', 'default' => 'https://lh3.googleusercontent.com/aida-public/AB6AXuBzTKM1zO_CpzTSjW2CiwguGhs3bjOR0FwoHTncknRhrdrmmtLj0bHI-p30VJdZL9OJ8pU8N6PGghIKHfslTAvGnOnU8tDCghcRsRiASo2LU6TspV9e_zhOQKNhhhe05yet8qNWLzDB0rEzE92HoCdd2p22CQCnV9CsAwzPPtZubn4wxhsPzfZyXNELjuVVK2mfT2rYc0oIG8_r4BIAb0o157jH1cKf2LkKV2q6pcLE-684Dw4FP2pn6MyQsnICFlun3U0212F11DPN' ),
                    array( 'id' => 'about_history_desc', 'label' => 'Deskripsi Sejarah', 'type' => 'textarea', 'default' => "Didirikan pada tahun 2003, Pondok Dengan bermula dari sebuah majelis kecil dengan semangat besar untuk mencerdaskan kehidupan bangsa.\n\nKini, kami telah berkembang menjadi institusi pendidikan terpadu yang memadukan kurikulum nasional dan kepesantrenan." ),

                    // Stats
                    array(
                        'id' => 'about_stats',
                        'label' => 'Statistik (Stats)',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'number', 'label' => 'Angka (Misal: 20+)', 'type' => 'text', 'placeholder' => '20+'),
                            array('name' => 'label', 'label' => 'Label (Misal: Tahun Pengabdian)', 'type' => 'text', 'placeholder' => 'Tahun Pengabdian'),
                        )
                    ),

                    // Vision & Mission
                    array( 'id' => 'about_vision_text', 'label' => 'Teks Visi', 'type' => 'textarea', 'default' => 'Menjadi pusat keunggulan pendidikan Islam yang melahirkan pemimpin berkarakter Qurani, berwawasan global, dan mampu menjawab tantangan zaman.' ),
                     array(
                        'id' => 'about_mission_points',
                        'label' => 'Poin Misi',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'text', 'label' => 'Teks Misi', 'type' => 'text', 'placeholder' => 'Menyelenggarakan pendidikan berkualitas...'),
                        )
                    ),

                    // Leadership
                    array(
                        'id' => 'about_leadership',
                        'label' => 'Pimpinan Pondok (Tim)',
                        'type' => 'repeater',
                        'fields' => array(
                            array('name' => 'name', 'label' => 'Nama', 'type' => 'text', 'placeholder' => 'KH. Ahmad Dahlan'),
                            array('name' => 'position', 'label' => 'Jabatan', 'type' => 'text', 'placeholder' => 'Pimpinan Pondok'),
                            array('name' => 'photo', 'label' => 'Foto', 'type' => 'image', 'placeholder' => ''),
                        )
                    ),
                )
            ),
        );
    }

    /**
     * Helper to get option value
     */
    public static function get_option( $key, $default = '' ) {
        // Fallback to internal checking if default isn't passed, 
        // effectively making the array definition the source of truth for defaults.
        if ( empty( $default ) ) {
            $instance = self::get_instance();
            foreach ( $instance->settings as $section ) {
                foreach ( $section['fields'] as $field ) {
                    if ( $field['id'] === $key && isset( $field['default'] ) ) {
                        $default = $field['default'];
                        break 2;
                    }
                }
            }
        }
        return get_option( $key, $default );
    }

    public function theme_setup() {
        add_theme_support( 'title-tag' );
        add_theme_support( 'post-thumbnails' );
        add_theme_support( 'custom-logo' );
        register_nav_menus( array(
            'primary' => __( 'Primary Menu', 'pondok-dengan' ),
            'footer'  => __( 'Footer Menu (Column 1)', 'pondok-dengan' ),
            'footer-academic' => __( 'Footer Menu (Column 2)', 'pondok-dengan' ),
        ) );
    }

    public function register_settings_page() {
        add_menu_page(
            __( 'Theme Settings', 'pondok-dengan' ),
            __( 'Theme Settings', 'pondok-dengan' ),
            'manage_options',
            $this->page_slug,
            array( $this, 'render_settings_page' ),
            'dashicons-layout',
            2
        );
    }

    public function register_settings() {
        foreach ( $this->settings as $section_key => $section ) {
            foreach ( $section['fields'] as $field ) {
                // Use section-specific option group to isolate tabs
                register_setting( $this->option_group . '_' . $section_key, $field['id'] );
            }
        }
    }

    public function render_settings_page() {
        // Check user capabilities
        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        // Enqueue Media Uploader
        wp_enqueue_media();

        // Tabs Logic
        $active_tab = isset( $_GET['tab'] ) ? $_GET['tab'] : array_key_first( $this->settings );
        ?>
        <div class="wrap">
            <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
            
            <h2 class="nav-tab-wrapper">
                <?php foreach ( $this->settings as $key => $section ) : ?>
                    <a href="?page=<?php echo $this->page_slug; ?>&tab=<?php echo $key; ?>" class="nav-tab <?php echo $active_tab === $key ? 'nav-tab-active' : ''; ?>">
                        <?php echo esc_html( $section['title'] ); ?>
                    </a>
                <?php endforeach; ?>
            </h2>

            <form action="options.php" method="post">
                <?php
                settings_fields( $this->option_group . '_' . $active_tab );
                
                // Retrieve fields for active tab
                $fields = $this->settings[$active_tab]['fields'];
                ?>
                <table class="form-table" role="presentation">
                    <tbody>
                        <?php foreach ( $fields as $field ) : 
                            $default_val = isset($field['default']) ? $field['default'] : '';
                            $value = get_option( $field['id'], $default_val );
                        ?>
                            <tr>
                                <th scope="row">
                                    <label for="<?php echo esc_attr( $field['id'] ); ?>"><?php echo esc_html( $field['label'] ); ?></label>
                                </th>
                                <td>
                                    <?php if ( $field['type'] === 'textarea' ) : ?>
                                        <textarea name="<?php echo esc_attr( $field['id'] ); ?>" id="<?php echo esc_attr( $field['id'] ); ?>" rows="5" cols="50" class="large-text"><?php echo esc_textarea( $value ); ?></textarea>
                                    <?php elseif ( $field['type'] === 'image' ) : ?>
                                        <div class="pondok-image-uploader">
                                            <input name="<?php echo esc_attr( $field['id'] ); ?>" type="text" id="<?php echo esc_attr( $field['id'] ); ?>" value="<?php echo esc_attr( $value ); ?>" class="regular-text image-url" />
                                            <button type="button" class="button upload_image_button">Upload Image</button>
                                            <br>
                                            <div class="image-preview-wrapper" style="margin-top: 10px; max-width: 300px;">
                                                <?php if ( ! empty( $value ) ) : ?>
                                                    <img src="<?php echo esc_url( $value ); ?>" style="max-width: 100%; height: auto;" class="image-preview" />
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php elseif ( $field['type'] === 'file' ) : ?>
                                        <div class="pondok-file-uploader">
                                            <input name="<?php echo esc_attr( $field['id'] ); ?>" type="text" id="<?php echo esc_attr( $field['id'] ); ?>" value="<?php echo esc_attr( $value ); ?>" class="regular-text file-url" />
                                            <button type="button" class="button upload_file_button">Upload File</button>
                                            <br>
                                            <p class="description" style="margin-top:5px; font-style:italic;"><?php echo isset($field['description']) ? $field['description'] : ''; ?></p>
                                        </div>
                                    <?php elseif ( $field['type'] === 'select' ) : ?>
                                        <select name="<?php echo esc_attr( $field['id'] ); ?>" id="<?php echo esc_attr( $field['id'] ); ?>">
                                            <?php foreach ( $field['options'] as $opt_val => $opt_label ) : ?>
                                                <option value="<?php echo esc_attr( $opt_val ); ?>" <?php selected( $value, $opt_val ); ?>><?php echo esc_html( $opt_label ); ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php elseif ( $field['type'] === 'repeater' ) : 
                                        $values = get_option( $field['id'], array() ); 
                                        if(!is_array($values)) $values = array();
                                        $sub_fields = $field['fields'];
                                    ?>
                                        <div class="pondok-repeater-wrapper" data-id="<?php echo esc_attr( $field['id'] ); ?>">
                                            <table class="widefat striped repeater-table" style="border:1px solid #ddd;">
                                                <thead>
                                                    <tr>
                                                        <?php foreach($sub_fields as $sub) echo '<th style="padding:10px;">' . esc_html($sub['label']) . '</th>'; ?>
                                                        <th style="width: 20px;"></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="repeater-rows">
                                                    <?php 
                                                    if(!empty($values)) {
                                                        foreach($values as $idx => $row) {
                                                            echo '<tr>';
                                                            foreach($sub_fields as $sub) {
                                                                $sub_val = isset($row[$sub['name']]) ? $row[$sub['name']] : '';
                                                                $input_name = $field['id'] . '['.$idx.'][' . $sub['name'] . ']';
                                                                echo '<td style="padding:10px;">';
                                                                if ( isset($sub['type']) && $sub['type'] === 'image' ) {
                                                                    echo '<div class="pondok-image-uploader">';
                                                                    echo '<input type="text" name="' . esc_attr($input_name) . '" value="' . esc_attr($sub_val) . '" class="regular-text image-url" style="width: 150px; margin-right: 5px;" />';
                                                                    echo '<button type="button" class="button upload_image_button">Upload</button>';
                                                                    echo '<div class="image-preview-wrapper" style="margin-top: 5px; max-width: 100px;">';
                                                                        if ( ! empty( $sub_val ) ) {
                                                                            echo '<img src="' . esc_url( $sub_val ) . '" style="max-width: 100px; height: auto;" class="image-preview" />';
                                                                        }
                                                                    echo '</div>';
                                                                    echo '</div>';
                                                                    echo '</div>';
                                                                } elseif ( isset($sub['type']) && $sub['type'] === 'textarea' ) {
                                                                    echo '<textarea name="' . esc_attr($input_name) . '" rows="3" class="widefat">' . esc_textarea($sub_val) . '</textarea>';
                                                                } else {
                                                                    echo '<input type="text" name="' . esc_attr($input_name) . '" value="' . esc_attr($sub_val) . '" class="widefat" />';
                                                                }
                                                                echo '</td>';
                                                            }
                                                            echo '<td style="padding:10px;"><span class="dashicons dashicons-trash remove-repeater-row" style="cursor:pointer; color:red;"></span></td>';
                                                            echo '</tr>';
                                                        }
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                            <button type="button" class="button add-repeater-row" style="margin-top: 10px;">+ Tambah Baris</button>

                                            <!-- Template for JS -->
                                            <script type="text/template" class="repeater-row-template">
                                                <tr>
                                                    <?php foreach($sub_fields as $sub): 
                                                        $input_name_tpl = $field['id'] . '[INDEX_PLACEHOLDER][' . $sub['name'] . ']';
                                                    ?>
                                                        <td style="padding:10px;">
                                                            <?php if ( isset($sub['type']) && $sub['type'] === 'image' ): ?>
                                                                <div class="pondok-image-uploader">
                                                                    <input type="text" name="<?php echo $input_name_tpl; ?>" class="regular-text image-url" style="width: 150px; margin-right: 5px;" />
                                                                    <button type="button" class="button upload_image_button">Upload</button>
                                                                    <div class="image-preview-wrapper" style="margin-top: 5px; max-width: 100px;"></div>
                                                                </div>
                                                            <?php elseif ( isset($sub['type']) && $sub['type'] === 'textarea' ): ?>
                                                                <textarea name="<?php echo $input_name_tpl; ?>" rows="3" class="widefat"></textarea>
                                                            <?php else: ?>
                                                                <input type="text" name="<?php echo $input_name_tpl; ?>" class="widefat" />
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endforeach; ?>
                                                    <td style="padding:10px;"><span class="dashicons dashicons-trash remove-repeater-row" style="cursor:pointer; color:red;"></span></td>
                                                </tr>
                                            </script>
                                        </div>
                                    <?php else : ?>
                                        <input name="<?php echo esc_attr( $field['id'] ); ?>" type="<?php echo esc_attr( $field['type'] ); ?>" id="<?php echo esc_attr( $field['id'] ); ?>" value="<?php echo esc_attr( $value ); ?>" class="regular-text" />
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <?php submit_button(); ?>
            </form>
            
            <!-- Inline Script for Media Uploader & Repeater -->
            <script>
            jQuery(document).ready(function($){
                // Image Uploader (Delegated)
                $(document).on('click', '.upload_image_button', function(e) {
                    e.preventDefault();
                    var button = $(this);
                    
                    var custom_uploader = wp.media({
                        title: 'Select Image',
                        button: {
                            text: 'Use this image'
                        },
                        multiple: false
                    }).on('select', function() {
                        var attachment = custom_uploader.state().get('selection').first().toJSON();
                        button.prev('.image-url').val(attachment.url);
                        var preview = button.siblings('.image-preview-wrapper');
                        preview.html('<img src="' + attachment.url + '" style="max-width:100%; height:auto;" />');
                    });
                    
                    custom_uploader.open();
                });

                // File Uploader
                $(document).on('click', '.upload_file_button', function(e) {
                    e.preventDefault();
                    var button = $(this);
                    
                    var custom_uploader = wp.media({
                        title: 'Select File',
                        button: { text: 'Use this file' },
                        multiple: false
                    }).on('select', function() {
                        var attachment = custom_uploader.state().get('selection').first().toJSON();
                        button.prev('.file-url').val(attachment.url);
                    });
                    
                    custom_uploader.open();
                });

                // Repeater Logic
                $('.add-repeater-row').on('click', function() {
                    var wrapper = $(this).closest('.pondok-repeater-wrapper');
                    var template = wrapper.find('.repeater-row-template').html();
                    var timestamp = new Date().getTime(); 
                    // Replace Placeholder with unique Index
                    template = template.replace(/INDEX_PLACEHOLDER/g, timestamp);
                    wrapper.find('.repeater-rows').append(template);
                });

                $(document).on('click', '.remove-repeater-row', function() {
                    if(confirm('Hapus baris ini?')) {
                        $(this).closest('tr').remove();
                    }
                });
            });
            </script>
    <?php
    }
}

// Initialize
Pondok_Theme_Controller::get_instance();


