<?php
/**
 * Theme Seeder
 * Populates default theme options for demonstration purposes.
 */

function pondok_run_seeder() {
    // Check if already seeded, unless forced via URL
    if ( get_option( 'pondok_theme_seeded_v5' ) && !isset($_GET['force_seed']) ) {
        return;
    }

    // 1. General
    update_option( 'registration_link', home_url('/pendaftaran') );
    update_option( 'phone_number', '+62 812-3456-7890' );
    update_option( 'email_address', 'info@nurulhuda.ponpes.id' );
    update_option( 'office_address', "Jl. Pesantren No. 99, Desa Berkah\nKec. Santri, Kab. Ikhlas\nJawa Timur 65123" );
    // update_option( 'school_level_focus', '' ); // All - Commented out to prevent resetting user choice

    // 2. Hero Section
    update_option( 'hero_title', 'Mencetak Generasi Santri Berakhlak & Berprestasi' );
    update_option( 'hero_desc', 'Pondok Pesantren Nurul Huda berkomitmen memadukan kurikulum pendidikan nasional dengan nilai-nilai salafiyah untuk melahirkan pemimpin masa depan yang unggul dalam IMTAQ dan IPTEK.' );

    // 3. Features
    update_option( 'feature_1_title', 'Pendidikan Terintegrasi' );
    update_option( 'feature_1_desc', 'Perpaduan kurikulum Kemdikbud/Kemenag dengan kurikulum pesantren salaf (Kitab Kuning).' );
    
    update_option( 'feature_2_title', 'Asatidz Kompeten' );
    update_option( 'feature_2_desc', 'Dibimbing oleh para ustadz/ustadzah alumni pesantren ternama dan lulusan perguruan tinggi.' );
    
    update_option( 'feature_3_title', 'Lingkungan Kondusif' );
    update_option( 'feature_3_desc', 'Suasana asri, aman, dan islami yang mendukung fokus santri dalam tholabul ilmi dan pembentukan karakter.' );

    // 4. Kurikulum - Daily Routine (Repeater)
    $routine = array(
        array('time' => '03:30 - 04:30', 'activity' => 'Qiyamul Lail & Subuh Berjamaah', 'icon' => 'bedtime'),
        array('time' => '05:00 - 06:30', 'activity' => 'Ngaji Bandongan (Kitab Kuning)', 'icon' => 'menu_book'),
        array('time' => '07:00 - 13:00', 'activity' => 'KBM Sekolah Formal', 'icon' => 'school'),
        array('time' => '16:00 - 17:00', 'activity' => 'Madrasah Diniyah', 'icon' => 'auto_stories'),
        array('time' => '18:00 - 20:00', 'activity' => 'Jamaah Maghrib, Quran, Isya', 'icon' => 'mosque'),
        array('time' => '21:00 - 22:00', 'activity' => 'Belajar Mandiri / Musyawarah', 'icon' => 'groups'),
    );
    update_option( 'kurikulum_daily_routine', $routine );

    // 5. Kurikulum - Ekstra
    $ekstra = array(
        array('name' => 'Pramuka', 'icon' => 'hiking'),
        array('name' => 'Seni Hadrah', 'icon' => 'music_note'),
        array('name' => 'Muhadhoroh (Pidato)', 'icon' => 'record_voice_over'),
        array('name' => 'Pencak Silat', 'icon' => 'sports_martial_arts'),
        array('name' => 'Kaligrafi', 'icon' => 'brush'),
        array('name' => 'Komputer & Desain', 'icon' => 'computer'),
    );
    update_option( 'kurikulum_ekstra', $ekstra );

    // 6. Footer
    update_option( 'footer_desc', 'Lembaga pendidikan Islam yang mengutamakan adab, ilmu, dan amal. Berdiri sejak tahun 1990 untuk kejayaan umat.' );
    update_option( 'footer_copyright', '© 2025 PP Nurul Huda. All rights reserved.' );
    update_option( 'social_facebook', 'https://facebook.com/' );
    update_option( 'social_instagram', 'https://instagram.com/' );
    update_option( 'social_youtube', 'https://youtube.com/' );

    // 7. Silabus (Mata Pelajaran)
    $silabus = array(
        // ULYA (SMA/MA)
        array('judul' => 'Tafsir Jalalain', 'kode' => 'ULYA-01', 'level' => 'Ulya', 'kategori' => 'Fiqh', 'deskripsi' => 'Kajian tafsir Al-Qur\'an metode tahlili.'),
        array('judul' => 'Hadits Riwayah', 'kode' => 'ULYA-02', 'level' => 'Ulya', 'kategori' => 'Fiqh', 'deskripsi' => 'Studi kritis sanad dan matan hadits.'),
        array('judul' => 'Ushul Fiqh (Al-Waraqat)', 'kode' => 'ULYA-03', 'level' => 'Ulya', 'kategori' => 'Fiqh', 'deskripsi' => 'Dasar-dasar penetapan hukum Islam.'),
        array('judul' => 'Bahasa Arab Lanjut (Alfiyah)', 'kode' => 'ULYA-04', 'level' => 'Ulya', 'kategori' => 'Bahasa', 'deskripsi' => 'Gramatika bahasa Arab tingkat lanjut.'),
        array('judul' => 'Matematika Wajib', 'kode' => 'NAS-01', 'level' => 'Ulya', 'kategori' => 'Umum', 'deskripsi' => 'Sesuai kurikulum nasional tingkat SMA/MA.'),
        
        // WUSTHO (SMP/MTs)
        array('judul' => 'Fiqh Dasar (Safinatun Najah)', 'kode' => 'WUST-01', 'level' => 'Wustho', 'kategori' => 'Fiqh', 'deskripsi' => 'Dasar-dasar ibadah sholat dan thoharoh.'),
        array('judul' => 'Aqidah Akhlak', 'kode' => 'WUST-02', 'level' => 'Wustho', 'kategori' => 'Fiqh', 'deskripsi' => 'Pembentukan karakter dan keyakinan dasar.'),
        array('judul' => 'Bahasa Arab Dasar (Jurumiyah)', 'kode' => 'WUST-03', 'level' => 'Wustho', 'kategori' => 'Bahasa', 'deskripsi' => 'Pengenalan struktur kalimat bahasa Arab.'),
        array('judul' => 'Tahfidz Juz 30', 'kode' => 'WUST-04', 'level' => 'Wustho', 'kategori' => 'Quran', 'deskripsi' => 'Hafalan Al-Qur\'an Juz Amma tartil.'),
    );
    update_option( 'pondok_silabus_list', $silabus );

    // 8. Kalender Akademik (Agenda) - Relevan 2025/2026
    $next_year = date('Y', strtotime('+1 year')); // 2026 if now is 2025
    $cur_year = date('Y');

    $agenda = array(
        // Desember 2025 (Current)
        array('date' => $cur_year.'-12-20', 'title' => 'Mulai Libur Semester Ganjil', 'category' => 'Libur', 'time' => ''),
        array('date' => $cur_year.'-12-31', 'title' => 'Istighosah Akhir Tahun', 'category' => 'Kegiatan', 'time' => '19:30 WIB'),
        
        // Januari 2026 (Upcoming)
        array('date' => $next_year.'-01-01', 'title' => 'Tahun Baru Masehi', 'category' => 'Libur', 'time' => ''),
        array('date' => $next_year.'-01-05', 'title' => 'Hari Pertama Masuk KBM Sem. Genap', 'category' => 'Akademik', 'time' => '07:00 WIB'),
        array('date' => $next_year.'-01-15', 'title' => 'Rapat Koordinasi Asatidz', 'category' => 'Kegiatan', 'time' => '09:00 WIB'),
        array('date' => $next_year.'-02-10', 'title' => 'Ujian Harian Tahfidz', 'category' => 'Akademik', 'time' => '07:00 WIB'),
    );
    update_option( 'pondok_agenda_list', $agenda );

    // 9. Auto Create Menus if not exist
    $locations = get_theme_mod( 'nav_menu_locations' );

    // Menu Footer Quick
    if ( ! has_nav_menu( 'footer' ) ) {
        $menu_name = 'Footer Quick Menu';
        $menu_exists = wp_get_nav_menu_object( $menu_name );
        if ( ! $menu_exists ) {
            $menu_id = wp_create_nav_menu( $menu_name );
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Beranda', 'menu-item-url' => home_url('/'), 'menu-item-status' => 'publish'));
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Tentang Kami', 'menu-item-url' => home_url('/tentang-kami'), 'menu-item-status' => 'publish'));
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Pendaftaran', 'menu-item-url' => home_url('/pendaftaran'), 'menu-item-status' => 'publish'));
            
            $locations['footer'] = $menu_id;
        }
    }

    // Menu Footer Academic
    if ( ! has_nav_menu( 'footer-academic' ) ) {
        $menu_name = 'Footer Academic Menu';
        $menu_exists = wp_get_nav_menu_object( $menu_name );
        if ( ! $menu_exists ) {
            $menu_id = wp_create_nav_menu( $menu_name );
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Kurikulum', 'menu-item-url' => home_url('/kurikulum'), 'menu-item-status' => 'publish'));
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Jadwal KBM', 'menu-item-url' => home_url('/jadwal'), 'menu-item-status' => 'publish'));
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Silabus', 'menu-item-url' => home_url('/silabus'), 'menu-item-status' => 'publish'));
            wp_update_nav_menu_item( $menu_id, 0, array('menu-item-title' => 'Kalender', 'menu-item-url' => home_url('/kalender'), 'menu-item-status' => 'publish'));
            
            $locations['footer-academic'] = $menu_id;
        }
    }
    
    // Save Locations
    set_theme_mod( 'nav_menu_locations', $locations );

    // Mark as seeded v5
    update_option( 'pondok_theme_seeded_v5', true );
}

add_action( 'init', 'pondok_run_seeder' );
