<?php get_header(); ?>

<main class="w-full max-w-[1440px] mx-auto px-4 md:px-6 py-8 lg:py-12">
    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-12">
        <!-- Article Column -->
        <article class="lg:col-span-8 flex flex-col gap-6">
            
            <!-- Breadcrumbs -->
            <div class="flex flex-wrap items-center gap-2 text-sm">
                <a class="text-gray-500 dark:text-gray-400 font-medium hover:text-primary transition-colors" href="<?php echo esc_url(home_url('/')); ?>">Home</a>
                <span class="material-symbols-outlined text-gray-500 !text-sm">chevron_right</span>
                <a class="text-gray-500 dark:text-gray-400 font-medium hover:text-primary transition-colors" href="<?php echo esc_url(get_post_type_archive_link('post')); ?>">Blog</a>
                <span class="material-symbols-outlined text-gray-500 !text-sm">chevron_right</span>
                <span class="text-[#111318] dark:text-gray-100 font-medium truncate max-w-[200px]"><?php the_title(); ?></span>
            </div>

            <!-- Page Heading & Meta -->
            <div class="flex flex-col gap-4">
                <h1 class="text-[#111318] dark:text-white text-3xl md:text-4xl lg:text-5xl font-black leading-tight tracking-[-0.033em]">
                    <?php the_title(); ?>
                </h1>
                
                <div class="flex items-center justify-between flex-wrap gap-4 border-b border-gray-100 dark:border-gray-800 pb-6">
                    <div class="flex items-center gap-3">
                         <div class="size-10 rounded-full bg-gray-200 overflow-hidden">
                             <?php echo get_avatar( get_the_author_meta( 'ID' ), 40, '', '', array( 'class' => 'w-full h-full object-cover' ) ); ?>
                         </div>
                        <div class="flex flex-col">
                            <span class="text-[#111318] dark:text-white font-bold text-sm">
                                <?php the_author(); ?>
                            </span>
                            <span class="text-gray-500 dark:text-gray-400 text-xs font-medium">Author</span>
                        </div>
                    </div>
                    
                    <div class="flex items-center gap-4 text-gray-500 dark:text-gray-400 text-sm">
                        <div class="flex items-center gap-1">
                            <span class="material-symbols-outlined !text-lg">calendar_today</span>
                            <span><?php echo get_the_date(); ?></span>
                        </div>
                        <div class="flex items-center gap-1">
                            <span class="material-symbols-outlined !text-lg">folder</span>
                            <span><?php the_category(', '); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Featured Image -->
            <?php if ( has_post_thumbnail() ) : ?>
                <div class="w-full aspect-video md:aspect-[21/9] bg-gray-100 dark:bg-gray-800 rounded-xl overflow-hidden relative shadow-sm">
                    <img 
                        src="<?php the_post_thumbnail_url('large'); ?>" 
                        alt="<?php the_title_attribute(); ?>" 
                        class="w-full h-full object-cover"
                    >
                </div>
            <?php endif; ?>

            <!-- Body Text (The Content) -->
            <div class="prose dark:prose-invert max-w-none text-[#111318] dark:text-gray-200 text-lg leading-relaxed font-body
                        prose-headings:font-display prose-headings:font-bold prose-a:text-primary prose-a:no-underline hover:prose-a:underline
                        prose-blockquote:border-l-4 prose-blockquote:border-primary prose-blockquote:bg-gray-50 dark:prose-blockquote:bg-gray-800 prose-blockquote:py-2 prose-blockquote:px-4 prose-blockquote:rounded-r-lg prose-blockquote:not-italic
                        prose-img:rounded-xl">
                <?php the_content(); ?>
            </div>

            <!-- Tags & Share -->
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-6 border-y border-gray-100 dark:border-gray-800 py-6 mt-6">
                <div class="flex flex-wrap gap-2">
                    <?php 
                    $tags = get_the_tags();
                    if ( $tags ) : 
                    ?>
                        <span class="text-sm font-bold text-[#111318] dark:text-white mr-2 flex items-center">Tags:</span>
                        <?php foreach($tags as $tag) : ?>
                            <a class="px-3 py-1 bg-gray-100 dark:bg-gray-800 hover:bg-primary/10 hover:text-primary text-gray-500 dark:text-gray-300 rounded-full text-sm font-medium transition-colors" 
                               href="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>">
                                <?php echo esc_html( $tag->name ); ?>
                            </a>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <div class="flex items-center gap-3">
                    <span class="text-sm font-bold text-[#111318] dark:text-white mr-2">Share:</span>
                    <!-- Dummy Share Buttons (Functional links would need JS or a plugin) -->
                    <button class="size-8 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center text-gray-500 dark:text-gray-300 hover:bg-primary hover:text-white transition-all">
                        <span class="material-symbols-outlined !text-lg">share</span>
                    </button>
                </div>
            </div>



        </article>

        <!-- Sidebar -->
        <aside class="lg:col-span-4 space-y-8">
            
            <!-- Author Widget -->
            <div class="bg-white dark:bg-[#1a202c] p-6 rounded-xl border border-gray-100 dark:border-gray-700 shadow-sm">
                <div class="flex flex-col items-center text-center">
                    <div class="size-20 rounded-full bg-gray-200 mb-4 overflow-hidden">
                        <?php echo get_avatar( get_the_author_meta( 'ID' ), 80, '', '', array( 'class' => 'w-full h-full object-cover' ) ); ?>
                    </div>
                    <h3 class="text-lg font-bold text-[#111318] dark:text-white">
                        <?php the_author(); ?>
                    </h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4 mt-2">
                        <?php echo get_the_author_meta('description') ? get_the_author_meta('description') : 'Penulis aktif di Pondok Dengan yang berbagi wawasan seputar pendidikan dan keislaman.'; ?>
                    </p>
                    <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="w-full py-2 rounded-lg border border-primary text-primary hover:bg-primary hover:text-white transition-colors text-sm font-bold flex justify-center">
                        Lihat Profil
                    </a>
                </div>
            </div>

            <!-- Sidebar Promo / Newsletter -->
            <div class="bg-primary/5 dark:bg-primary/10 p-6 rounded-xl border border-primary/10">
                <div class="flex items-center gap-2 mb-3 text-primary">
                    <span class="material-symbols-outlined">mail</span>
                    <h3 class="font-bold text-lg">Newsletter</h3>
                </div>
                <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">
                    Dapatkan update artikel terbaru dan berita pondok langsung di email Anda.
                </p>
                <form class="flex flex-col gap-3" onsubmit="event.preventDefault(); alert('Fitur demo newsletter.');">
                    <input class="w-full rounded-lg border-gray-200 dark:border-gray-700 dark:bg-[#1a202c] dark:text-white focus:ring-primary focus:border-primary text-sm p-2.5" placeholder="Alamat email Anda" type="email">
                    <button type="submit" class="w-full py-2.5 bg-primary hover:bg-green-700 text-white rounded-lg text-sm font-bold transition-colors shadow-sm">
                        Berlangganan
                    </button>
                </form>
            </div>

            <!-- Recent Posts Widget -->
            <div>
                <h3 class="font-bold text-lg text-[#111318] dark:text-white mb-4 flex items-center gap-2">
                    <span class="w-1 h-6 bg-primary rounded-full"></span>
                    Artikel Terbaru
                </h3>
                <div class="flex flex-col gap-4">
                    <?php 
                    $recent_posts = new WP_Query(array('posts_per_page' => 3, 'post__not_in' => array(get_the_ID())));
                    if($recent_posts->have_posts()) : $i = 0;
                        while($recent_posts->have_posts()) : $recent_posts->the_post(); $i++;
                    ?>
                    <a class="group flex gap-4 items-start" href="<?php the_permalink(); ?>">
                        <span class="text-3xl font-black text-gray-300 dark:text-gray-600 leading-none mt-[-5px] group-hover:text-primary transition-colors"><?php echo str_pad($i, 2, '0', STR_PAD_LEFT); ?></span>
                        <div>
                            <h4 class="font-bold text-[#111318] dark:text-white group-hover:text-primary transition-colors text-sm leading-snug mb-1">
                                <?php the_title(); ?>
                            </h4>
                            <span class="text-xs text-gray-500"><?php echo get_the_date(); ?></span>
                        </div>
                    </a>
                    <?php 
                        endwhile; 
                        wp_reset_postdata();
                    endif;
                    ?>
                </div>
            </div>

        </aside>
    </div>

    <!-- Related Articles Section -->
    <section class="mt-20 border-t border-gray-100 dark:border-gray-800 pt-12">
        <div class="flex items-center justify-between mb-8">
            <h3 class="text-2xl font-bold text-[#111318] dark:text-white">Artikel Terkait</h3>
            <a class="text-primary font-bold text-sm hover:underline flex items-center gap-1" href="<?php echo esc_url(get_post_type_archive_link('post')); ?>">
                Lihat Semua <span class="material-symbols-outlined !text-sm">arrow_forward</span>
            </a>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php
            // Logic for Related Posts based on Category
            $categories = get_the_category();
            if ($categories) {
                $category_ids = array();
                foreach ($categories as $individual_category) $category_ids[] = $individual_category->term_id;
                
                $args = array(
                    'category__in' => $category_ids,
                    'post__not_in' => array(get_the_ID()),
                    'posts_per_page'=> 3,
                    'orderby'      => 'rand' // Randomize related posts
                );
                
                $related_query = new WP_Query($args);
                
                if( $related_query->have_posts() ) {
                    while( $related_query->have_posts() ) {
                        $related_query->the_post();
            ?>
                <!-- Related Card -->
                <div class="group cursor-pointer flex flex-col gap-4">
                    <div class="overflow-hidden rounded-xl bg-gray-100 dark:bg-gray-800 aspect-[4/3] relative">
                         <a href="<?php the_permalink(); ?>" class="absolute inset-0 z-10"></a>
                         <?php if ( has_post_thumbnail() ) : ?>
                            <img 
                                src="<?php the_post_thumbnail_url('medium'); ?>" 
                                alt="<?php the_title_attribute(); ?>"
                                class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                            >
                        <?php else : ?>
                            <div class="w-full h-full flex items-center justify-center bg-gray-200">
                                <span class="material-symbols-outlined text-gray-400">image</span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="flex flex-col gap-2">
                        <div class="flex items-center gap-3 text-xs font-medium text-gray-500">
                             <?php 
                                $cats = get_the_category();
                                if(!empty($cats)) echo '<span class="text-primary bg-primary/10 px-2 py-0.5 rounded">' . esc_html($cats[0]->name) . '</span>';
                            ?>
                            <span>•</span>
                            <span><?php echo get_the_date(); ?></span>
                        </div>
                        <h4 class="text-lg font-bold text-[#111318] dark:text-white leading-tight group-hover:text-primary transition-colors">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h4>
                    </div>
                </div>
            <?php
                    }
                } else {
                    echo '<p class="text-gray-500 col-span-3 text-center">Tidak ada artikel terkait saat ini.</p>';
                }
                wp_reset_postdata();
            }
            ?>
        </div>
    </section>

    <?php endwhile; endif; ?>
</main>

<?php get_footer(); ?>
