<?php
/**
 * Template Name: About Us
 * 
 * Template for the About Us page (Tentang Kami).
 *
 * @package Pondok_Dengan
 */

get_header(); 
?>

<!-- Hero Section -->
<section class="relative flex min-h-[400px] flex-col items-center justify-center p-4">
    <div class="absolute inset-0 bg-cover bg-center bg-no-repeat" style="background-image: linear-gradient(rgba(0, 0, 0, 0.4) 0%, rgba(0, 0, 0, 0.6) 100%), url('<?php echo esc_url( pondok_get_option('about_hero_image') ); ?>');"></div>
    <div class="relative z-10 flex flex-col gap-4 text-center max-w-[800px] px-4 animate-fade-in-up">
        <h1 class="text-white text-4xl font-black leading-tight tracking-[-0.033em] md:text-6xl">
            <?php the_title(); ?>
        </h1>
        <h2 class="text-gray-200 text-lg font-medium leading-normal md:text-xl max-w-2xl mx-auto">
            <?php echo esc_html( pondok_get_option('about_hero_subtitle') ); ?>
        </h2>
    </div>
</section>

<div class="layout-container flex justify-center py-5">
    <div class="layout-content-container flex flex-col max-w-[1120px] flex-1 w-full">
        
        <!-- History Section -->
        <section class="py-12 md:py-16 px-4 md:px-10">
            <div class="flex flex-col gap-8 md:gap-12 md:flex-row items-center">
                <div class="w-full md:w-1/2">
                    <div class="w-full aspect-[4/3] bg-center bg-no-repeat bg-cover rounded-2xl shadow-lg" style="background-image: url('<?php echo esc_url( pondok_get_option('about_history_image') ); ?>');"></div>
                </div>
                <div class="w-full md:w-1/2 flex flex-col gap-6">
                    <div class="flex flex-col gap-3">
                        <span class="text-primary font-bold tracking-wider text-sm uppercase"><?php echo esc_html( pondok_get_option('about_history_subtitle') ); ?></span>
                        <h2 class="text-[#111318] dark:text-white text-3xl md:text-4xl font-bold leading-tight tracking-[-0.02em]">
                            <?php echo esc_html( pondok_get_option('about_history_title') ); ?>
                        </h2>
                        <div class="text-[#616f89] dark:text-gray-300 text-base md:text-lg leading-relaxed space-y-4">
                            <?php 
                            // Prioritize Theme Options content
                            $history_desc = pondok_get_option('about_history_desc');
                            
                            if ( ! empty( $history_desc ) ) :
                                echo wpautop( esc_html( $history_desc ) );
                            elseif ( have_posts() ) :
                                while ( have_posts() ) : the_post();
                                    the_content();
                                endwhile;
                            else :
                                // Fallback static content
                                echo '<p>Didirikan pada tahun 2003, Pondok Dengan bermula dari sebuah majelis kecil dengan semangat besar untuk mencerdaskan kehidupan bangsa.</p>';
                                echo '<p>Kini, kami telah berkembang menjadi institusi pendidikan terpadu yang memadukan kurikulum nasional dan kepesantrenan.</p>';
                            endif;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Stats Strip -->
        <?php 
        $stats = pondok_get_option('about_stats', array());
        if ( ! empty( $stats ) && is_array( $stats ) ) : 
        ?>
        <section class="py-10 px-4 md:px-0">
            <div class="w-full bg-primary rounded-2xl p-8 md:p-12 text-white shadow-xl">
                <div class="grid grid-cols-1 md:grid-cols-<?php echo count($stats) <= 3 ? '3' : count($stats); ?> gap-8 text-center divide-y md:divide-y-0 md:divide-x divide-white/20">
                    <?php foreach ( $stats as $stat ) : ?>
                    <div class="flex flex-col gap-2 p-4">
                        <span class="text-5xl md:text-6xl font-black tracking-tight"><?php echo esc_html( $stat['number'] ); ?></span>
                        <span class="text-white/80 font-medium text-lg"><?php echo esc_html( $stat['label'] ); ?></span>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php endif; ?>

        <!-- Vision & Mission -->
        <section class="py-12 md:py-16 px-4 md:px-10">
            <div class="flex flex-col gap-4 text-center mb-12">
                <h2 class="text-[#111318] dark:text-white text-3xl md:text-4xl font-bold leading-tight">Visi & Misi</h2>
                <p class="text-[#616f89] dark:text-gray-400 text-lg max-w-2xl mx-auto">
                    Arah dan tujuan kami dalam mendidik generasi masa depan yang unggul dan berakhlak.
                </p>
            </div>
            <div class="grid md:grid-cols-2 gap-6">
                <!-- Vision Card -->
                <div class="flex flex-col gap-4 rounded-xl border border-[#e5e7eb] dark:border-gray-800 bg-white dark:bg-[#1a202c] p-8 hover:shadow-lg transition-shadow">
                    <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary mb-2">
                        <span class="material-symbols-outlined" style="font-size: 28px">visibility</span>
                    </div>
                    <h3 class="text-2xl font-bold text-[#111318] dark:text-white">Visi</h3>
                    <p class="text-[#616f89] dark:text-gray-300 text-lg leading-relaxed">
                        "<?php echo esc_html( pondok_get_option('about_vision_text') ); ?>"
                    </p>
                </div>
                <!-- Mission Card -->
                <div class="flex flex-col gap-4 rounded-xl border border-[#e5e7eb] dark:border-gray-800 bg-white dark:bg-[#1a202c] p-8 hover:shadow-lg transition-shadow">
                    <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary mb-2">
                        <span class="material-symbols-outlined" style="font-size: 28px">flag</span>
                    </div>
                    <h3 class="text-2xl font-bold text-[#111318] dark:text-white">Misi</h3>
                    <ul class="flex flex-col gap-3 text-[#616f89] dark:text-gray-300 text-lg leading-relaxed list-none">
                        <?php 
                        $missions = pondok_get_option('about_mission_points', array());
                        if ( ! empty( $missions ) && is_array( $missions ) ) :
                            foreach ( $missions as $mission ) :
                        ?>
                        <li class="flex gap-3 items-start">
                            <span class="material-symbols-outlined text-primary shrink-0 mt-1 text-sm">check_circle</span>
                            <span><?php echo esc_html( $mission['text'] ); ?></span>
                        </li>
                        <?php 
                            endforeach;
                        else:
                        ?>
                            <li>Belum ada data misi.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </section>

        <!-- Leadership Team -->
        <section class="py-12 px-4 md:px-10">
            <div class="flex flex-col gap-4 text-center mb-10">
                <h2 class="text-[#111318] dark:text-white text-3xl font-bold leading-tight">Pimpinan dan Staf</h2>
                <p class="text-[#616f89] dark:text-gray-400 text-base">Jajaran pengelola dan pendidik yang berdedikasi dalam membangun pendidikan berkualitas.</p>
            </div>
            <div class="flex flex-wrap justify-center gap-6 md:gap-8">
                <?php 
                $leaders = pondok_get_option('about_leadership', array());
                if ( ! empty( $leaders ) && is_array( $leaders ) ) :
                    foreach ( $leaders as $leader ) :
                        $photo = !empty($leader['photo']) ? $leader['photo'] : 'https://via.placeholder.com/300x400?text=No+Image';
                ?>
                <div class="flex flex-col items-center gap-3 w-full sm:w-[calc(50%-12px)] lg:w-[calc(25%-18px)]">
                    <div class="w-full aspect-[3/4] rounded-xl bg-gray-200 bg-cover bg-center mb-2 shadow-md" style="background-image: url('<?php echo esc_url( $photo ); ?>');"></div>
                    <div class="text-center">
                        <h3 class="text-lg font-bold text-[#111318] dark:text-white"><?php echo esc_html( $leader['name'] ); ?></h3>
                        <p class="text-primary font-medium text-sm"><?php echo esc_html( $leader['position'] ); ?></p>
                    </div>
                </div>
                <?php 
                    endforeach;
                else: 
                     // Fallback hardcoded if empty, or just show message
                ?>
                    <div class="col-span-full text-center text-gray-500">Belum ada data pimpinan.</div>
                <?php endif; ?>
            </div>
        </section>

    </div>
</div>

<?php get_footer(); ?>
