<?php
/**
 * Template Name: Kurikulum Page
 */
get_header();

// Get Theme Options & Silabus Data
$focus_level = function_exists('pondok_get_option') ? pondok_get_option('school_level_focus', '') : '';
$all_silabus = get_option('pondok_silabus_list', array());

// Filter Logic for Subjects Table
// Filter Logic for Subjects Table
$display_subjects = array();
foreach($all_silabus as $item) {
    if(!empty($focus_level)) {
        $item_lvl = isset($item['level']) ? trim($item['level']) : '';
        
        // Dual logic match
        $match = false;
        if(strcasecmp($item_lvl, $focus_level) == 0) $match = true;
        
        // Partial match (e.g. 'Ulya (Atas)' matches 'Ulya')
        if (!$match && !empty($focus_level) && stripos($item_lvl, $focus_level) !== false) {
             $match = true;
        }
        
        // Cross-check Wustho/a
        if (!$match && (strcasecmp($focus_level, 'Wustho') == 0 || strcasecmp($focus_level, 'Wustha') == 0)) {
            if (strcasecmp($item_lvl, 'Wustho') == 0 || strcasecmp($item_lvl, 'Wustha') == 0) {
                $match = true;
            }
        }
        
        // Allow general/empty level
        if(empty($item_lvl)) $match = true;

        if(!$match) continue;
    }
    $display_subjects[] = $item;
}

// Logic to determine which Levels to show in "Jenjang Pendidikan" section
// Use simple loose check or strict? Loose is better for UI logic here.
$show_ula = empty($focus_level) || strcasecmp($focus_level, 'Ula') == 0;
// Support both spellings for section visibility
$show_wustha = empty($focus_level) || strcasecmp($focus_level, 'Wustho') == 0 || strcasecmp($focus_level, 'Wustha') == 0; 
$show_ulya = empty($focus_level) || strcasecmp($focus_level, 'Ulya') == 0;

// Colors for Category Badges
function get_cat_badge_style($cat) {
    if($cat == 'Fiqh') return 'bg-yellow-100 text-yellow-700';
    if($cat == 'Bahasa') return 'bg-blue-100 text-blue-700';
    if($cat == 'Quran') return 'bg-purple-100 text-purple-700';
    if($cat == 'Umum') return 'bg-green-100 text-green-700';
    return 'bg-gray-100 text-gray-700';
}
?>

<div class="relative flex h-auto min-h-screen w-full flex-col overflow-x-hidden bg-background-light dark:bg-background-dark font-display text-[#111318] dark:text-white transition-colors duration-200">
      
      <!-- Hero Section -->
      <div class="w-full bg-white dark:bg-[#111318]">
        <div class="flex justify-center py-5 lg:py-10 px-4">
          <div class="flex flex-col max-w-[1200px] w-full gap-6">
            <?php 
            // Hero Image Logic: Featured Image -> Settings -> Fallback
            $hero_bg = get_the_post_thumbnail_url( get_the_ID(), 'full' );
            if ( empty($hero_bg) ) {
                $hero_bg = pondok_get_option('hero_image', get_template_directory_uri() . '/assets/images/hero-mess.jpg');
            }
            ?>
            <div class="relative w-full rounded-xl overflow-hidden min-h-[400px] lg:min-h-[480px] flex flex-col items-center justify-center text-center p-8 bg-cover bg-center"
              style="background-image: linear-gradient(rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.7)), url('<?php echo esc_url($hero_bg); ?>');">
                
                <!-- Dynamic Title based on Focus -->
                <div class="flex flex-col gap-4 max-w-[800px]">
                <h1 class="text-white text-4xl lg:text-5xl font-black leading-tight tracking-[-0.033em]">
                  Kurikulum <?php echo $focus_level ? 'Tingkat ' . esc_html($focus_level) : 'Terpadu & Holistik'; ?>
                </h1>
                <h2 class="text-gray-200 text-base lg:text-lg font-normal leading-relaxed">
                  <?php 
                    $hero_desc = pondok_get_option('kurikulum_hero_desc_text');
                    if(empty($hero_desc)) {
                        $hero_desc = get_the_excerpt();
                    }
                    if(empty($hero_desc)) {
                        $hero_desc = 'Memadukan kekayaan tradisi keilmuan Islam dengan sains modern untuk membentuk generasi ulama-intelektual yang siap menghadapi tantangan zaman.';
                    }
                    echo esc_html($hero_desc);
                  ?>
                </h2>
              </div>
              <div class="mt-8 flex flex-col sm:flex-row gap-4">
                <?php 
                    $btn1_text = pondok_get_option('kurikulum_hero_btn1_text', 'Unduh Brosur Kurikulum');
                    $btn1_link = pondok_get_option('kurikulum_hero_btn1_link', '#');
                    $btn2_text = pondok_get_option('kurikulum_hero_btn2_text', 'Lihat Kalender Akademik');
                    $btn2_link = pondok_get_option('kurikulum_hero_btn2_link', '#');
                ?>
                <a href="<?php echo esc_url($btn1_link); ?>" class="flex items-center justify-center rounded-lg h-12 px-6 bg-primary hover:brightness-90 transition-colors text-white text-base font-bold leading-normal tracking-[0.015em]">
                  <span class="material-symbols-outlined mr-2 text-xl">download</span>
                  <?php echo esc_html($btn1_text); ?>
                </a>
                <a href="<?php echo esc_url($btn2_link); ?>" class="flex items-center justify-center rounded-lg h-12 px-6 bg-white/10 hover:bg-white/20 backdrop-blur-sm border border-white/30 transition-colors text-white text-base font-bold leading-normal tracking-[0.015em]">
                  <?php echo esc_html($btn2_text); ?>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Core Competencies -->
      <div class="w-full bg-white dark:bg-[#111318] py-10">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[960px] w-full gap-10">
            <div class="flex flex-col gap-4 text-center items-center">
              <span class="text-primary font-bold tracking-wider uppercase text-sm">Target &amp; Capaian</span>
              <h2 class="text-[#111318] dark:text-white text-3xl font-bold leading-tight">
                <?php echo esc_html(pondok_get_option('kurikulum_competencies_title', 'Kompetensi Utama Lulusan')); ?>
              </h2>
              <p class="text-gray-500 dark:text-gray-400 max-w-[700px]">
                <?php echo esc_html(pondok_get_option('kurikulum_competencies_subtitle', 'Kurikulum kami dirancang untuk memastikan setiap santri mencapai standar kompetensi yang seimbang antara aspek spiritual, intelektual, dan emosional.')); ?>
              </p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
              <?php 
                $competencies = pondok_get_option('kurikulum_competencies');
                if(empty($competencies) || !is_array($competencies)) {
                    // Fallback Default Data
                     $competencies = array(
                        array('title' => 'Tahfidz & Ulumul Syar\'i', 'desc' => 'Target hafalan mutqin minimal 15 juz dengan pemahaman mendalam terhadap fiqh, aqidah, dan tafsir dasar.', 'icon' => 'auto_stories'),
                        array('title' => 'Bilingual Proficiency', 'desc' => 'Kemampuan aktif berbahasa Arab dan Inggris sebagai kunci pembuka gerbang ilmu pengetahuan global.', 'icon' => 'language'),
                        array('title' => 'Critical Thinking', 'desc' => 'Pembentukan pola pikir kritis dan analitis melalui pembelajaran sains, matematika, dan logika.', 'icon' => 'psychology'),
                     );
                }

                foreach($competencies as $comp):
              ?>
              <!-- Card -->
              <div class="flex flex-col gap-4 rounded-xl border border-gray-200 dark:border-gray-800 bg-gray-50 dark:bg-[#1a202c] p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="size-12 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                  <span class="material-symbols-outlined text-3xl"><?php echo esc_html(!empty($comp['icon']) ? $comp['icon'] : 'school'); ?></span>
                </div>
                <div class="flex flex-col gap-2">
                  <h3 class="text-[#111318] dark:text-white text-xl font-bold"><?php echo esc_html($comp['title']); ?></h3>
                  <p class="text-gray-600 dark:text-gray-400 text-sm leading-relaxed">
                    <?php echo esc_html($comp['desc']); ?>
                  </p>
                </div>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </div>

      <!-- Academic Levels (Dynamic Display) -->
      <div class="w-full bg-background-light dark:bg-background-dark py-12 border-y border-gray-200 dark:border-gray-800">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[960px] w-full gap-8">
            <div class="flex justify-between items-end">
              <div>
                <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-2">
                    <?php echo $focus_level ? 'Jenjang Fokus Pendidikan' : 'Jenjang Pendidikan'; ?>
                </h2>
                <p class="text-gray-500 dark:text-gray-400 text-sm">Program pendidikan berjenjang yang berkelanjutan.</p>
              </div>
            </div>
            
            <div class="flex flex-wrap justify-center gap-6">
              
              <?php 
                $levels_data = pondok_get_option('kurikulum_levels');
                if(empty($levels_data) || !is_array($levels_data)) {
                    // Fallback Defaults
                    $levels_data = array(
                        array('tag' => 'Ula', 'label' => 'Tingkat Dasar', 'title' => 'Marhalah Ula', 'desc' => 'Fokus pada penanaman adab, kelancaran membaca Al-Qur\'an, dan dasar-dasar bahasa Arab.', 'points' => "- Hafalan Juz 30\n- Calistung Dasar"),
                        array('tag' => 'Wustho', 'label' => 'Tingkat Menengah', 'title' => 'Marhalah Wustho', 'desc' => 'Pengembangan logika berpikir, pendalaman fiqh ibadah, dan penguasaan bahasa aktif.', 'points' => "- Hafalan 5 Juz\n- Nahwu Shorof Dasar"),
                        array('tag' => 'Ulya', 'label' => 'Tingkat Atas', 'title' => 'Marhalah Ulya', 'desc' => 'Spesialisasi keilmuan, kajian kitab turats, dan persiapan masuk perguruan tinggi.', 'points' => "- Hafalan 15+ Juz\n- Karya Tulis Ilmiah"),
                    );
                }

                // Color Map for visual variety based on index
                $lvl_colors = ['green', 'blue', 'purple', 'orange', 'red'];
                $idx_lvl = 0;

                foreach($levels_data as $lvl):
                    // Filter Logic:
                    // If Global Focus is set, only show matching tags.
                    // If tag is empty, show always.
                    
                    $this_tag = isset($lvl['tag']) ? trim($lvl['tag']) : '';
                    
                    $show_this = true;
                    if(!empty($focus_level)) {
                        // Strict check: if tag exists and doesn't match focus level
                        if(!empty($this_tag) && strcasecmp($this_tag, $focus_level) !== 0) {
                            // Allow 'Wustha' == 'Wustho'
                            $synonyms = ['Wustha', 'Wustho'];
                            if(in_array(ucfirst(strtolower($focus_level)), $synonyms) && in_array(ucfirst(strtolower($this_tag)), $synonyms)) {
                                $show_this = true;
                            } else {
                                $show_this = false;
                            }
                        }
                    }

                    if(!$show_this) continue;

                // Prepare Data
                    $l_label = isset($lvl['label']) ? $lvl['label'] : '';
                    $l_title = isset($lvl['title']) ? $lvl['title'] : '';
                    $l_desc  = isset($lvl['desc']) ? $lvl['desc'] : '';
                    $l_image = isset($lvl['image']) ? $lvl['image'] : '';
                    $l_points_raw = isset($lvl['points']) ? $lvl['points'] : '';
                    $l_points = array_filter(array_map('trim', explode("\n", $l_points_raw)));

                    // Cycle colors
                    $clr = $lvl_colors[$idx_lvl % count($lvl_colors)];
                    $idx_lvl++;
              ?>
              <!-- Level Card: <?php echo esc_html($l_title); ?> -->
              <div class="w-full md:w-[calc(50%-1.5rem)] lg:w-[calc(33.33%-1.5rem)] bg-white dark:bg-[#1a202c] rounded-xl overflow-hidden shadow-sm border border-gray-100 dark:border-gray-800 flex flex-col">
                <div class="h-32 bg-gray-200 <?php echo empty($l_image) ? 'item-pattern-bg' : ''; ?> bg-cover bg-center" 
                     style="<?php echo !empty($l_image) ? 'background-image: url('.esc_url($l_image).');' : ''; ?>">
                </div>
                <div class="p-6 flex flex-col flex-1">
                  <div class="mb-3 px-3 py-1 bg-<?php echo $clr; ?>-100 dark:bg-<?php echo $clr; ?>-900/30 text-<?php echo $clr; ?>-700 dark:text-<?php echo $clr; ?>-400 text-xs font-bold rounded-full w-fit">
                    <?php echo esc_html($l_label); ?>
                  </div>
                  <h3 class="text-lg font-bold text-[#111318] dark:text-white mb-2"><?php echo esc_html($l_title); ?></h3>
                  <p class="text-gray-500 dark:text-gray-400 text-sm mb-4 flex-1">
                    <?php echo esc_html($l_desc); ?>
                  </p>
                  <?php if(!empty($l_points)): ?>
                  <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-2 mb-6">
                    <?php foreach($l_points as $pt): 
                        // Remove leading dashes/bullets cleanly
                        $pt_clean = ltrim($pt, '-•* ');
                    ?>
                    <li class="flex items-center gap-2"><span class="material-symbols-outlined text-base text-primary">check_circle</span><?php echo esc_html($pt_clean); ?></li>
                    <?php endforeach; ?>
                  </ul>
                  <?php endif; ?>
                  <a href="<?php echo home_url('/pendaftaran'); ?>" class="text-primary text-sm font-bold hover:underline self-start">Lihat Detail Program →</a>
                </div>
              </div>
              <?php endforeach; ?>

              <?php if($idx_lvl === 0): ?>
                <div class="col-span-full text-center py-10 text-gray-500">
                    <p>Tidak ada program jenjang yang sesuai dengan filter saat ini.</p>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>
      </div>

      <!-- Detailed Curriculum Table (Sync from Silabus) -->
      <div class="w-full bg-white dark:bg-[#111318] py-12">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[960px] w-full gap-8">
            <div>
              <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-4">
                Struktur Mata Pelajaran <?php echo $focus_level ? "($focus_level)" : ''; ?>
              </h2>
              <p class="text-gray-500 dark:text-gray-400">
                Daftar mata pelajaran inti yang diajarkan. Data diambil dari Silabus yang aktif.
              </p>
            </div>
            <div class="w-full overflow-hidden rounded-lg border border-gray-200 dark:border-gray-800">
              <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                  <thead class="bg-gray-50 dark:bg-[#1a202c] text-xs uppercase text-gray-500 dark:text-gray-400">
                    <tr>
                      <th class="p-4 font-bold border-b border-gray-200 dark:border-gray-800">Mata Pelajaran</th>
                      <th class="p-4 font-bold border-b border-gray-200 dark:border-gray-800">Tingkat</th>
                      <th class="p-4 font-bold border-b border-gray-200 dark:border-gray-800">Kelompok</th>
                      <th class="p-4 font-bold border-b border-gray-200 dark:border-gray-800 min-w-[300px]">Deskripsi Singkat</th>
                    </tr>
                  </thead>
                  <tbody class="text-sm text-[#111318] dark:text-gray-300 divide-y divide-gray-100 dark:divide-gray-800">
                    
                    <?php if(empty($display_subjects)): ?>
                        <tr><td colspan="4" class="p-4 text-center text-gray-500">Belum ada data mata pelajaran.</td></tr>
                    <?php else: ?>
                        <?php foreach($display_subjects as $subj): 
                            $badge_class = get_cat_badge_style($subj['kategori']);
                        ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-900 transition-colors">
                            <td class="p-4 font-medium">
                                <?php echo esc_html($subj['judul']); ?>
                                <div class="text-xs text-gray-500 font-normal"><?php echo esc_html($subj['kode']); ?></div>
                            </td>
                            <td class="p-4 text-gray-500"><?php echo esc_html($subj['level']); ?></td>
                            <td class="p-4">
                                <span class="px-2 py-1 rounded-full text-xs font-bold <?php echo $badge_class; ?>">
                                    <?php echo esc_html($subj['kategori']); ?>
                                </span>
                            </td>
                            <td class="p-4 text-gray-500 dark:text-gray-400">
                                <?php echo esc_html(wp_trim_words($subj['deskripsi'], 15)); ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>

                  </tbody>
                </table>
              </div>
            </div>
            
             <div class="flex justify-center mt-4">
                <a href="<?php echo home_url('/silabus'); ?>" class="text-sm font-bold text-primary hover:underline flex items-center gap-1">
                   Lihat Silabus Lengkap & Topik
                   <span class="material-symbols-outlined text-[16px]">arrow_forward</span>
                </a>
             </div>

          </div>
        </div>
      </div>

<?php
// Get Jadwal Data
$all_jadwal = get_option('pondok_jadwal_list', array());
$display_jadwal = array();

// Helper to sort days
$day_order = array('Senin' => 1, 'Selasa' => 2, 'Rabu' => 3, 'Kamis' => 4, 'Jumat' => 5, 'Sabtu' => 6, 'Ahad' => 7);

foreach($all_jadwal as $j) {
    // Filter Logic matches Silabus logic
    if(!empty($focus_level)) {
        $j_lvl = isset($j['tingkat']) ? trim($j['tingkat']) : ''; // Key is 'tingkat' in jadwal settings
        
        $match = false;
        if(strcasecmp($j_lvl, $focus_level) == 0) $match = true;
        if (!$match && !empty($focus_level) && stripos($j_lvl, $focus_level) !== false) $match = true;
        
        // Cross-check Wustho/a
        if (!$match && (strcasecmp($focus_level, 'Wustho') == 0 || strcasecmp($focus_level, 'Wustha') == 0)) {
            if (strcasecmp($j_lvl, 'Wustho') == 0 || strcasecmp($j_lvl, 'Wustha') == 0) {
                $match = true;
            }
        }
        
        // Allow general/empty level
        if(empty($j_lvl) || $j_lvl == 'Umum') $match = true;

        if(!$match) continue;
    }
    $display_jadwal[] = $j;
}

// Group by Day
$grouped_jadwal = array();
foreach($display_jadwal as $j) {
    // Basic validation
    if(empty($j['hari'])) continue;
    $h = ucfirst(strtolower($j['hari']));
    $grouped_jadwal[$h][] = $j;
}

// Sort Days
uksort($grouped_jadwal, function($a, $b) use ($day_order) {
    $oa = isset($day_order[$a]) ? $day_order[$a] : 99;
    $ob = isset($day_order[$b]) ? $day_order[$b] : 99;
    return $oa - $ob;
});

// If not empty, render section
if(!empty($grouped_jadwal)):
?>
      <!-- Jadwal KBM Section -->
      <div class="w-full bg-gray-50 dark:bg-[#15171e] py-12 border-t border-gray-200 dark:border-gray-800">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[1200px] w-full gap-8">
            <div class="text-center">
              <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-2">
                Jadwal Pelajaran Pekanan <?php echo $focus_level ? "($focus_level)" : ''; ?>
              </h2>
              <p class="text-gray-500 dark:text-gray-400">
                Jadwal Kegiatan Belajar Mengajar (KBM) aktif.
              </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach($grouped_jadwal as $day => $items): ?>
                <div class="flex flex-col bg-white dark:bg-[#1a202c] rounded-xl border border-gray-200 dark:border-gray-700 overflow-hidden shadow-sm hover:shadow-md transition-shadow">
                    <div class="bg-primary/10 px-4 py-3 border-b border-primary/10">
                        <h3 class="font-bold text-lg text-primary"><?php echo esc_html($day); ?></h3>
                    </div>
                    <div class="divide-y divide-gray-100 dark:divide-gray-800">
                        <?php 
                        // Sort items by time
                        usort($items, function($a, $b) {
                            return strcmp($a['jam_mulai'], $b['jam_mulai']);
                        });
                        
                        foreach($items as $item): ?>
                        <div class="p-4 hover:bg-gray-50 dark:hover:bg-gray-800/50 transition-colors">
                            <div class="flex justify-between items-start mb-1">
                                <span class="text-xs font-bold px-2 py-0.5 rounded bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300">
                                    <?php echo esc_html($item['jam_mulai'] . ' - ' . $item['jam_selesai']); ?>
                                </span>
                                <span class="text-xs text-gray-400 truncate max-w-[80px]" title="<?php echo esc_attr($item['ruang']); ?>">
                                    <?php echo esc_html($item['ruang']); ?>
                                </span>
                            </div>
                            <h4 class="font-bold text-[#111318] dark:text-white text-sm mb-0.5"><?php echo esc_html($item['mapel']); ?></h4>
                            <div class="flex items-center gap-2 text-xs text-gray-500 dark:text-gray-400">
                                <span class="material-symbols-outlined text-[14px]">person</span>
                                <?php echo esc_html($item['pengajar']); ?>
                                <?php if(!empty($item['kelas'])): ?>
                                    <span class="text-gray-300">•</span>
                                    <span><?php echo esc_html($item['kelas']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

          </div>
        </div>
      </div>
<?php endif; ?>
      </div>

      <!-- Rutinitas Harian -->
      <div class="w-full bg-background-light dark:bg-background-dark py-12">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[960px] w-full gap-10">
            <div class="flex flex-col md:flex-row gap-8 items-start">
              <!-- Left: Info -->
              <div class="flex-1">
                <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-4">
                    <?php echo esc_html(pondok_get_option('kurikulum_routine_title', 'Rutinitas Harian')); ?>
                </h2>
                <p class="text-gray-600 dark:text-gray-400 mb-6">
                  <?php echo esc_html(pondok_get_option('kurikulum_routine_subtitle', 'Disiplin adalah kunci keberhasilan. Para santri dididik untuk menghargai waktu melalui jadwal harian yang teratur.')); ?>
                </p>
                <div class="flex flex-col gap-4">
                  <?php 
                  $routines = pondok_get_option('kurikulum_daily_routine');
                  if(empty($routines) || !is_array($routines)) {
                      // Fallback Default Data
                      $routines = array(
                          array('time' => '03:30 - 04:30 WIB', 'activity' => 'Qiyamul Lail', 'icon' => 'wb_twilight'),
                          array('time' => '07:00 - 14:30 WIB', 'activity' => 'Kegiatan Belajar Mengajar (KBM)', 'icon' => 'school'),
                          array('time' => '19:30 - 21:00 WIB', 'activity' => 'Murajaah & Belajar Mandiri', 'icon' => 'menu_book'),
                      );
                  }

                  // Icon colors mapping for visual variety
                  $colors = ['orange', 'blue', 'purple', 'green', 'red'];
                  
                  foreach($routines as $idx => $r):
                      $c = $colors[$idx % count($colors)];
                  ?>
                  <div class="flex items-center gap-4 p-4 rounded-lg bg-white dark:bg-[#1a202c] border border-gray-200 dark:border-gray-800 shadow-sm">
                    <div class="p-2 bg-<?php echo $c; ?>-100 text-<?php echo $c; ?>-600 rounded-full overflow-hidden flex items-center justify-center relative w-10 h-10">
                        <?php 
                        $icon_val = isset($r['icon']) ? $r['icon'] : '';
                        if ( filter_var($icon_val, FILTER_VALIDATE_URL) || strpos($icon_val, 'http') === 0 || strpos($icon_val, '/wp-content') !== false ) {
                             // It's an image URL
                             echo '<img src="' . esc_url($icon_val) . '" class="w-full h-full object-cover" alt="icon">';
                        } else {
                             // Fallback to Material Icon or Default
                             $icon_code = !empty($icon_val) ? strtolower(trim(str_replace(['"', "'"], '', $icon_val))) : 'circle';
                             echo '<span class="material-symbols-outlined text-lg">' . esc_html($icon_code) . '</span>';
                        }
                        ?>
                    </div>
                    <div>
                        <h4 class="font-bold text-[#111318] dark:text-white"><?php echo esc_html($r['activity']); ?></h4>
                        <p class="text-xs text-gray-500"><?php echo esc_html($r['time']); ?></p>
                    </div>
                  </div>
                  <?php endforeach; ?>
                </div>
              </div>
              <!-- Right: Visual -->
              <div class="flex-1 w-full relative h-[400px] rounded-xl overflow-hidden bg-cover bg-center shadow-lg bg-gray-300 item-pattern-bg">
                <?php
                    $quote_text = pondok_get_option('kurikulum_quote_text', '"Waktu bagaikan pedang, jika kau tidak memotongnya, ia akan memotongmu."');
                    $quote_auth = pondok_get_option('kurikulum_quote_author', 'Imam Syafi\'i');
                    $quote_bg   = pondok_get_option('kurikulum_quote_bg', '');
                    // Use a default pattern or something if no image
                ?>
                <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent flex items-end p-6" 
                     style="<?php echo $quote_bg ? 'background-image: url('.esc_url($quote_bg).'); background-size: cover; background-position: center;' : ''; ?>">
                    <div class="text-white z-10 relative">
                        <p class="font-bold text-lg"><?php echo esc_html($quote_text); ?></p>
                        <p class="text-sm opacity-80 mt-1">— <?php echo esc_html($quote_auth); ?></p>
                    </div>
                    <?php if($quote_bg): ?>
                        <div class="absolute inset-0 bg-black/40"></div>
                    <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

    <!-- Extracurriculars -->
    <div class="w-full bg-white dark:bg-[#111318] py-12">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[960px] w-full">
            <div class="text-center mb-10">
              <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-2">
                <?php echo esc_html(pondok_get_option('kurikulum_ekstra_title', 'Ekstrakurikuler Penunjang')); ?>
              </h2>
              <p class="text-gray-500 dark:text-gray-400">
                <?php echo esc_html(pondok_get_option('kurikulum_ekstra_subtitle', 'Menyalurkan bakat dan minat santri di luar jam akademik.')); ?>
              </p>
            </div>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
              <?php 
              $ekstra = pondok_get_option('kurikulum_ekstra');
              if(empty($ekstra) || !is_array($ekstra)) {
                  $ekstra = array(
                      array('name' => 'Olahraga', 'icon' => 'sports_soccer'),
                      array('name' => 'Public Speaking', 'icon' => 'mic'),
                      array('name' => 'Komputer & Desain', 'icon' => 'computer'),
                      array('name' => 'Pertanian Organik', 'icon' => 'agriculture'),
                  );
              }
              
              foreach($ekstra as $e):
              ?>
              <div class="flex flex-col items-center gap-3 p-6 rounded-lg bg-gray-50 dark:bg-[#1a202c] border border-transparent hover:border-primary/30 transition-colors text-center w-full">
                <?php $e_icon = !empty($e['icon']) ? strtolower(trim(str_replace(['"', "'"], '', $e['icon']))) : 'star'; ?>
                <span class="material-symbols-outlined text-4xl text-primary"><?php echo esc_html($e_icon); ?></span>
                <span class="font-bold text-sm text-[#111318] dark:text-white"><?php echo esc_html($e['name']); ?></span>
              </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
    </div>

</div>

<?php get_footer(); ?>
