<?php
/**
 * Template Name: Pendaftaran Santri
 */
get_header(); ?>

<!-- Load jsPDF from CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>

<main class="flex-grow flex flex-col bg-[#f6f6f8] dark:bg-background-dark text-[#111318] dark:text-gray-100 min-h-screen py-8 px-4 sm:px-6 lg:px-8">
      <div class="mx-auto max-w-[1100px] w-full">
        <!-- Breadcrumbs -->
        <div class="mb-6 flex items-center gap-2 text-sm text-[#616f89] dark:text-gray-400">
          <a class="hover:text-primary transition-colors" href="<?php echo home_url(); ?>">Beranda</a>
          <span class="material-symbols-outlined text-[16px]">chevron_right</span>
          <span class="font-medium text-[#111318] dark:text-white"><?php the_title(); ?></span>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
          <!-- Left Column: WIZARD FORM (8/12) -->
          <div class="lg:col-span-8 space-y-6">
            
            <!-- Page Heading -->
            <div class="space-y-2">
              <h1 class="text-3xl md:text-4xl font-black tracking-tight text-[#111318] dark:text-white">
                Pendaftaran Santri Baru
              </h1>
              <p class="text-[#616f89] dark:text-gray-400 text-lg leading-relaxed">
                Silakan lengkapi formulir di bawah ini untuk memulai proses pendaftaran santri baru.
              </p>
            </div>

            <!-- Progress Bar Card -->
            <div class="bg-white dark:bg-[#1a202c] rounded-xl p-6 border border-[#e5e7eb] dark:border-gray-700 shadow-sm">
              <div class="flex items-center justify-between mb-3">
                <span class="text-sm font-bold text-primary" id="step-count-label">Langkah 1 dari 4</span>
                <span class="text-sm text-[#616f89] dark:text-gray-400 font-medium" id="step-percent-label">25% Selesai</span>
              </div>
              <div class="h-2 w-full bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden">
                <div class="h-full bg-primary transition-all duration-300 ease-out" id="main-progress-bar" style="width: 25%"></div>
              </div>
              <div class="mt-4 flex justify-between text-xs font-medium text-[#616f89] dark:text-gray-500" id="step-indicators">
                <div class="text-primary flex items-center gap-1 font-bold step-ind" data-step="1">
                  <span class="material-symbols-outlined text-[16px]">person</span>
                  <span class="hidden sm:inline">Data Diri</span>
                </div>
                <div class="flex items-center gap-1 opacity-50 step-ind" data-step="2">
                  <span class="material-symbols-outlined text-[16px]">school</span>
                  <span class="hidden sm:inline">Pendidikan</span>
                </div>
                <div class="flex items-center gap-1 opacity-50 step-ind" data-step="3">
                  <span class="material-symbols-outlined text-[16px]">folder_open</span>
                  <span class="hidden sm:inline">Berkas</span>
                </div>
                <div class="flex items-center gap-1 opacity-50 step-ind" data-step="4">
                  <span class="material-symbols-outlined text-[16px]">check_circle</span>
                  <span class="hidden sm:inline">Konfirmasi</span>
                </div>
              </div>
            </div>

            <!-- MAIN FORM WRAPPER -->
            <form id="wizardForm" class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#e5e7eb] dark:border-gray-700 shadow-sm overflow-hidden relative min-h-[500px]">
              
              <!-- STEP 1: DATA DIRI -->
              <div class="wizard-step" id="step-1">
                <div class="border-b border-[#e5e7eb] dark:border-gray-700 bg-[#f9fafb] dark:bg-[#2d3748] px-6 py-4 flex items-center gap-3">
                  <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary/10 text-primary">
                    <span class="material-symbols-outlined text-lg">person</span>
                  </div>
                  <h3 class="text-lg font-bold text-[#111318] dark:text-white">Informasi Pribadi</h3>
                </div>
                
                <div class="p-6 md:p-8 space-y-6">
                  <!-- Full Name -->
                  <div class="flex flex-col gap-2">
                    <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Nama Lengkap <span class="text-red-500">*</span></label>
                    <div class="relative">
                      <span class="absolute left-3 top-1/2 -translate-y-1/2 text-[#616f89]"><span class="material-symbols-outlined text-[20px]">badge</span></span>
                      <input id="inp_nama" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 pl-10 pr-4 text-base text-[#111318] placeholder-[#616f89] focus:border-primary focus:ring-1 focus:ring-primary dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="Masukkan nama lengkap sesuai ijazah" required type="text" />
                    </div>
                  </div>
                  
                  <!-- Identitas (NISN & Jenjang) -->
                  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                       <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">NISN <span class="text-red-500">*</span></label>
                        <input id="inp_nisn" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="Nomor Induk Siswa Nasional" type="number" />
                      </div>
                      <div class="flex flex-col gap-2">
                          <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Jenjang Dituju <span class="text-red-500">*</span></label>
                          <select id="inp_jenjang" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white">
                             <option value="Ula">Ula (SD/MI)</option>
                             <option value="Wustho">Wustho (SMP/MTs)</option>
                             <option value="Ulya">Ulya (SMA/MA)</option>
                          </select>
                      </div>
                  </div>

                  <!-- Identitas (NIK & KK) -->
                  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                      <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">NIK (Sesuai KK) <span class="text-red-500">*</span></label>
                        <input id="inp_nik" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="16 Digit NIK" type="number" />
                      </div>
                      <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Nomor Kartu Keluarga (KK) <span class="text-red-500">*</span></label>
                        <input id="inp_no_kk" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="16 Digit Nomor KK" type="number" />
                      </div>
                  </div>

                  <!-- Gender & Urutan Anak -->
                  <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                       <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Jenis Kelamin <span class="text-red-500">*</span></label>
                         <select id="inp_gender" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white">
                            <option value="">Pilih Jenis Kelamin</option>
                            <option value="Laki-laki">Laki-laki</option>
                            <option value="Perempuan">Perempuan</option>
                          </select>
                      </div>
                      <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Anak ke- <span class="text-red-500">*</span></label>
                        <input id="inp_anak_ke" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="1" type="number" />
                      </div>
                      <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Dari Total Saudara <span class="text-red-500">*</span></label>
                        <input id="inp_jumlah_saudara" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="3" type="number" />
                      </div>
                  </div>
                  
                  <!-- Birth Details & Hobi -->
                  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Tempat Lahir <span class="text-red-500">*</span></label>
                      <input id="inp_tempat_lahir" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="Kota Kelahiran" type="text" />
                    </div>
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Tanggal Lahir <span class="text-red-500">*</span></label>
                      <input id="inp_tanggal_lahir" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="date" />
                    </div>
                  </div>
                  
                  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Hobi</label>
                      <input id="inp_hobi" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="Olahraga, Membaca, dll" type="text" />
                    </div>
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Cita-Cita</label>
                      <input id="inp_cita_cita" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="Guru, Dokter, Hafiz, dll" type="text" />
                    </div>
                  </div>
                  
                  <div class="h-px bg-[#f0f2f4] dark:bg-[#2d3748] my-2"></div>
                  
                  <!-- Contact -->
                  <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Nomor Telepon / WhatsApp <span class="text-red-500">*</span></label>
                      <input id="inp_phone" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="0812xxxxxxx" type="tel" />
                    </div>
                    <div class="flex flex-col gap-2">
                      <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Email</label>
                      <input id="inp_email" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" placeholder="contoh@email.com" type="email" />
                    </div>
                  </div>
                  <!-- Address -->
                   <div class="space-y-4">
                      <div class="flex flex-col gap-2">
                        <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Alamat Lengkap (Jalan, RT/RW, Dusun) <span class="text-red-500">*</span></label>
                        <textarea id="inp_alamat" class="w-full rounded-lg border border-[#dbdfe6] bg-white p-3 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white resize-none" rows="2" placeholder="Nama Jalan, No. Rumah, RT 01 / RW 02, Dusun..."></textarea>
                      </div>
                      
                      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                           <div class="flex flex-col gap-2">
                                <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Desa / Kelurahan <span class="text-red-500">*</span></label>
                                <input id="inp_alamat_desa" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="text" placeholder="Contoh: Sukun" />
                           </div>
                           <div class="flex flex-col gap-2">
                                <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Kecamatan <span class="text-red-500">*</span></label>
                                <input id="inp_alamat_kecamatan" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="text" placeholder="Contoh: Sukun" />
                           </div>
                      </div>

                      <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                           <div class="flex flex-col gap-2">
                                <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Kabupaten / Kota <span class="text-red-500">*</span></label>
                                <input id="inp_alamat_kabupaten" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="text" placeholder="Contoh: Malang" />
                           </div>
                           <div class="flex flex-col gap-2">
                                <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Provinsi <span class="text-red-500">*</span></label>
                                <input id="inp_alamat_provinsi" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="text" placeholder="Jawa Timur" />
                           </div>
                           <div class="flex flex-col gap-2">
                                <label class="text-sm font-medium text-[#111318] dark:text-gray-200">Kode Pos <span class="text-red-500">*</span></label>
                                <input id="inp_alamat_kodepos" class="w-full rounded-lg border border-[#dbdfe6] bg-white py-3 px-4 text-base text-[#111318] focus:border-primary focus:ring-1 dark:border-[#4a5568] dark:bg-[#2d3748] dark:text-white" type="number" placeholder="651xx" />
                           </div>
                      </div>
                  </div>
                </div>
              </div>

              <!-- STEP 2: PENDIDIKAN -->
              <div class="wizard-step hidden" id="step-2">
                <div class="border-b border-[#e5e7eb] dark:border-gray-700 bg-[#f9fafb] dark:bg-[#2d3748] px-6 py-4 flex items-center gap-3">
                  <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary/10 text-primary">
                    <span class="material-symbols-outlined text-lg">school</span>
                  </div>
                  <h3 class="text-lg font-bold text-[#111318] dark:text-white">Riwayat Pendidikan</h3>
                </div>
                
                <div class="p-6 md:p-8 space-y-6">
                   <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="flex flex-col gap-2">
                          <label class="text-[#111318] dark:text-gray-200 text-base font-medium">Asal Sekolah <span class="text-red-500">*</span></label>
                          <input id="inp_sekolah_asal" class="w-full rounded-lg border border-[#dbdfe6] bg-white h-12 p-[15px] dark:border-gray-700 dark:bg-gray-800 dark:text-white focus:border-primary" placeholder="Contoh: SMP Negeri 1 Jakarta" type="text" />
                        </div>
                        <div class="flex flex-col gap-2">
                          <label class="text-[#111318] dark:text-gray-200 text-base font-medium">NPSN Sekolah (Opsional)</label>
                          <input id="inp_npsn_sekolah" class="w-full rounded-lg border border-[#dbdfe6] bg-white h-12 p-[15px] dark:border-gray-700 dark:bg-gray-800 dark:text-white focus:border-primary" placeholder="Delapan digit kode NPSN" type="number" />
                        </div>
                   </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                       <div class="flex flex-col gap-2">
                          <label class="text-[#111318] dark:text-gray-200 text-base font-medium">Jenjang Terakhir</label>
                          <select id="inp_pendidikan_level" class="w-full rounded-lg border border-[#dbdfe6] bg-white h-12 px-[15px] dark:border-gray-700 dark:bg-gray-800 dark:text-white focus:border-primary">
                             <option value="SD">SD / Sederajat</option>
                             <option value="SMP">SMP / Sederajat</option>
                             <option value="SMA">SMA / SMK / Sederajat</option>
                          </select>
                       </div>
                       <div class="flex flex-col gap-2">
                          <label class="text-[#111318] dark:text-gray-200 text-base font-medium">Tahun Lulus</label>
                          <input id="inp_tahun_lulus" class="w-full rounded-lg border border-[#dbdfe6] bg-white h-12 p-[15px] dark:border-gray-700 dark:bg-gray-800 dark:text-white focus:border-primary" placeholder="YYYY" type="number" />
                       </div>
                    </div>
                    <div class="flex flex-col gap-2">
                      <label class="text-[#111318] dark:text-gray-200 text-base font-medium">Prestasi Akademik</label>
                      <textarea id="inp_prestasi" class="w-full rounded-lg border border-[#dbdfe6] bg-white p-[15px] dark:border-gray-700 dark:bg-gray-800 dark:text-white focus:border-primary" rows="3" placeholder="Tuliskan prestasi yang pernah diraih..."></textarea>
                    </div>

                    <!-- Divider -->
                    <div class="h-px bg-gray-200 dark:bg-gray-700 my-4"></div>
                    <h4 class="font-bold text-lg text-[#111318] dark:text-white mb-2">Data Orang Tua / Wali</h4>
                    
                    <!-- Ayah -->
                    <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg space-y-4 mb-4">
                        <h5 class="font-bold text-primary flex items-center gap-2"><span class="material-symbols-outlined">man</span> Data Ayah Kandung</h5>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Nama Ayah (Sesuai KTP)</label>
                               <input id="inp_nama_ayah" class="w-full rounded border border-gray-300 p-2" type="text" />
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">NIK Ayah</label>
                               <input id="inp_nik_ayah" class="w-full rounded border border-gray-300 p-2" type="number" placeholder="16 Digit NIK" />
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Pendidikan Terakhir</label>
                               <select id="inp_pendidikan_ayah" class="w-full rounded border border-gray-300 p-2">
                                  <option value="">Pilih...</option><option value="SD">SD/Sederajat</option><option value="SMP">SMP/Sederajat</option><option value="SMA">SMA/Sederajat</option><option value="S1">S1/Diploma 4</option><option value="S2">S2</option><option value="S3">S3</option><option value="Tidak Sekolah">Tidak Sekolah</option>
                               </select>
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Pekerjaan</label>
                               <input id="inp_pekerjaan_ayah" class="w-full rounded border border-gray-300 p-2" type="text" />
                            </div>
                            <div class="flex flex-col gap-1 md:col-span-2">
                               <label class="text-sm font-medium">Penghasilan Rata-rata / Bulan</label>
                               <select id="inp_penghasilan_ayah" class="w-full rounded border border-gray-300 p-2">
                                  <option value="">Pilih Range...</option>
                                  <option value="< 1 Juta">Kurang dari 1 Juta</option>
                                  <option value="1 - 3 Juta">1 - 3 Juta</option>
                                  <option value="3 - 5 Juta">3 - 5 Juta</option>
                                  <option value="> 5 Juta">Lebih dari 5 Juta</option>
                               </select>
                            </div>
                        </div>
                    </div>

                    <!-- Ibu -->
                    <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg space-y-4 mb-4">
                        <h5 class="font-bold text-pink-600 flex items-center gap-2"><span class="material-symbols-outlined">woman</span> Data Ibu Kandung</h5>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Nama Ibu (Sesuai KTP)</label>
                               <input id="inp_nama_ibu" class="w-full rounded border border-gray-300 p-2" type="text" />
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">NIK Ibu</label>
                               <input id="inp_nik_ibu" class="w-full rounded border border-gray-300 p-2" type="number" placeholder="16 Digit NIK" />
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Pendidikan Terakhir</label>
                               <select id="inp_pendidikan_ibu" class="w-full rounded border border-gray-300 p-2">
                                  <option value="">Pilih...</option><option value="SD">SD/Sederajat</option><option value="SMP">SMP/Sederajat</option><option value="SMA">SMA/Sederajat</option><option value="S1">S1/Diploma 4</option><option value="S2">S2</option><option value="S3">S3</option><option value="Tidak Sekolah">Tidak Sekolah</option>
                               </select>
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Pekerjaan</label>
                               <input id="inp_pekerjaan_ibu" class="w-full rounded border border-gray-300 p-2" type="text" placeholder="Ibu Rumah Tangga / Lainnya" />
                            </div>
                            <div class="flex flex-col gap-1 md:col-span-2">
                               <label class="text-sm font-medium">Penghasilan Rata-rata / Bulan</label>
                               <select id="inp_penghasilan_ibu" class="w-full rounded border border-gray-300 p-2">
                                  <option value="">Pilih Range...</option>
                                  <option value="Tidak Berpenghasilan">Tidak Berpenghasilan / IRT</option>
                                  <option value="< 1 Juta">Kurang dari 1 Juta</option>
                                  <option value="1 - 3 Juta">1 - 3 Juta</option>
                                  <option value="3 - 5 Juta">3 - 5 Juta</option>
                                  <option value="> 5 Juta">Lebih dari 5 Juta</option>
                               </select>
                            </div>
                        </div>
                    </div>

                    <!-- Wali -->
                    <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg space-y-4">
                         <h5 class="font-bold text-gray-600 dark:text-gray-300 flex items-center gap-2"><span class="material-symbols-outlined">supervisor_account</span> Data Wali (Opsional)</h5>
                         <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                             <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Nama Wali</label>
                               <input id="inp_nama_wali" class="w-full rounded border border-gray-300 p-2" type="text" />
                            </div>
                            <div class="flex flex-col gap-1">
                               <label class="text-sm font-medium">Hubungan</label>
                               <input id="inp_hubungan_wali" class="w-full rounded border border-gray-300 p-2" type="text" placeholder="Paman / Kakek / Kakak"/>
                            </div>
                         </div>
                    </div>
                </div>
              </div>

              <!-- STEP 3: BERKAS -->
              <div class="wizard-step hidden" id="step-3">
                 <div class="border-b border-[#e5e7eb] dark:border-gray-700 bg-[#f9fafb] dark:bg-[#2d3748] px-6 py-4 flex items-center gap-3">
                  <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary/10 text-primary">
                    <span class="material-symbols-outlined text-lg">folder_open</span>
                  </div>
                  <h3 class="text-lg font-bold text-[#111318] dark:text-white">Upload Dokumen</h3>
                </div>
                
                <div class="p-6 md:p-8 space-y-6">
                  <!-- KK -->
                   <div class="border rounded-lg p-4 bg-gray-50 dark:bg-gray-800 dark:border-gray-700 flex flex-col sm:flex-row items-center gap-4">
                      <div class="size-12 rounded-full bg-white dark:bg-gray-700 shadow-sm flex items-center justify-center text-primary shrink-0">
                         <span class="material-symbols-outlined text-2xl">description</span>
                      </div>
                      <div class="flex-1 text-center sm:text-left">
                         <h4 class="font-bold text-sm">Kartu Keluarga (KK)</h4>
                         <p class="text-xs text-gray-500">Foto (JPG/PNG) atau PDF Asli</p>
                      </div>
                      <input type="file" id="file_kk" accept="image/*,.pdf" class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary/10 file:text-primary hover:file:bg-primary/20" />
                   </div>
                   <!-- Foto -->
                    <div class="border rounded-lg p-4 bg-gray-50 dark:bg-gray-800 dark:border-gray-700 flex flex-col sm:flex-row items-center gap-4">
                      <div class="size-12 rounded-full bg-white dark:bg-gray-700 shadow-sm flex items-center justify-center text-primary shrink-0">
                         <span class="material-symbols-outlined text-2xl">face</span>
                      </div>
                      <div class="flex-1 text-center sm:text-left">
                         <h4 class="font-bold text-sm">Pas Foto (3x4)</h4>
                         <p class="text-xs text-gray-500">Latar merah/biru (JPG/PNG)</p>
                      </div>
                      <input type="file" id="file_foto" accept="image/*" class="text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-primary/10 file:text-primary hover:file:bg-primary/20" />
                   </div>
                </div>
              </div>

              <!-- STEP 4: KONFIRMASI -->
              <div class="wizard-step hidden" id="step-4">
                <div class="border-b border-[#e5e7eb] dark:border-gray-700 bg-[#f9fafb] dark:bg-[#2d3748] px-6 py-4 flex items-center gap-3">
                  <div class="flex h-8 w-8 items-center justify-center rounded-full bg-primary/10 text-primary">
                    <span class="material-symbols-outlined text-lg">check_circle</span>
                  </div>
                  <h3 class="text-lg font-bold text-[#111318] dark:text-white">Konfirmasi Data</h3>
                </div>
                
                <div class="p-6 md:p-8 space-y-6" id="summary-area">
                  <!-- This content will be populated by JS -->
                  <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg space-y-2">
                     <p><strong class="w-32 inline-block">Nama:</strong> <span id="summ_nama">-</span></p>
                     <p><strong class="w-32 inline-block">TTL:</strong> <span id="summ_ttl">-</span></p>
                     <p><strong class="w-32 inline-block">Telepon:</strong> <span id="summ_phone">-</span></p>
                     <p><strong class="w-32 inline-block">Gender:</strong> <span id="summ_gender">-</span></p>
                     <p><strong class="w-32 inline-block">Sekolah Asal:</strong> <span id="summ_sekolah">-</span></p>
                  </div>
                  
                  <div class="flex items-start gap-2 bg-yellow-50 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-200 p-3 rounded text-sm">
                     <span class="material-symbols-outlined text-base mt-0.5">info</span>
                     <p>Mohon periksa kembali data Anda. Setelah klik "Submit", data tidak dapat diubah secara mandiri.</p>
                  </div>

                  <div class="flex flex-col gap-2">
                    <button type="button" onclick="generatePDF()" class="flex w-full items-center justify-center gap-2 border border-gray-300 dark:border-gray-600 p-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                         <span class="material-symbols-outlined text-red-500">picture_as_pdf</span>
                         <span>Download Bukti Pendaftaran (PDF)</span>
                    </button>
                  </div>
                </div>
              </div>

              <!-- Footer Buttons -->
              <div class="bg-[#f9fafb] dark:bg-[#2d3748]/50 px-6 py-4 flex flex-col-reverse sm:flex-row items-center justify-between gap-4 border-t border-[#e5e7eb] dark:border-gray-700">
                <button type="button" id="btn-prev" onclick="changeStep(-1)" class="hidden w-full sm:w-auto px-6 py-2.5 rounded-lg border border-[#dbdfe6] dark:border-gray-600 text-[#111318] dark:text-gray-200 font-bold text-sm hover:bg-gray-50 dark:hover:bg-[#2d3748] transition-colors">
                  Kembali
                </button>
                <div class="flex gap-2 w-full sm:w-auto">
                    <button type="button" id="btn-next" onclick="changeStep(1)" class="w-full sm:w-auto flex items-center justify-center gap-2 bg-primary hover:bg-blue-700 text-white px-8 py-2.5 rounded-lg font-bold text-sm transition-all shadow-md">
                      Lanjut <span class="material-symbols-outlined text-[18px]">arrow_forward</span>
                    </button>
                    <button type="button" id="btn-submit" onclick="finalSubmit()" class="hidden w-full sm:w-auto flex items-center justify-center gap-2 bg-green-600 hover:bg-green-700 text-white px-8 py-2.5 rounded-lg font-bold text-sm transition-all shadow-md">
                      Submit & Bayar <span class="material-symbols-outlined text-[18px]">check</span>
                    </button>
                </div>
              </div>

            </form>
          </div>

          <!-- Right Column: Sidebar (4/12) -->
          <div class="lg:col-span-4 space-y-6">
            <!-- Dynamic Sidebar: Currently Active items or Help -->
            <div class="bg-primary rounded-xl p-6 text-white shadow-lg relative overflow-hidden group">
               <div class="absolute -right-6 -top-6 w-32 h-32 bg-white/10 rounded-full blur-xl"></div>
               <div class="relative z-10">
                 <h3 class="text-lg font-bold mb-2 flex items-center gap-2">
                    <span class="material-symbols-outlined">support_agent</span> Bantuan
                 </h3>
                 <p class="text-white/90 text-sm mb-4">
                   Jika ada kendala teknis atau pertanyaan, hubungi admin kami.
                 </p>
                 <a href="#" class="inline-block bg-white text-primary px-4 py-2 rounded font-bold text-xs uppercase tracking-wider">Chat WhatsApp</a>
               </div>
            </div>

            <!-- Requirements Card (Static for ref) -->
            <div class="bg-white dark:bg-[#1a202c] rounded-xl border border-[#e5e7eb] dark:border-gray-700 p-6 shadow-sm">
              <h3 class="text-base font-bold text-[#111318] dark:text-white mb-4 flex items-center gap-2">
                <span class="material-symbols-outlined text-primary">description</span>
                Syarat Pendaftaran
              </h3>
               <ul class="space-y-3 text-sm text-gray-600 dark:text-gray-400">
                <li class="flex gap-2"><span class="material-symbols-outlined text-green-500 text-sm mt-0.5">check</span> Mengisi Formulir Online</li>
                <li class="flex gap-2"><span class="material-symbols-outlined text-green-500 text-sm mt-0.5">check</span> Upload Scan KK & Akta</li>
                <li class="flex gap-2"><span class="material-symbols-outlined text-green-500 text-sm mt-0.5">check</span> Upload Pas Foto</li>
                <li class="flex gap-2"><span class="material-symbols-outlined text-green-500 text-sm mt-0.5">check</span> Membayar Biaya Pendaftaran</li>
              </ul>
            </div>
          </div>
      </div>
    </div>
</main>
<?php
// Get Dynamic Options for PDF
$pdf_settings = array(
    'school_name' => 'YAYASAN PONDOK PESANTREN NURUL HUDA',
    'address_1'   => get_option('office_address', 'Jln. Pesantren No. 99, Jawa Timur'),
    'contact'     => 'Telp: '.get_option('phone_number','-').' | Email: '.get_option('email_address','-'),
    'web'         => 'Web: ' . $_SERVER['HTTP_HOST']
);

// === FORM SEEDER (Aktivasi dengan ?demo=1) ===
$is_demo_mode = isset($_GET['demo']) && $_GET['demo'] == '1';
?>
<script>
// Pass PHP Settings to JS
window.pondokPdfSettings = <?php echo json_encode($pdf_settings); ?>;

<?php if($is_demo_mode): ?>
// === AUTO-FILL DEMO DATA (SIMPLE VERSION) ===
window.addEventListener('load', function() {
    console.log('🎯 DEMO MODE - Filling form data...');
    
    setTimeout(function() {
        // Simple fill helper
        const f = (id, val) => {
            const el = document.getElementById(id);
            if(el) el.value = val;
        };
        
        // Fill all fields
        f('inp_nama', 'Ahmad Fulan Bin Fulan');
        f('inp_jenjang', 'Wustho');
        f('inp_nisn', '1234567890');
        f('inp_nik', '3507123456780001');
        f('inp_no_kk', '3507987654321098');
        f('inp_gender', 'Laki-laki');
        f('inp_anak_ke', '2');
        f('inp_jumlah_saudara', '3');
        f('inp_tempat_lahir', 'Malang');
        f('inp_tanggal_lahir', '2010-01-01');
        f('inp_hobi', 'Membaca, Futsal');
        f('inp_cita_cita', 'Hafiz Al-Quran');
        f('inp_phone', '08123456789');
        f('inp_email', 'ahmad@example.com');
        f('inp_alamat', 'Jl. Pesantren No. 123');
        f('inp_alamat_desa', 'Sukamaju');
        f('inp_alamat_kecamatan', 'Sukun');
        f('inp_alamat_kabupaten', 'Kab. Malang');
        f('inp_alamat_provinsi', 'Jawa Timur');
        f('inp_alamat_kodepos', '65153');
        f('inp_sekolah_asal', 'SDIT Al-Hikmah');
        f('inp_npsn_sekolah', '12345678');
        f('inp_tahun_lulus', '2024');
        f('inp_nama_ayah', 'Abdullah bin Ahmad');
        f('inp_nik_ayah', '3507111111111111');
        f('inp_pendidikan_ayah', 'S1');
        f('inp_pekerjaan_ayah', 'Guru');
        f('inp_penghasilan_ayah', '3 - 5 Juta');
        f('inp_nama_ibu', 'Aminah binti Yusuf');
        f('inp_nik_ibu', '3507222222222222');
        f('inp_pendidikan_ibu', 'SMA');
        f('inp_pekerjaan_ibu', 'Ibu Rumah Tangga');
        f('inp_penghasilan_ibu', 'Tidak Berpenghasilan');
        
        console.log('✅ Data filled successfully!');
        alert('✅ DEMO MODE\n\nSemua data sudah terisi!\nSilakan klik tombol "Lanjut" 3x untuk sampai ke halaman konfirmasi.');
    }, 300);
});
<?php endif; ?>
</script>

<script>
let currentStep = 1;
const totalSteps = 4;
console.log("SCRIPT UPDATE TERBARU - v3.0 (FormData & Safety Check Active)"); // Check Console for this!

console.log("SCRIPT UPDATE TERBARU - v4.0 (Pro PDF + Test Mode)"); 

function changeStep(direction) {
    const newStep = currentStep + direction;
    
    // Validation on Next
    if(direction === 1) {
        if(!validateStep(currentStep)) return;
    }

    if (newStep >= 1 && newStep <= totalSteps) {
        // Hide current
        document.getElementById(`step-${currentStep}`).classList.add('hidden');
        
        // Show new
        document.getElementById(`step-${newStep}`).classList.remove('hidden');
        document.getElementById(`step-${newStep}`).classList.add('fade-in-up'); // Add animation class if css exists
        
        currentStep = newStep;
        updateUI();
        
        if(currentStep === 4) {
            populateSummary();
        }
    }
}

function updateUI() {
    // Buttons
    const btnPrev = document.getElementById('btn-prev');
    const btnNext = document.getElementById('btn-next');
    const btnSubmit = document.getElementById('btn-submit');

    if(currentStep === 1) btnPrev.classList.add('hidden'); else btnPrev.classList.remove('hidden');
    
    if(currentStep === totalSteps) {
        btnNext.classList.add('hidden');
        btnSubmit.classList.remove('hidden');
    } else {
        btnNext.classList.remove('hidden');
        btnSubmit.classList.add('hidden');
    }

    // Progress Bar
    const percent = (currentStep / totalSteps) * 100;
    document.getElementById('main-progress-bar').style.width = `${percent}%`;
    document.getElementById('step-percent-label').innerText = `${percent}% Selesai`;
    document.getElementById('step-count-label').innerText = `Langkah ${currentStep} dari ${totalSteps}`;

    // Indicators
    document.querySelectorAll('.step-ind').forEach(el => {
        const step = parseInt(el.getAttribute('data-step'));
        if(step <= currentStep) {
            el.classList.remove('opacity-50');
            el.classList.add('text-primary');
        } else {
            el.classList.add('opacity-50');
            el.classList.remove('text-primary');
        }
    });
}

function validateStep(step) {
    // Simple validation
    if(step === 1) {
        const name = document.getElementById('inp_nama').value;
        if(!name) { alert('Nama Lengkap wajib diisi'); return false; }
    }
    return true;
}

function populateSummary() {
    // Populate Summary
    document.getElementById('summ_nama').innerText = document.getElementById('inp_nama').value || '-';
    document.getElementById('summ_ttl').innerText = (document.getElementById('inp_tempat_lahir').value || '-') + ', ' + (document.getElementById('inp_tanggal_lahir').value || '-');
    document.getElementById('summ_phone').innerText = document.getElementById('inp_phone').value || '-';
    document.getElementById('summ_gender').innerText = document.getElementById('inp_gender').value || '-';
    document.getElementById('summ_sekolah').innerText = document.getElementById('inp_sekolah_asal').value || '-';
    
    // Create extra summary for Parents if needed (Dynamic append)
    const summaryArea = document.getElementById('summary-area');
    let parentInfo = document.getElementById('parent-summary-extra');
    
    if(!parentInfo) {
        parentInfo = document.createElement('div');
        parentInfo.id = 'parent-summary-extra';
        parentInfo.className = 'bg-blue-50 dark:bg-gray-800 p-4 rounded-lg space-y-2 text-sm';
        // Insert after the first summary box
        summaryArea.insertBefore(parentInfo, summaryArea.children[1]); 
    }
    
    parentInfo.innerHTML = `
        <h4 class="font-bold border-b pb-1 mb-2">Data Orang Tua</h4>
        <p><strong class="w-32 inline-block">Ayah:</strong> ${document.getElementById('inp_nama_ayah').value || '-'} (NIK: ${document.getElementById('inp_nik_ayah').value || '-'})</p>
        <p><strong class="w-32 inline-block">Ibu:</strong> ${document.getElementById('inp_nama_ibu').value || '-'} (NIK: ${document.getElementById('inp_nik_ibu').value || '-'})</p>
    `;
}

function finalSubmit() {
    const btnSubmit = document.getElementById('btn-submit');
    
    // Safety Helper
    const getVal = (id) => document.getElementById(id)?.value || '';

    // 1. Validate Critical Fields (Direct Check)
    const nama = getVal('inp_nama');
    const nisn = getVal('inp_nisn');

    if(!nama || !nisn) {
        alert('Mohon lengkapi Nama dan NISN di Langkah 1!');
        // Try to navigate to step 1 logic if accessible, else just alert
        if(typeof changeStep === 'function') {
            // Primitive reset to step 1 logic (assuming global vars)
            // But safest is just alert.
        }
        return;
    }

    // 2. UI Loading
    if(!confirm("Apakah Anda yakin data sudah benar?")) return;
    
    btnSubmit.innerHTML = `<span class="material-symbols-outlined animate-spin mr-2 text-sm">progress_activity</span> Mengirim...`;
    btnSubmit.disabled = true;

    // 3. Prepare FormData
    const formDataObj = new FormData();
    formDataObj.append('action', 'pondok_submit_psb');
    
    // Biodata
    formDataObj.append('nama', nama);
    formDataObj.append('nisn', nisn);
    formDataObj.append('nik', getVal('inp_nik'));
    formDataObj.append('no_kk', getVal('inp_no_kk')); // NEW
    formDataObj.append('jenjang', getVal('inp_jenjang'));
    formDataObj.append('tempat_lahir', getVal('inp_tempat_lahir'));
    formDataObj.append('tanggal_lahir', getVal('inp_tanggal_lahir'));
    formDataObj.append('gender', getVal('inp_gender'));
    formDataObj.append('anak_ke', getVal('inp_anak_ke')); // NEW
    formDataObj.append('jumlah_saudara', getVal('inp_jumlah_saudara')); // NEW
    formDataObj.append('hobi', getVal('inp_hobi')); // NEW
    formDataObj.append('cita_cita', getVal('inp_cita_cita')); // NEW
    
    // Sekolah
    formDataObj.append('asal_sekolah', getVal('inp_sekolah_asal'));
    formDataObj.append('npsn_sekolah', getVal('inp_npsn_sekolah')); // NEW
    
    // Kontak & Alamat
    formDataObj.append('alamat', getVal('inp_alamat'));
    formDataObj.append('alamat_desa', getVal('inp_alamat_desa')); // NEW
    formDataObj.append('alamat_kecamatan', getVal('inp_alamat_kecamatan')); // NEW
    formDataObj.append('alamat_kabupaten', getVal('inp_alamat_kabupaten')); // NEW
    formDataObj.append('alamat_provinsi', getVal('inp_alamat_provinsi')); // NEW
    formDataObj.append('alamat_kodepos', getVal('inp_alamat_kodepos')); // NEW
    formDataObj.append('telepon', getVal('inp_phone'));
    formDataObj.append('email', getVal('inp_email'));
    
    // Ortu
    // Ayah
    formDataObj.append('nama_ayah', getVal('inp_nama_ayah'));
    formDataObj.append('nik_ayah', getVal('inp_nik_ayah')); // NEW
    formDataObj.append('pekerjaan_ayah', getVal('inp_pekerjaan_ayah'));
    formDataObj.append('pendidikan_ayah', getVal('inp_pendidikan_ayah')); // NEW
    formDataObj.append('penghasilan_ayah', getVal('inp_penghasilan_ayah')); // NEW
    
    // Ibu
    formDataObj.append('nama_ibu', getVal('inp_nama_ibu'));
    formDataObj.append('nik_ibu', getVal('inp_nik_ibu')); // NEW
    formDataObj.append('pekerjaan_ibu', getVal('inp_pekerjaan_ibu')); // NEW
    formDataObj.append('pendidikan_ibu', getVal('inp_pendidikan_ibu')); // NEW
    formDataObj.append('penghasilan_ibu', getVal('inp_penghasilan_ibu')); // NEW
    
    // Wali
    formDataObj.append('nama_wali', getVal('inp_nama_wali'));
    formDataObj.append('hubungan_wali', getVal('inp_hubungan_wali')); // NEW

    // Image Uploads (Validation)
    const fileKK = document.getElementById('file_kk')?.files[0];
    if(fileKK) {
        // Updated: Allow PDF for KK
        if(!['image/jpeg', 'image/png', 'image/jpg', 'application/pdf'].includes(fileKK.type)) {
            alert('File KK harus berupa Foto (JPG/PNG) atau PDF!');
            btnSubmit.disabled = false;
            btnSubmit.innerHTML = 'Submit & Bayar';
            return;
        }
        formDataObj.append('file_kk', fileKK);
    }

    const fileFoto = document.getElementById('file_foto')?.files[0];
    if(fileFoto) {
        if(!['image/jpeg', 'image/png', 'image/jpg'].includes(fileFoto.type)) {
            alert('File Pas Foto harus berupa gambar (JPG/PNG)!');
            btnSubmit.disabled = false;
            btnSubmit.innerHTML = 'Submit & Bayar';
            return;
        }
        formDataObj.append('file_foto', fileFoto);
    }

    const ajaxUrl = "<?php echo admin_url('admin-ajax.php'); ?>";
    console.log('Sending to:', ajaxUrl); // Debug URL

    fetch(ajaxUrl, {
        method: 'POST',
        body: formDataObj
    })
    .then(async response => {
        const text = await response.text(); // Get raw text first
        try {
            const data = JSON.parse(text); // Try parsing JSON
            if(data.success) {
                // Success Scenario - NO POPUP, Direct Action
                
                // 1. Generate PDF with Server UUID & Code
                try { 
                    generatePDF(data.data.uuid, data.data.reg_code); 
                } catch(e) { 
                    console.error('PDF Fail', e); 
                }
                
                btnSubmit.innerHTML = `Berhasil! Mengalihkan... <span class="material-symbols-outlined text-sm ml-1">check</span>`;
                
                // 2. Redirect to Payment Page (Slight delay to allow PDF download start)
                if(data.data.redirect_url) {
                    setTimeout(() => window.location.href = data.data.redirect_url, 1000);
                } else {
                     window.location.reload();
                }
            } else {
                // Logic Failure (e.g. empty name)
                throw new Error(data.data ? data.data.message : 'Respon server tidak valid.');
            }
        } catch (e) {
            // JSON Parse Error or Logic Error
            console.error('Raw Server Response:', text);
            alert('❌ Gagal Memproses Data.\n\nError: ' + e.message);
            throw e; // Pass to catch block to reset button
        }
    })
    .catch(error => {
        console.error('Final Submission Error:', error);
        // Specialized error message for Fetch Failure
        let msg = error.message;
        if(msg.includes('Failed to fetch')) {
            msg = 'Koneksi ke Server Gagal (Failed to fetch).\nURL Tujuan: ' + ajaxUrl + '\n\nPastikan Localhost Anda aktif dan URL ini benar.';
        }
        alert('⚠️ Terjadi Kesalahan:\n' + msg);
        
        // Reset Button
        btnSubmit.innerHTML = `Coba Lagi <span class="material-symbols-outlined text-sm ml-1">refresh</span>`;
        btnSubmit.disabled = false;
    });
}

// PDF Generation using jsPDF - SAFE MODE
try {
    if(typeof window.jspdf !== 'undefined') {
        window.jsPDF = window.jspdf.jsPDF;
    } else {
        console.error('⚠️ jsPDF library belum ter-load! Cek CDN atau internet.');
    }
} catch(e) {
    console.error('Error loading jsPDF:', e);
}

function generatePDF(serverUuid = null, regCode = null) {
    // 1. Generate QR (Hidden)
    const qrContainer = document.createElement('div');
    const qrId = 'qrcode_temp_' + Date.now();
    qrContainer.id = qrId;
    qrContainer.style.display = 'none';
    document.body.appendChild(qrContainer);

    const qrContent = serverUuid ? "<?php echo home_url('/pembayaran-psb/'); ?>" + serverUuid : "DEMO";
    new QRCode(qrContainer, { text: qrContent, width: 256, height: 256, correctLevel : QRCode.CorrectLevel.M });

    setTimeout(() => {
        const qrCanvas = qrContainer.querySelector('canvas');
        let qrDataUrl = qrCanvas ? qrCanvas.toDataURL("image/png") : null;
        if(!qrDataUrl) {
           const qrImg = qrContainer.querySelector('img');
           if(qrImg) qrDataUrl = qrImg.src;
        }
        document.body.removeChild(qrContainer);

        // 2. Init Minimalist PDF
        const doc = new jsPDF('p', 'mm', 'a4');
        const W = doc.internal.pageSize.width;
        const H = doc.internal.pageSize.height;
        const margin = 20;
        const contentW = W - (margin * 2);
        
        // --- PALETTE (Modern Slate & Emerald) ---
        const colTextMain = [15, 23, 42];  // Slate 900
        const colTextLight = [100, 116, 139]; // Slate 500
        const colAccent = [16, 185, 129]; // Emerald 500
        const colLine = [226, 232, 240]; // Slate 200
        const colBgHeader = [248, 250, 252]; // Slate 50

        // --- HEADER (Simple & Clean) ---
        // Top Green Strip
        doc.setFillColor(...colAccent);
        doc.rect(0, 0, W, 2, 'F');
        
        let y = 20;

        // Logo (Left)
        doc.setFillColor(...colAccent);
        doc.circle(margin + 5, y + 2, 6, 'F');
        doc.setTextColor(255);
        doc.setFontSize(8);
        doc.setFont("helvetica", "bold");
        doc.text("NH", margin + 5, y + 3, {align:'center'});

        // School Name
        doc.setTextColor(...colTextMain);
        doc.setFontSize(12);
        const pdfConf = window.pondokPdfSettings || {};
        doc.text(pdfConf.school_name || "PONDOK PESANTREN NURUL HUDA", margin + 18, y + 4);

        // Right Info (Date)
        doc.setFontSize(9);
        doc.setTextColor(...colTextLight);
        doc.setFont("helvetica", "normal");
        const today = new Date().toLocaleDateString('id-ID', {day: 'numeric', month: 'long', year: 'numeric'});
        doc.text(today, W - margin, y + 4, {align:'right'});

        // Divider
        y += 15;
        doc.setDrawColor(...colLine);
        doc.line(margin, y, W - margin, y);

        // --- HERO SECTION ---
        y += 15;
        doc.setFontSize(10);
        doc.setTextColor(...colTextLight);
        doc.text("BUKTI REGISTRASI", margin, y);
        
        y += 8;
        doc.setFontSize(24);
        doc.setTextColor(...colTextMain);
        doc.setFont("helvetica", "bold");
        const nama = document.getElementById('inp_nama')?.value || 'Nama Santri';
        doc.text(nama.toUpperCase(), margin, y);

        // Registration ID Badge styling
        const regId = regCode || "DRAFT-001";
        doc.setFontSize(10);
        doc.setFont("courier", "bold");
        doc.setTextColor(...colAccent);
        doc.text("#" + regId, margin, y + 6);

        // --- DATA GRID (Clean Lines) ---
        y += 20;
        
        // Helper function
        const getV = (id) => document.getElementById(id)?.value || '-';
        
        // === DATA PRIBADI (Table Style) ===
        y += 18;
        doc.setFillColor(16, 185, 129);
        doc.rect(margin, y, contentW, 7, 'F');
        doc.setFontSize(10);
        doc.setTextColor(255, 255, 255);
        doc.setFont("helvetica", "bold");
        doc.text("A. DATA PRIBADI", margin + 3, y + 4.5);
        
        y += 10;
        const pribadi = [
            ['Nama Lengkap', nama.toUpperCase()],
            ['NIK', getV('inp_nik')],
            ['No. Kartu Keluarga', getV('inp_no_kk')],
            ['NISN', getV('inp_nisn')],
            ['Tempat, Tanggal Lahir', getV('inp_tempat_lahir') + ', ' + getV('inp_tanggal_lahir')],
            ['Jenis Kelamin', getV('inp_gender')],
            ['No. Telepon / WA', getV('inp_phone')],
            ['Email', getV('inp_email') || '-'],
            ['Alamat', getV('inp_alamat') + ', ' + getV('inp_alamat_desa') + ', ' + getV('inp_alamat_kecamatan') + ', ' + getV('inp_alamat_kabupaten')]
        ];
        
        pribadi.forEach(([label, value], idx) => {
            // Background stripe
            if(idx % 2 === 0) {
                doc.setFillColor(248, 250, 252);
                doc.rect(margin, y - 1, contentW, 6, 'F');
            }
            
            doc.setFont("helvetica", "normal");
            doc.setFontSize(8);
            doc.setTextColor(100, 116, 139);
            doc.text(label, margin + 2, y + 3);
            
            doc.setFont("helvetica", "bold");
            doc.setFontSize(8);
            doc.setTextColor(15, 23, 42);
            doc.text(value.substring(0, 50), margin + 60, y + 3);
            
            y += 6;
        });
        
        // === PENDIDIKAN ===
        y += 5;
        doc.setFillColor(16, 185, 129);
        doc.rect(margin, y, contentW, 7, 'F');
        doc.setFontSize(10);
        doc.setTextColor(255, 255, 255);
        doc.setFont("helvetica", "bold");
        doc.text("B. RIWAYAT PENDIDIKAN", margin + 3, y + 4.5);
        
        y += 10;
        const pendidikan = [
            ['Asal Sekolah', getV('inp_sekolah_asal')],
            ['NPSN', getV('inp_npsn_sekolah') || '-'],
            ['Tahun Lulus', getV('inp_tahun_lulus') || '-'],
            ['Jenjang Yang Dituju', getV('inp_jenjang')]
        ];
        
        pendidikan.forEach(([label, value], idx) => {
            if(idx % 2 === 0) {
                doc.setFillColor(248, 250, 252);
                doc.rect(margin, y - 1, contentW, 6, 'F');
            }
            
            doc.setFont("helvetica", "normal");
            doc.setFontSize(8);
            doc.setTextColor(100, 116, 139);
            doc.text(label, margin + 2, y + 3);
            
            doc.setFont("helvetica", "bold");
            doc.setFontSize(8);
            doc.setTextColor(15, 23, 42);
            doc.text(value, margin + 60, y + 3);
            
            y += 6;
        });
        
        // === ORANG TUA ===
        y += 5;
        doc.setFillColor(16, 185, 129);
        doc.rect(margin, y, contentW, 7, 'F');
        doc.setFontSize(10);
        doc.setTextColor(255, 255, 255);
        doc.setFont("helvetica", "bold");
        doc.text("C. DATA ORANG TUA", margin + 3, y + 4.5);
        
        y += 10;
        const ortu = [
            ['Nama Ayah', getV('inp_nama_ayah')],
            ['Pekerjaan Ayah', getV('inp_pekerjaan_ayah') || '-'],
            ['Nama Ibu', getV('inp_nama_ibu')],
            ['Pekerjaan Ibu', getV('inp_pekerjaan_ibu') || '-']
        ];
        
        ortu.forEach(([label, value], idx) => {
            if(idx % 2 === 0) {
                doc.setFillColor(248, 250, 252);
                doc.rect(margin, y - 1, contentW, 6, 'F');
            }
            
            doc.setFont("helvetica", "normal");
            doc.setFontSize(8);
            doc.setTextColor(100, 116, 139);
            doc.text(label, margin + 2, y + 3);
            
            doc.setFont("helvetica", "bold");
            doc.setFontSize(8);
            doc.setTextColor(15, 23, 42);
            doc.text(value, margin + 60, y + 3);
            
            y += 6;
        });
        
        // === INSTRUKSI PEMBAYARAN ===
        y += 10;
        doc.setFillColor(254, 243, 199);
        doc.roundedRect(margin, y, contentW, 20, 2, 2, 'F');
        doc.setFontSize(8);
        doc.setTextColor(146, 64, 14);
        doc.setFont("helvetica", "bold");
        doc.text("LANGKAH SELANJUTNYA:", margin + 3, y + 6);
        doc.setFont("helvetica", "normal");
        doc.text("Silakan akses link berikut untuk melanjutkan pembayaran:", margin + 3, y + 11);
        doc.setTextColor(16, 185, 129);
        doc.setFont("helvetica", "bold");
        const payLink = "<?php echo home_url('/pembayaran-psb/'); ?>" + (serverUuid || "...");
        doc.text(payLink, margin + 3, y + 16);

        // === FOOTER ===
        const fY = H - 45;
        
        // QR
        if(qrDataUrl) {
            doc.addImage(qrDataUrl, 'PNG', W - margin - 28, fY, 28, 28);
        }

        // Legal
        doc.setFontSize(7);
        doc.setTextColor(148, 163, 184);
        doc.text("Dokumen ini sah dan diproses otomatis.", margin, fY + 10);
        doc.text("© " + new Date().getFullYear() + " Pondok Pesantren Nurul Huda", margin, fY + 15);

        // SAVE PDF  
        doc.save("Bukti_Pendaftaran_" + nama.replace(/\s+/g, '_') + ".pdf");
    
    }, 100);
}
</script>

<?php get_footer(); ?>
