<?php
// Snippet to be inserted into page-kurikulum.php or used as reference
// Get Jadwal Data
$all_jadwal = get_option('pondok_jadwal_list', array());
$display_jadwal = array();

// Helper to sort days
$day_order = array('Senin' => 1, 'Selasa' => 2, 'Rabu' => 3, 'Kamis' => 4, 'Jumat' => 5, 'Sabtu' => 6, 'Ahad' => 7);

foreach($all_jadwal as $j) {
    // Filter Logic matches Silabus logic
    if(!empty($focus_level)) {
        $j_lvl = isset($j['tingkat']) ? trim($j['tingkat']) : ''; // Key is 'tingkat' in jadwal settings
        
        $match = false;
        if(strcasecmp($j_lvl, $focus_level) == 0) $match = true;
        if (!$match && !empty($focus_level) && stripos($j_lvl, $focus_level) !== false) $match = true;
        
        // Cross-check Wustho/a
        if (!$match && (strcasecmp($focus_level, 'Wustho') == 0 || strcasecmp($focus_level, 'Wustha') == 0)) {
            if (strcasecmp($j_lvl, 'Wustho') == 0 || strcasecmp($j_lvl, 'Wustha') == 0) {
                $match = true;
            }
        }
        
        // Allow general/empty level
        if(empty($j_lvl)) $match = true;

        if(!$match) continue;
    }
    $display_jadwal[] = $j;
}

// Group by Day
$grouped_jadwal = array();
foreach($display_jadwal as $j) {
    // Basic validation
    if(empty($j['hari'])) continue;
    $h = ucfirst(strtolower($j['hari']));
    $grouped_jadwal[$h][] = $j;
}

// Sort Days
uksort($grouped_jadwal, function($a, $b) use ($day_order) {
    $oa = isset($day_order[$a]) ? $day_order[$a] : 99;
    $ob = isset($day_order[$b]) ? $day_order[$b] : 99;
    return $oa - $ob;
});

// If not empty, render section
if(!empty($grouped_jadwal)):
?>
      <!-- Jadwal KBM Section -->
      <div class="w-full bg-gray-50 dark:bg-[#15171e] py-12 border-t border-gray-200 dark:border-gray-800">
        <div class="flex justify-center px-4">
          <div class="flex flex-col max-w-[1200px] w-full gap-8">
            <div class="text-center">
              <h2 class="text-[#111318] dark:text-white text-2xl font-bold leading-tight mb-2">
                Jadwal Pelajaran Pekanan <?php echo $focus_level ? "($focus_level)" : ''; ?>
              </h2>
              <p class="text-gray-500 dark:text-gray-400">
                Jadwal Kegiatan Belajar Mengajar (KBM) aktif.
              </p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach($grouped_jadwal as $day => $items): ?>
                <div class="flex flex-col bg-white dark:bg-[#1a202c] rounded-xl border border-gray-200 dark:border-gray-700 overflow-hidden">
                    <div class="bg-primary/10 px-4 py-3 border-b border-primary/10">
                        <h3 class="font-bold text-lg text-primary"><?php echo esc_html($day); ?></h3>
                    </div>
                    <div class="divide-y divide-gray-100 dark:divide-gray-800">
                        <?php 
                        // Sort items by time?
                        usort($items, function($a, $b) {
                            return strcmp($a['jam_mulai'], $b['jam_mulai']);
                        });
                        
                        foreach($items as $item): ?>
                        <div class="p-4 hover:bg-gray-50 dark:hover:bg-gray-800/50 transition-colors">
                            <div class="flex justify-between items-start mb-1">
                                <span class="text-xs font-bold px-2 py-0.5 rounded bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300">
                                    <?php echo esc_html($item['jam_mulai'] . ' - ' . $item['jam_selesai']); ?>
                                </span>
                                <span class="text-xs text-gray-400 truncate max-w-[80px]" title="<?php echo esc_attr($item['ruang']); ?>">
                                    <?php echo esc_html($item['ruang']); ?>
                                </span>
                            </div>
                            <h4 class="font-bold text-[#111318] dark:text-white text-sm mb-0.5"><?php echo esc_html($item['mapel']); ?></h4>
                            <div class="flex items-center gap-2 text-xs text-gray-500 dark:text-gray-400">
                                <span class="material-symbols-outlined text-[14px]">person</span>
                                <?php echo esc_html($item['pengajar']); ?>
                                <?php if(!empty($item['kelas'])): ?>
                                    <span class="text-gray-300">•</span>
                                    <span><?php echo esc_html($item['kelas']); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

          </div>
        </div>
      </div>
<?php endif; ?>
